/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.econ;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import exerelin.campaign.events.MarketAttackedEvent;
import java.util.Map;

public class MarketAttackedCondition
extends BaseMarketConditionPlugin {
    private MarketAttackedEvent event = null;

    public void apply(String id) {
        if (this.event == null) {
            Global.getLogger(((Object)((Object)this)).getClass()).info((Object)"ERROR: Event is null, re-fetching");
            this.event = (MarketAttackedEvent)Global.getSector().getEventManager().getOngoingEvent(new CampaignEventTarget(this.market), "exerelin_market_attacked");
        }
        this.market.getStability().modifyFlat(id, (float)(-1 * this.event.getStabilityPenalty()), "Market attacked");
    }

    public void unapply(String id) {
        this.market.getStability().unmodify(id);
    }

    public Map<String, String> getTokenReplacements() {
        Map tokens = super.getTokenReplacements();
        int penalty = this.event.getStabilityPenalty();
        tokens.put("$stabilityPenalty", "" + penalty);
        return tokens;
    }

    public void setParam(Object param) {
        Global.getLogger(((Object)((Object)this)).getClass()).info((Object)("Setting param, " + (param != null && param instanceof MarketAttackedEvent)));
        this.event = (MarketAttackedEvent)((Object)param);
    }

    public String[] getHighlights() {
        return new String[]{"" + this.event.getStabilityPenalty()};
    }
}

