/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.econ;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;

public class SupplyWorkshop
extends BaseMarketConditionPlugin {
    public static final float WORKSHOP_VOLATILES = 250.0f;
    public static final float WORKSHOP_ORGANICS = 250.0f;
    public static final float WORKSHOP_METALS = 250.0f;
    public static final float WORKSHOP_RARE_METALS = 25.0f;
    public static final float WORKSHOP_HEAVY_MACHINERY_DEMAND = 40.0f;
    public static final float WORKSHOP_HEAVY_MACHINERY = 0.0f;
    public static final float WORKSHOP_SUPPLIES = 1000.0f;
    public static final float WORKSHOP_HAND_WEAPONS = 500.0f;

    public void apply(String id) {
        float sizeMult = this.getBaseSizeMult();
        if (this.market.getSize() >= 4) {
            this.market.getDemand("heavy_machinery").getDemand().modifyFlat(id, 40.0f * sizeMult);
        }
        this.market.getDemand("volatiles").getDemand().modifyFlat(id, 250.0f * sizeMult);
        this.market.getDemand("organics").getDemand().modifyFlat(id, 250.0f * sizeMult);
        this.market.getDemand("metals").getDemand().modifyFlat(id, 250.0f * sizeMult);
        this.market.getDemand("rare_metals").getDemand().modifyFlat(id, 25.0f * sizeMult);
        float productionMult = SupplyWorkshop.getProductionMult((MarketAPI)this.market, (String[])new String[]{"organics", "volatiles", "metals", "rare_metals"}) * sizeMult;
        this.market.getCommodityData("supplies").getSupply().modifyFlat(id, 1000.0f * productionMult);
        this.market.getCommodityData("hand_weapons").getSupply().modifyFlat(id, 500.0f * productionMult);
    }

    public void unapply(String id) {
        this.market.getDemand("heavy_machinery").getDemand().unmodify(id);
        this.market.getDemand("volatiles").getDemand().unmodify(id);
        this.market.getDemand("organics").getDemand().unmodify(id);
        this.market.getDemand("metals").getDemand().unmodify(id);
        this.market.getDemand("rare_metals").getDemand().unmodify(id);
        this.market.getCommodityData("supplies").getSupply().unmodify(id);
        this.market.getCommodityData("hand_weapons").getSupply().unmodify(id);
    }
}

