/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import exerelin.utilities.StringHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AgentDestabilizeMarketEventForCondition
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(AgentDestabilizeMarketEventForCondition.class);
    public static final float DAYS_PER_STAGE = 20.0f;
    protected float elapsedDays = 0.0f;
    protected String conditionToken = null;
    protected int stabilityPenalty = 0;
    protected Map<String, Object> params;
    protected boolean ended = false;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        if (this.params.containsKey("stabilityPenalty")) {
            this.stabilityPenalty = (Integer)this.params.get("stabilityPenalty");
        }
    }

    public void startEvent() {
        super.startEvent();
        if (this.market == null) {
            this.endEvent();
            return;
        }
        this.conditionToken = this.market.addCondition("exerelin_agent_destabilize_condition", true, (Object)this);
    }

    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.elapsedDays >= 20.0f) {
            this.elapsedDays -= 20.0f;
            --this.stabilityPenalty;
            this.market.reapplyCondition(this.conditionToken);
        }
        if (this.stabilityPenalty <= 0) {
            this.endEvent();
        }
    }

    public void endEvent() {
        if (this.market != null && this.conditionToken != null) {
            this.market.removeSpecificCondition(this.conditionToken);
        }
        this.ended = true;
    }

    public boolean isDone() {
        return this.ended;
    }

    public int getStabilityPenalty() {
        return this.stabilityPenalty;
    }

    public void setStabilityPenalty(int stabilityPenalty) {
        this.stabilityPenalty = stabilityPenalty;
        if (stabilityPenalty <= 0) {
            this.endEvent();
        } else {
            this.market.reapplyCondition(this.conditionToken);
        }
    }

    public void increaseStabilityPenalty(int penalty) {
        this.stabilityPenalty += penalty;
        if (this.stabilityPenalty <= 0) {
            this.endEvent();
        } else {
            this.market.reapplyCondition(this.conditionToken);
        }
    }

    public void reduceStabilityPenalty(int penalty) {
        this.stabilityPenalty -= penalty;
        if (this.stabilityPenalty <= 0) {
            this.endEvent();
        } else {
            this.market.reapplyCondition(this.conditionToken);
        }
    }

    public String getEventName() {
        return StringHelper.getStringAndSubstituteToken("exerelin_events", "agentDestabilizeMarket", "$market", this.market.getName());
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.EVENT;
    }
}

