/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import exerelin.campaign.ExerelinReputationAdjustmentResult;
import exerelin.campaign.events.CovertOpsEventBase;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class AgentLowerRelationsEvent
extends CovertOpsEventBase {
    public static Logger log = Global.getLogger(AgentLowerRelationsEvent.class);
    protected float repEffect2;
    protected ExerelinReputationAdjustmentResult repResult2;
    protected FactionAPI thirdFaction;

    @Override
    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.repEffect2 = 0.0f;
        this.thirdFaction = null;
    }

    @Override
    public void setParam(Object param) {
        super.setParam(param);
        this.thirdFaction = (FactionAPI)this.params.get("thirdFaction");
        if (this.params.containsKey("repEffect2")) {
            this.repEffect2 = ((Float)this.params.get("repEffect2")).floatValue();
            this.repResult2 = (ExerelinReputationAdjustmentResult)((Object)this.params.get("repResult2"));
        }
    }

    @Override
    public Map<String, String> getTokenReplacements() {
        Map<String, String> map = super.getTokenReplacements();
        AgentLowerRelationsEvent.addFactionNameTokens(map, (String)"third", (FactionAPI)this.thirdFaction);
        map.put("$repEffectAbs", "" + (int)Math.ceil(Math.abs(this.repEffect * 100.0f)));
        map.put("$repEffectAbs2", "" + (int)Math.ceil(Math.abs(this.repEffect2 * 100.0f)));
        map.put("$newRelationStr", AgentLowerRelationsEvent.getNewRelationStr(this.agentFaction, this.faction));
        if (this.result.isSucessful()) {
            map.put("$newRelationStr2", AgentLowerRelationsEvent.getNewRelationStr(this.faction, this.thirdFaction));
        } else {
            map.put("$newRelationStr2", AgentLowerRelationsEvent.getNewRelationStr(this.agentFaction, this.thirdFaction));
        }
        return map;
    }

    @Override
    public String[] getHighlights(String stageId) {
        ArrayList highlights = new ArrayList();
        if (!this.result.isSucessful() && this.result.isDetected()) {
            this.addTokensToList(highlights, new String[]{"$repEffectAbs"});
            this.addTokensToList(highlights, new String[]{"$newRelationStr"});
        }
        this.addTokensToList(highlights, new String[]{"$repEffectAbs2"});
        this.addTokensToList(highlights, new String[]{"$newRelationStr2"});
        return highlights.toArray(new String[0]);
    }

    @Override
    public Color[] getHighlightColors(String stageId) {
        Color colorRepEffect = this.repEffect > 0.0f ? Global.getSettings().getColor("textFriendColor") : Global.getSettings().getColor("textEnemyColor");
        Color colorRepEffect2 = this.repEffect2 > 0.0f ? Global.getSettings().getColor("textFriendColor") : Global.getSettings().getColor("textEnemyColor");
        Color colorNew = this.agentFaction.getRelColor(this.faction.getId());
        Color colorNew2 = Color.WHITE;
        if (this.result.isSucessful()) {
            colorNew2 = this.faction.getRelColor(this.thirdFaction.getId());
            return new Color[]{colorRepEffect2, colorNew2};
        }
        if (this.result.isDetected()) {
            colorNew2 = this.agentFaction.getRelColor(this.thirdFaction.getId());
        }
        return new Color[]{colorRepEffect, colorNew, colorRepEffect2, colorNew2};
    }

    @Override
    public String getCurrentMessageIcon() {
        int significance = 0;
        if (!this.result.isSucessful() || this.result.isDetected()) {
            significance = 1;
        }
        if (this.repResult.isHostile != this.repResult.wasHostile) {
            significance = 2;
        }
        if (this.repResult2 != null && this.repResult2.isHostile != this.repResult2.wasHostile) {
            significance = 2;
        }
        return EVENT_ICONS[significance];
    }
}

