/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.alliances.Alliance;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AllianceChangedEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(AllianceChangedEvent.class);
    public static final MessagePriority MESSAGE_PRIORITY = MessagePriority.ENSURE_DELIVERY;
    protected String faction1Id;
    protected String faction2Id;
    protected String allianceId;
    protected float age = 0.0f;
    protected String stage = "formed";
    protected Map<String, Object> params;
    protected boolean done = false;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
    }

    public String getEventName() {
        String str = "allianceChanged";
        if (this.stage.equals("formed")) {
            str = "allianceFormed";
        } else if (this.stage.equals("dissolved")) {
            str = "allianceDissolved";
        }
        String allianceName = AllianceManager.getAllianceByUUID(this.allianceId).getName();
        return StringHelper.getStringAndSubstituteToken("exerelin_events", str, "$alliance", allianceName);
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.EVENT;
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        this.faction1Id = (String)this.params.get("faction1Id");
        this.faction2Id = (String)this.params.get("faction2Id");
        if (this.params.containsKey("allianceId")) {
            this.allianceId = (String)this.params.get("allianceId");
        }
        this.stage = (String)this.params.get("stage");
    }

    public void startEvent() {
        Global.getSector().reportEventStage((CampaignEventPlugin)this, this.stage, this.eventTarget.getEntity(), MESSAGE_PRIORITY);
    }

    public void reportEvent() {
        Global.getSector().reportEventStage((CampaignEventPlugin)this, this.stage, this.eventTarget.getEntity(), MESSAGE_PRIORITY);
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        FactionAPI faction1 = Global.getSector().getFaction(this.faction1Id);
        FactionAPI faction2 = Global.getSector().getFaction(this.faction2Id);
        Alliance alliance = AllianceManager.getAllianceByUUID(this.allianceId);
        int numMarkets = alliance.getNumAllianceMarkets();
        int marketSizeSum = alliance.getAllianceMarketSizeSum();
        map.put("$alliance", alliance.getName());
        map.put("$numMembers", alliance.getMembersCopy().size() + "");
        map.put("$numMarkets", numMarkets + "");
        map.put("$marketSizeSum", marketSizeSum + "");
        if (faction1 != null) {
            String faction1Str = ExerelinUtilsFaction.getFactionShortName(faction1);
            String theFaction1Str = faction1.getDisplayNameWithArticle();
            map.put("$faction1", faction1Str);
            map.put("$theFaction1", theFaction1Str);
            map.put("$Faction1", Misc.ucFirst((String)faction1Str));
            map.put("$TheFaction1", Misc.ucFirst((String)theFaction1Str));
        }
        if (faction2 != null) {
            String faction2Str = ExerelinUtilsFaction.getFactionShortName(faction2);
            String theFaction2Str = faction2.getDisplayNameWithArticle();
            map.put("$faction2", faction2Str);
            map.put("$theFaction2", theFaction2Str);
            map.put("$Faction2", Misc.ucFirst((String)faction2Str));
            map.put("$TheFaction2", Misc.ucFirst((String)theFaction2Str));
            map.put("$TheFaction2", Misc.ucFirst((String)theFaction2Str));
        }
        return map;
    }

    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList();
        if (!this.stage.equals("formed")) {
            this.addTokensToList(result, new String[]{"$numMembers"});
        }
        this.addTokensToList(result, new String[]{"$numMarkets"});
        this.addTokensToList(result, new String[]{"$marketSizeSum"});
        return result.toArray(new String[0]);
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }
}

