/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.alliances.Alliance;
import exerelin.campaign.alliances.AllianceVoter;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AllianceVoteEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(AllianceVoteEvent.class);
    public static final MessagePriority MESSAGE_PRIORITY = MessagePriority.ENSURE_DELIVERY;
    protected AllianceVoter.VoteResult result;
    protected String allianceId;
    protected String otherParty;
    protected boolean otherPartyIsAlliance = false;
    protected boolean isWar = false;
    protected String stage;
    protected float age = 0.0f;
    protected Map<String, Object> params;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
    }

    public String getEventName() {
        String allianceName = AllianceManager.getAllianceByUUID(this.allianceId).getName();
        return StringHelper.getStringAndSubstituteToken("exerelin_events", "allianceVote", "$alliance", allianceName);
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        this.result = (AllianceVoter.VoteResult)this.params.get("result");
        if (this.params.containsKey("allianceId")) {
            this.allianceId = (String)this.params.get("allianceId");
        }
        this.isWar = (Boolean)this.params.get("isWar");
        this.otherParty = (String)this.params.get("otherParty");
        this.otherPartyIsAlliance = (Boolean)this.params.get("otherPartyIsAlliance");
        this.stage = (this.result.success ? "yes" : "no") + "_" + (this.isWar ? "war" : "peace");
    }

    public void startEvent() {
    }

    public void reportEvent(Map<String, Object> params) {
        this.setParam(params);
        SectorEntityToken location = AllianceManager.getAllianceByUUID(this.allianceId).getRandomAllianceMarketForEvent(true).getPrimaryEntity();
        Global.getSector().reportEventStage((CampaignEventPlugin)this, this.stage, location, MESSAGE_PRIORITY);
    }

    protected String getDefianceString() {
        if (this.result.defied.isEmpty()) {
            return "";
        }
        String stringKey = (this.result.defied.size() > 1 ? "defy" : "defies") + "Decision";
        stringKey = stringKey + (this.isWar ? "War" : "Peace");
        String str = StringHelper.getString("exerelin_alliances", stringKey);
        ArrayList<String> defiers = new ArrayList<String>();
        for (String defier : this.result.defied) {
            defiers.add(ExerelinUtilsFaction.getFactionShortName(defier));
        }
        str = StringHelper.substituteToken(str, "$defying", StringHelper.writeStringCollection(defiers, true, true));
        if (this.otherPartyIsAlliance) {
            String allianceName = AllianceManager.getAllianceByUUID(this.otherParty).getName();
            String theAllianceName = StringHelper.getStringAndSubstituteToken("exerelin_alliances", "theAlliance", "$alliance", allianceName);
            str = StringHelper.substituteToken(str, "$otherParty", allianceName);
            str = StringHelper.substituteToken(str, "$theOtherParty", theAllianceName);
            str = StringHelper.substituteToken(str, "$OtherParty", Misc.ucFirst((String)allianceName));
            str = StringHelper.substituteToken(str, "$TheOtherParty", Misc.ucFirst((String)theAllianceName));
        } else {
            FactionAPI faction = Global.getSector().getFaction(this.otherParty);
            String factionStr = ExerelinUtilsFaction.getFactionShortName(faction);
            String theFactionStr = faction.getDisplayNameWithArticle();
            str = StringHelper.substituteToken(str, "$otherParty", factionStr);
            str = StringHelper.substituteToken(str, "$theOtherParty", theFactionStr);
            str = StringHelper.substituteToken(str, "$OtherParty", Misc.ucFirst((String)factionStr));
            str = StringHelper.substituteToken(str, "$TheOtherParty", Misc.ucFirst((String)theFactionStr));
        }
        return str;
    }

    protected String getVoteCountString(String type, Set<String> votes) {
        if (votes.isEmpty()) {
            return "";
        }
        String str = "\n" + Misc.ucFirst((String)StringHelper.getString(type)) + ": " + votes.size();
        List<String> voters = StringHelper.factionIdListToFactionNameList(new ArrayList<String>(votes), false);
        str = str + " (" + StringHelper.writeStringCollection(voters) + ")";
        return str;
    }

    protected String getVoteBreakdown() {
        String str = this.getVoteCountString("yes", this.result.yesVotes);
        str = str + this.getVoteCountString("no", this.result.noVotes);
        str = str + this.getVoteCountString("abstain", this.result.abstentions);
        return str;
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        Alliance alliance = AllianceManager.getAllianceByUUID(this.allianceId);
        map.put("$alliance", alliance.getName());
        if (this.otherPartyIsAlliance) {
            String allianceName = AllianceManager.getAllianceByUUID(this.otherParty).getName();
            String theAllianceName = StringHelper.getStringAndSubstituteToken("exerelin_alliances", "theAlliance", "$alliance", allianceName);
            map.put("$otherParty", allianceName);
            map.put("$theOtherParty", theAllianceName);
            map.put("$OtherParty", Misc.ucFirst((String)allianceName));
            map.put("$TheOtherParty", Misc.ucFirst((String)theAllianceName));
        } else {
            FactionAPI faction = Global.getSector().getFaction(this.otherParty);
            String factionStr = ExerelinUtilsFaction.getFactionShortName(faction);
            String theFactionStr = faction.getDisplayNameWithArticle();
            map.put("$otherParty", factionStr);
            map.put("$theOtherParty", theFactionStr);
            map.put("$OtherParty", Misc.ucFirst((String)factionStr));
            map.put("$TheOtherParty", Misc.ucFirst((String)theFactionStr));
        }
        if (!this.result.defied.isEmpty()) {
            map.put("$defyText", "\n" + this.getDefianceString());
        } else {
            map.put("$defyText", "");
        }
        map.put("$voteBreakdown", this.getVoteBreakdown());
        return map;
    }

    public String[] getHighlights(String stageId) {
        ArrayList highlights = new ArrayList();
        return highlights.toArray(new String[0]);
    }

    public boolean isDone() {
        return true;
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }
}

