/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.CovertOpsManager;
import exerelin.campaign.ExerelinReputationAdjustmentResult;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CovertOpsEventBase
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(CovertOpsEventBase.class);
    public static final String[] EVENT_ICONS = new String[]{"graphics/exerelin/icons/intel/spy4.png", "graphics/exerelin/icons/intel/spy4_amber.png", "graphics/exerelin/icons/intel/spy4_red.png"};
    protected static final int DAYS_TO_KEEP = 45;
    protected FactionAPI agentFaction = null;
    protected CovertOpsManager.CovertActionResult result = CovertOpsManager.CovertActionResult.SUCCESS;
    protected boolean playerInvolved = false;
    protected float repEffect = 0.0f;
    protected float age = 0.0f;
    protected Map<String, Object> params;
    protected ExerelinReputationAdjustmentResult repResult;
    protected boolean done = false;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.params = new HashMap<String, Object>();
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        this.agentFaction = (FactionAPI)this.params.get("agentFaction");
        if (this.params.containsKey("repEffect")) {
            this.repEffect = ((Float)this.params.get("repEffect")).floatValue();
        }
        this.result = (CovertOpsManager.CovertActionResult)((Object)this.params.get("result"));
        this.playerInvolved = (Boolean)this.params.get("playerInvolved");
        this.repResult = (ExerelinReputationAdjustmentResult)((Object)this.params.get("repResult"));
    }

    public void advance(float amount) {
        if (this.done) {
            return;
        }
        this.age += Global.getSector().getClock().convertToDays(amount);
        if (this.age > 45.0f) {
            this.done = true;
            return;
        }
    }

    public void startEvent() {
        MessagePriority priority = MessagePriority.DELIVER_IMMEDIATELY;
        String reportStage = this.result.name().toLowerCase();
        if (this.playerInvolved) {
            reportStage = reportStage + "_player";
        }
        Global.getSector().reportEventStage((CampaignEventPlugin)this, reportStage, this.market.getPrimaryEntity(), priority);
        log.info((Object)("Covert warfare event: " + reportStage));
    }

    public String getEventName() {
        String name = StringHelper.getString("exerelin_events", "covertOps");
        name = StringHelper.substituteToken(name, "$agentFaction", this.agentFaction.getDisplayName());
        name = StringHelper.substituteToken(name, "$targetFaction", this.faction.getDisplayName());
        return Misc.ucFirst((String)name);
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    protected static String getNewRelationStr(FactionAPI faction1, FactionAPI faction2) {
        RepLevel level = faction1.getRelationshipLevel(faction2.getId());
        int repInt = (int)Math.ceil(faction1.getRelationship(faction2.getId()) * 100.0f);
        String standing = "" + repInt + "/100" + " (" + level.getDisplayName().toLowerCase() + ")";
        return standing;
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        CovertOpsEventBase.addFactionNameTokens((Map)map, (String)"agent", (FactionAPI)this.agentFaction);
        map.put("$repEffectAbs", "" + (int)Math.ceil(Math.abs(this.repEffect * 100.0f)));
        map.put("$newRelationStr", CovertOpsEventBase.getNewRelationStr(this.agentFaction, this.faction));
        return map;
    }

    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList();
        this.addTokensToList(result, new String[]{"$repEffectAbs"});
        this.addTokensToList(result, new String[]{"$newRelationStr"});
        return result.toArray(new String[0]);
    }

    public Color[] getHighlightColors(String stageId) {
        Color colorRepEffect = this.repEffect > 0.0f ? Global.getSettings().getColor("textFriendColor") : Global.getSettings().getColor("textEnemyColor");
        Color colorNew = this.agentFaction.getRelColor(this.faction.getId());
        return new Color[]{colorRepEffect, colorNew};
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }

    public String getCurrentMessageIcon() {
        int significance = 0;
        if (!this.result.isSucessful() || this.result.isDetected()) {
            significance = 1;
        }
        if (this.repResult.wasHostile && !this.repResult.isHostile) {
            significance = 1;
        }
        if (this.repResult.isHostile && !this.repResult.wasHostile) {
            significance = 2;
        }
        return EVENT_ICONS[significance];
    }
}

