/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.ExerelinReputationAdjustmentResult;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DiplomacyEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(DiplomacyEvent.class);
    protected static final int DAYS_TO_KEEP = 30;
    protected FactionAPI otherFaction;
    protected DiplomacyManager.DiplomacyEventDef event;
    protected String eventStage;
    protected ExerelinReputationAdjustmentResult result;
    protected float delta;
    protected float age = 0.0f;
    protected Map<String, Object> params;
    protected boolean done = false;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.params = new HashMap<String, Object>();
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        this.otherFaction = (FactionAPI)this.params.get("otherFaction");
        this.delta = ((Float)this.params.get("delta")).floatValue();
        this.eventStage = (String)this.params.get("eventStage");
        this.result = (ExerelinReputationAdjustmentResult)((Object)this.params.get("result"));
    }

    public void advance(float amount) {
        if (this.done) {
            return;
        }
        this.age += Global.getSector().getClock().convertToDays(amount);
        if (this.age > 30.0f) {
            this.done = true;
            return;
        }
    }

    public void startEvent() {
        MessagePriority priority = MessagePriority.DELIVER_IMMEDIATELY;
        Global.getSector().reportEventStage((CampaignEventPlugin)this, this.eventStage, this.market.getPrimaryEntity(), priority);
        log.info((Object)("Diplomacy event: " + this.eventStage));
    }

    public String getEventName() {
        String name = StringHelper.getString("exerelin_events", "diplomacy");
        name = StringHelper.substituteToken(name, "$faction", this.faction.getDisplayName());
        name = StringHelper.substituteToken(name, "$otherFaction", this.otherFaction.getDisplayName());
        return Misc.ucFirst((String)name);
    }

    public String getCurrentMessageIcon() {
        if (this.result.isHostile && !this.result.wasHostile) {
            return "graphics/exerelin/icons/intel/war.png";
        }
        if (!this.result.isHostile && this.result.wasHostile) {
            return "graphics/exerelin/icons/intel/peace.png";
        }
        return null;
    }

    public String getEventIcon() {
        if (this.result.isHostile && !this.result.wasHostile) {
            return "graphics/exerelin/icons/intel/war.png";
        }
        if (!this.result.isHostile && this.result.wasHostile) {
            return "graphics/exerelin/icons/intel/peace.png";
        }
        return null;
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        if (this.result.isHostile != this.result.wasHostile) {
            return CampaignEventPlugin.CampaignEventCategory.EVENT;
        }
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    protected String getNewRelationStr(float delta) {
        RepLevel level = this.faction.getRelationshipLevel(this.otherFaction.getId());
        int repInt = (int)Math.ceil((this.faction.getRelationship(this.otherFaction.getId()) + delta) * 100.0f);
        String standing = "" + repInt + "/100" + " (" + level.getDisplayName().toLowerCase() + ")";
        return standing;
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        DiplomacyEvent.addFactionNameTokens((Map)map, (String)"other", (FactionAPI)this.otherFaction);
        map.put("$deltaAbs", "" + (int)Math.ceil(Math.abs(this.delta * 100.0f)));
        map.put("$newRelationStr", this.getNewRelationStr(0.0f));
        return map;
    }

    public String[] getHighlights(String stageId) {
        ArrayList highlights = new ArrayList();
        this.addTokensToList(highlights, new String[]{"$deltaAbs"});
        this.addTokensToList(highlights, new String[]{"$newRelationStr"});
        return highlights.toArray(new String[0]);
    }

    public Color[] getHighlightColors(String stageId) {
        Color colorDelta = this.delta > 0.0f ? Global.getSettings().getColor("textFriendColor") : Global.getSettings().getColor("textEnemyColor");
        Color colorNew = this.faction.getRelColor(this.otherFaction.getId());
        return new Color[]{colorDelta, colorNew};
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }
}

