/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.impl.campaign.events.nearby.NearbyEventsEvent;
import com.fs.starfarer.api.util.FleetLog;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.utilities.ExerelinUtilsFaction;

public class ExerelinNearbyEventsEvent
extends NearbyEventsEvent {
    protected void maybeSpawnDistressCall() {
        StarSystemAPI system2;
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (!playerFleet.isInHyperspace()) {
            return;
        }
        WeightedRandomPicker systems = new WeightedRandomPicker();
        block0: for (StarSystemAPI system2 : Misc.getNearbyStarSystems((SectorEntityToken)playerFleet, (float)Global.getSettings().getFloat("distressCallEventRangeLY"))) {
            float sincePlayerVisit;
            if (this.skipForDistressCalls.contains((Object)system2.getId()) || system2.hasPulsar() || (sincePlayerVisit = system2.getDaysSinceLastPlayerVisit()) < 90.0f) continue;
            boolean validTheme = false;
            for (String tag : system2.getTags()) {
                if (!distressCallAllowedThemes.contains(tag)) continue;
                validTheme = true;
                break;
            }
            if (!validTheme) continue;
            for (CampaignFleetAPI fleet : system2.getFleets()) {
                if (fleet.getFaction().isHostileTo("independent")) continue;
                continue block0;
            }
            this.skipForDistressCalls.add((Object)system2.getId(), 30.0f);
            systems.add((Object)system2);
        }
        float p = (float)systems.getItems().size() * 0.2f;
        if (p > 0.6f) {
            p = 0.6f;
        }
        if ((float)Math.random() >= p && !TEST_MODE) {
            return;
        }
        system2 = (StarSystemAPI)systems.pick();
        if (system2 == null) {
            return;
        }
        this.skipForDistressCalls.set((Object)system2.getId(), 90.0f);
        WeightedRandomPicker picker = new WeightedRandomPicker();
        picker.add((Object)NearbyEventsEvent.DistressEventType.NORMAL, 10.0f);
        if (ExerelinUtilsFaction.hasAnyMarkets("pirates")) {
            picker.add((Object)NearbyEventsEvent.DistressEventType.PIRATE_AMBUSH, 10.0f);
            picker.add((Object)NearbyEventsEvent.DistressEventType.PIRATE_AMBUSH_TRAP, 10.0f);
        }
        picker.add((Object)NearbyEventsEvent.DistressEventType.DERELICT_SHIP, 10.0f);
        NearbyEventsEvent.DistressEventType type = (NearbyEventsEvent.DistressEventType)picker.pick();
        if (type == NearbyEventsEvent.DistressEventType.NORMAL || TEST_MODE) {
            this.generateDistressCallNormal(system2);
        } else if (type == NearbyEventsEvent.DistressEventType.PIRATE_AMBUSH) {
            this.generateDistressCallAmbush(system2);
        } else if (type == NearbyEventsEvent.DistressEventType.PIRATE_AMBUSH_TRAP) {
            this.generateDistressCallAmbushTrap(system2);
        } else if (type == NearbyEventsEvent.DistressEventType.DERELICT_SHIP) {
            this.generateDistressDerelictShip(system2);
        }
        CommMessageAPI message = FleetLog.beginEntry((String)"\u6c42\u6551\u547c\u53f7", (SectorEntityToken)system2.getCenter());
        message.setSmallIcon(Global.getSettings().getSpriteName("intel_categories", "events"));
        message.getSection1().addPara("\u4f60\u4ece\u9644\u8fd1\u661f\u7cfb\u6536\u5230\u4e86\u6c42\u6551\u547c\u53f7 " + system2.getNameWithLowercaseType());
        message.getSection1().addPara("\u6ca1\u6709\u5176\u4ed6\u4fe1\u606f, \u4f46\u8fd9\u5e76\u4e0d\u5947\u602a - \u4e00\u652f\u5e38\u89c4\u7684\u8230\u961f \u4e0d\u4f1a\u643a\u5e26\u80fd\u5c06\u5b8c\u6574\u7684\u6570\u636e\u6d41, \u5e7f\u64ad\u5230\u8d85\u7a7a\u95f4\u7684\u8bbe\u5907.");
        FleetLog.addToLog((CommMessageAPI)message, null);
    }
}

