/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.world.exigency.Tasserus;
import exerelin.campaign.SectorManager;
import exerelin.campaign.fleets.InvasionFleetManager;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinUtilsFleet;
import exerelin.utilities.StringHelper;
import org.apache.log4j.Logger;

public class ExigencyRespawnFleetEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(ExigencyRespawnFleetEvent.class);
    protected MarketAPI fakeMarket;
    protected IntervalUtil interval;

    protected void giveInitialAssignment(InvasionFleetManager.InvasionFleetData data) {
        float daysToOrbit = ExerelinUtilsFleet.getDaysToOrbit(data.fleet) * 0.25f;
        if (daysToOrbit < 0.2f) {
            daysToOrbit = 0.2f;
        }
        data.fleet.getAI().addAssignment(FleetAssignment.ORBIT_PASSIVE, data.source, daysToOrbit, StringHelper.getFleetAssignmentString("preparingFor", data.source.getName(), "missionInvasion"), null);
    }

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.interval = new IntervalUtil(ExerelinConfig.factionRespawnInterval * 1.6f, ExerelinConfig.factionRespawnInterval * 2.4f);
        this.fakeMarket = Global.getFactory().createMarket("tasserus_fake_market", "Tasserus", 6);
        this.fakeMarket.setFactionId("exigency");
        this.fakeMarket.setPrimaryEntity(Global.getSector().getEntityById("exigency_anomaly"));
    }

    public void advance(float amount) {
        if (SectorManager.isFactionAlive("exigency")) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.interval.advance(days);
        if (this.interval.intervalElapsed()) {
            InvasionFleetManager.InvasionFleetData fleetData = SectorManager.spawnRespawnFleet(this.fakeMarket.getFaction(), this.fakeMarket, true);
            if (fleetData == null) {
                return;
            }
            Tasserus.getAnomalyPlugin().createBigPulse(Math.min(1.0f, (float)fleetData.fleet.getFleetSizeCount() / 10.0f), false);
            this.giveInitialAssignment(fleetData);
            this.interval.setInterval(ExerelinConfig.factionRespawnInterval * 1.6f, ExerelinConfig.factionRespawnInterval * 2.4f);
        }
    }

    public String getEventName() {
        return StringHelper.getString("exerelin_events", "exigencyRespawn");
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    public String getCurrentImage() {
        FactionAPI faction = Global.getSector().getFaction("exigency");
        if (faction != null) {
            return faction.getLogo();
        }
        return null;
    }

    public boolean isDone() {
        return false;
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }
}

