/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import java.util.Map;
import org.apache.log4j.Logger;

public class FactionChangedEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(FactionChangedEvent.class);
    private FactionAPI oldFaction;
    private FactionAPI newFaction;
    private Map<String, Object> params;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
    }

    public String getEventName() {
        return StringHelper.getString("exerelin_events", "factionChanged");
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.EVENT;
    }

    public void reportEvent(FactionAPI oldFaction, FactionAPI newFaction, String stage, SectorEntityToken entity) {
        this.oldFaction = oldFaction;
        this.newFaction = newFaction;
        Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, entity, MessagePriority.DELIVER_IMMEDIATELY);
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        String oldFactionStr = ExerelinUtilsFaction.getFactionShortName(this.oldFaction);
        String theOldFactionStr = this.oldFaction.getDisplayNameWithArticle();
        String newFactionStr = ExerelinUtilsFaction.getFactionShortName(this.newFaction);
        String theNewFactionStr = this.newFaction.getDisplayNameWithArticle();
        String sender = this.newFaction.getId().equals("player_npc") ? ExerelinUtilsFaction.getFactionShortName(this.oldFaction) : ExerelinUtilsFaction.getFactionShortName(this.newFaction);
        map.put("$sender", sender);
        map.put("$oldFaction", oldFactionStr);
        map.put("$theOldFaction", theOldFactionStr);
        map.put("$OldFaction", Misc.ucFirst((String)oldFactionStr));
        map.put("$TheOldFaction", Misc.ucFirst((String)theOldFactionStr));
        map.put("$newFaction", newFactionStr);
        map.put("$theNewFaction", theNewFactionStr);
        map.put("$NewFaction", Misc.ucFirst((String)newFactionStr));
        map.put("$TheNewFaction", Misc.ucFirst((String)theNewFactionStr));
        return map;
    }

    public boolean isDone() {
        return false;
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }
}

