/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FactionEliminatedEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(FactionEliminatedEvent.class);
    protected static final int DAYS_TO_KEEP = 90;
    protected FactionAPI defeatedFaction;
    protected FactionAPI victorFaction;
    protected boolean playerDefeated = false;
    protected boolean playerVictory = false;
    protected float age;
    protected Map<String, Object> params;
    public boolean done;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.params = new HashMap<String, Object>();
        this.done = false;
        this.age = 0.0f;
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        this.defeatedFaction = (FactionAPI)this.params.get("defeatedFaction");
        this.victorFaction = (FactionAPI)this.params.get("victorFaction");
        this.playerDefeated = (Boolean)this.params.get("playerDefeated");
    }

    public void advance(float amount) {
        if (this.done) {
            return;
        }
        this.age += Global.getSector().getClock().convertToDays(amount);
        if (this.age > 90.0f) {
            this.done = true;
            return;
        }
    }

    public void startEvent() {
        MessagePriority priority = MessagePriority.ENSURE_DELIVERY;
        String stage = "normal";
        if (this.playerDefeated) {
            stage = "player_defeat";
        } else if (this.playerVictory) {
            stage = "player_victory";
        }
        Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, this.market.getPrimaryEntity(), priority);
    }

    public String getEventName() {
        return Misc.ucFirst((String)StringHelper.getStringAndSubstituteToken("exerelin_events", "factionEliminated", "$faction", this.defeatedFaction.getDisplayName()));
    }

    public String getCurrentImage() {
        return this.defeatedFaction.getLogo();
    }

    public String getCurrentMessageIcon() {
        return this.defeatedFaction.getCrest();
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.EVENT;
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        String defeated = ExerelinUtilsFaction.getFactionShortName(this.defeatedFaction);
        String theDefeated = this.defeatedFaction.getDisplayNameWithArticle();
        String victor = this.victorFaction.getDisplayName();
        String theVictor = this.victorFaction.getDisplayNameWithArticle();
        map.put("$defeatedIsOrAre", this.defeatedFaction.getDisplayNameIsOrAre());
        map.put("$defeatedFaction", defeated);
        map.put("$theDefeatedFaction", theDefeated);
        map.put("$DefeatedFaction", Misc.ucFirst((String)defeated));
        map.put("$TheDefeatedFaction", Misc.ucFirst((String)theDefeated));
        map.put("$victorFaction", victor);
        map.put("$theVictorFaction", theVictor);
        map.put("$VictorFaction", Misc.ucFirst((String)victor));
        map.put("$TheVictorFaction", Misc.ucFirst((String)theVictor));
        return map;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }
}

