/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.EngagementResultForFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FactionInsuranceEvent
extends BaseEventPlugin {
    public static final float HARD_MODE_MULT = 0.5f;
    public static final boolean COMPENSATE_DMODS = false;
    public static final float DMOD_BASE_COST = Global.getSettings().getFloat("baseRestoreCostMult");
    public static final float DMOD_COST_PER_MOD = Global.getSettings().getFloat("baseRestoreCostMultPerDMod");
    public static final float LIFE_INSURANCE_PER_LEVEL = 2000.0f;
    public static final float BASE_HULL_VALUE_MULT_FOR_DMODS = 0.4f;
    public static Logger log = Global.getLogger(FactionInsuranceEvent.class);
    protected float paidAmount = 0.0f;
    protected Map<FleetMemberAPI, Float[]> disabledOrDestroyedMembers = new HashMap<FleetMemberAPI, Float[]>();
    protected List<OfficerDataAPI> deadOfficers = new ArrayList<OfficerDataAPI>();

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
    }

    public void reportPlayerEngagement(EngagementResultAPI result) {
        EngagementResultForFleetAPI er = result.didPlayerWin() ? result.getWinnerResult() : result.getLoserResult();
        ArrayList disabledOrDestroyed = new ArrayList();
        disabledOrDestroyed.addAll(er.getDisabled());
        disabledOrDestroyed.addAll(er.getDestroyed());
        for (FleetMemberAPI member : disabledOrDestroyed) {
            if (this.disabledOrDestroyedMembers.containsKey(member) || member.isAlly() || member.isFighterWing()) continue;
            this.disabledOrDestroyedMembers.put(member, new Float[]{Float.valueOf(member.getBaseBuyValue()), Float.valueOf(this.countDMods(member))});
        }
    }

    public void reportBattleFinished(CampaignFleetAPI winner, BattleAPI battle) {
        MarketAPI closestMarket;
        if (!battle.isPlayerInvolved()) {
            return;
        }
        if (Global.getSector().getMemoryWithoutUpdate().contains("$tutStage")) {
            return;
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        float value = 0.0f;
        String stage = "report";
        String alignedFactionId = PlayerFactionStore.getPlayerFactionId();
        if (!ExerelinUtilsFaction.isExiInCorvus(alignedFactionId) && !SectorManager.isFactionAlive(alignedFactionId)) {
            return;
        }
        FactionAPI alignedFaction = Global.getSector().getFaction(alignedFactionId);
        List fleetCurrent = fleet.getFleetData().getMembersListCopy();
        for (FleetMemberAPI member : fleet.getFleetData().getSnapshot()) {
            if (!fleetCurrent.contains(member)) {
                float amount = member.getBaseBuyValue();
                if (this.disabledOrDestroyedMembers.containsKey(member)) {
                    Float[] entry = this.disabledOrDestroyedMembers.get(member);
                    amount = entry[0].floatValue();
                }
                log.info((Object)("Insuring lost ship " + member.getShipName() + " for " + amount));
                value += amount;
                continue;
            }
            if (!this.disabledOrDestroyedMembers.containsKey(member)) continue;
            Float[] entry = this.disabledOrDestroyedMembers.get(member);
            float prevValue = entry[0].floatValue();
            int dmodsOld = (int)entry[1].floatValue();
            int dmods = this.countDMods(member);
            float dmodCompensation = 0.0f;
            if (dmods > dmodsOld) {
                // empty if block
            }
            float amount = prevValue - member.getBaseBuyValue() + dmodCompensation;
            log.info((Object)("Insuring recovered ship " + member.getShipName() + " for " + amount));
            log.info((Object)("Compensation for D-mods: " + dmodCompensation));
            value += amount;
        }
        for (OfficerDataAPI deadOfficer : this.deadOfficers) {
            float amount = (float)deadOfficer.getPerson().getStats().getLevel() * 2000.0f;
            log.info((Object)("Insuring dead officer " + deadOfficer.getPerson().getName().getFullName() + " for " + amount));
            value += amount;
        }
        this.disabledOrDestroyedMembers.clear();
        this.deadOfficers.clear();
        if (value <= 0.0f) {
            return;
        }
        if (alignedFaction.isAtBest("player", RepLevel.SUSPICIOUS)) {
            this.paidAmount = 0.0f;
            stage = "report_unpaid";
        } else {
            this.paidAmount = value * ExerelinConfig.playerInsuranceMult;
        }
        if (SectorManager.getHardMode()) {
            this.paidAmount *= 0.5f;
        }
        if ((closestMarket = ExerelinUtils.getClosestMarket(alignedFactionId)) != null) {
            Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, closestMarket.getPrimaryEntity(), MessagePriority.ENSURE_DELIVERY, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

                public void beforeDelivery(CommMessageAPI message) {
                    Global.getSector().getPlayerFleet().getCargo().getCredits().add(FactionInsuranceEvent.this.paidAmount);
                }
            });
        }
    }

    public String getEventName() {
        return StringHelper.getString("exerelin_events", "insurance");
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        FactionAPI faction = Global.getSector().getFaction(PlayerFactionStore.getPlayerFactionId());
        String factionName = ExerelinUtilsFaction.getFactionShortName(faction);
        String theFactionName = faction.getDisplayNameLongWithArticle();
        map.put("$sender", factionName);
        map.put("$employer", factionName);
        map.put("$Employer", Misc.ucFirst((String)factionName));
        map.put("$theEmployer", theFactionName);
        map.put("$TheEmployer", Misc.ucFirst((String)theFactionName));
        map.put("$paid", Misc.getWithDGS((float)((int)this.paidAmount)) + "\u00a2");
        return map;
    }

    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList();
        this.addTokensToList(result, new String[]{"$paid"});
        return result.toArray(new String[0]);
    }

    public String getCurrentImage() {
        FactionAPI myFaction = Global.getSector().getFaction(PlayerFactionStore.getPlayerFactionId());
        return myFaction.getLogo();
    }

    public boolean isDone() {
        return false;
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }

    protected int countDMods(FleetMemberAPI member) {
        Set permamods = member.getVariant().getPermaMods();
        int dmods = 0;
        for (String mod : permamods) {
            HullModSpecAPI modspec = Global.getSettings().getHullModSpec(mod);
            if (!modspec.hasTag("dmod")) continue;
            ++dmods;
        }
        return dmods;
    }

    public void addDeadOfficers(List<OfficerDataAPI> officers) {
        this.deadOfficers.addAll(officers);
    }
}

