/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.SectorManager;
import exerelin.utilities.StringHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FactionRespawnedEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(FactionRespawnedEvent.class);
    private static final int DAYS_TO_KEEP = 90;
    float age;
    boolean existedBefore;
    private Map<String, Object> params;
    public boolean done;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.params = new HashMap<String, Object>();
        this.done = false;
        this.age = 0.0f;
        this.existedBefore = false;
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        this.existedBefore = (Boolean)this.params.get("existedBefore");
    }

    public void advance(float amount) {
        if (this.done) {
            return;
        }
        this.age += Global.getSector().getClock().convertToDays(amount);
        if (this.age > 90.0f) {
            this.done = true;
            return;
        }
    }

    public void startEvent() {
        MessagePriority priority = MessagePriority.SECTOR;
        String stage = "new";
        if (this.existedBefore) {
            stage = "respawned";
        }
        Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, this.market.getPrimaryEntity(), priority);
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        map.put("$clusterName", SectorManager.getFirstStarName());
        return map;
    }

    public String getEventName() {
        return StringHelper.getStringAndSubstituteToken("exerelin_events", "factionRespawned", "$faction", Misc.ucFirst((String)this.faction.getDisplayName()));
    }

    public String getCurrentImage() {
        return this.faction.getLogo();
    }

    public String getCurrentMessageIcon() {
        return this.faction.getCrest();
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.EVENT;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }
}

