/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class FactionSalaryEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(FactionSalaryEvent.class);
    protected static float HARD_MODE_MULT = 0.5f;
    private int month;
    private float paidAmount = 0.0f;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        Global.getSector().getPersistentData().put("salariesClock", Global.getSector().getClock().createClock(Global.getSector().getClock().getTimestamp()));
        this.month = Global.getSector().getClock().getMonth();
    }

    public void advance(float amount) {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (playerFleet == null) {
            return;
        }
        CampaignClockAPI clock = Global.getSector().getClock();
        if (clock.getDay() == 1 && clock.getMonth() != this.month) {
            this.month = Global.getSector().getClock().getMonth();
            int level = Global.getSector().getPlayerPerson().getStats().getLevel();
            String stage = "report";
            this.paidAmount = ExerelinConfig.playerBaseSalary + ExerelinConfig.playerSalaryIncrementPerLevel * (float)(level - 1);
            if (this.paidAmount == 0.0f) {
                return;
            }
            String alignedFactionId = PlayerFactionStore.getPlayerFactionId();
            if (!ExerelinUtilsFaction.isExiInCorvus(alignedFactionId) && !SectorManager.isFactionAlive(alignedFactionId)) {
                return;
            }
            FactionAPI alignedFaction = Global.getSector().getFaction(alignedFactionId);
            RepLevel relation = alignedFaction.getRelationshipLevel("player");
            if (alignedFaction.isAtBest("player", RepLevel.SUSPICIOUS)) {
                this.paidAmount = 0.0f;
                stage = "report_unpaid";
            } else if (relation == RepLevel.NEUTRAL) {
                this.paidAmount *= 0.25f;
            } else if (relation == RepLevel.FAVORABLE) {
                this.paidAmount *= 0.5f;
            } else if (relation == RepLevel.WELCOMING) {
                this.paidAmount *= 0.75f;
            }
            if (SectorManager.getHardMode()) {
                this.paidAmount *= HARD_MODE_MULT;
            }
            playerFleet.getCargo().getCredits().add(this.paidAmount);
            Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, (SectorEntityToken)playerFleet, MessagePriority.DELIVER_IMMEDIATELY);
            Global.getSector().getPersistentData().put("salariesClock", Global.getSector().getClock().createClock(Global.getSector().getClock().getTimestamp()));
        }
    }

    public String getEventName() {
        return StringHelper.getString("exerelin_events", "factionSalary");
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        CampaignClockAPI previous = (CampaignClockAPI)Global.getSector().getPersistentData().get("salariesClock");
        if (previous != null) {
            map.put("$date", previous.getMonthString() + ", c." + previous.getCycle());
        }
        FactionAPI faction = Global.getSector().getFaction(PlayerFactionStore.getPlayerFactionId());
        String factionName = ExerelinUtilsFaction.getFactionShortName(faction);
        String theFactionName = faction.getDisplayNameLongWithArticle();
        map.put("$sender", factionName);
        map.put("$employer", factionName);
        map.put("$Employer", Misc.ucFirst((String)factionName));
        map.put("$theEmployer", theFactionName);
        map.put("$TheEmployer", Misc.ucFirst((String)theFactionName));
        map.put("$paid", Misc.getWithDGS((float)((int)this.paidAmount)) + "\u00a2");
        return map;
    }

    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList();
        this.addTokensToList(result, new String[]{"$paid"});
        return result.toArray(new String[0]);
    }

    public String getCurrentImage() {
        FactionAPI myFaction = Global.getSector().getFaction(PlayerFactionStore.getPlayerFactionId());
        return myFaction.getLogo();
    }

    public boolean isDone() {
        return false;
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }
}

