/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.PlayerFactionStore;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InvasionFleetEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(InvasionFleetEvent.class);
    protected Map<String, Object> params;
    protected MarketAPI target;
    protected int dp;
    public boolean done;
    protected float age;
    protected FactionAPI factionPermanent;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.params = new HashMap<String, Object>();
        this.done = false;
        this.target = null;
        this.dp = 0;
        this.age = 0.0f;
        this.factionPermanent = eventTarget.getFaction();
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        this.target = (MarketAPI)this.params.get("target");
        this.dp = (int)((Float)this.params.get("dp")).floatValue();
    }

    public void startEvent() {
    }

    public void reportStart() {
        MessagePriority priority = MessagePriority.SECTOR;
        String stage = "start";
        if (this.faction.getId().equals(PlayerFactionStore.getPlayerFactionId())) {
            stage = "start_player";
        }
        Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, this.market.getPrimaryEntity(), priority);
    }

    public void endEvent(FleetReturnReason reason, SectorEntityToken reportSource) {
        if (this.done) {
            return;
        }
        this.done = true;
        String stage = reason.toString().toLowerCase();
        if (this.faction.getId().equals(PlayerFactionStore.getPlayerFactionId()) || this.faction.getId().equals("player_npc")) {
            stage = stage + "_player";
        }
        log.info((Object)("Ending invasion event: " + stage));
        Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, reportSource, MessagePriority.SECTOR);
    }

    public void advance(float amount) {
    }

    public String getEventName() {
        return StringHelper.getStringAndSubstituteToken("exerelin_events", "invasionFleet", "$faction", Misc.ucFirst((String)this.faction.getDisplayName()));
    }

    public String getCurrentImage() {
        return this.faction.getLogo();
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        InvasionFleetEvent.addFactionNameTokens((Map)map, (String)"", (FactionAPI)this.factionPermanent);
        InvasionFleetEvent.addFactionNameTokens((Map)map, (String)"the", (FactionAPI)this.factionPermanent);
        FactionAPI targetFaction = this.target.getFaction();
        LocationAPI loc = this.target.getContainingLocation();
        String locName = loc.getName();
        if (loc instanceof StarSystemAPI) {
            locName = " " + ((StarSystemAPI)loc).getName();
        }
        int dpEstimate = Math.round((float)this.dp / 10.0f) * 10;
        String targetFactionStr = ExerelinUtilsFaction.getFactionShortName(targetFaction);
        String theTargetFactionStr = targetFaction.getDisplayNameWithArticle();
        map.put("$sender", ExerelinUtilsFaction.getFactionShortName(this.faction));
        map.put("$target", this.target.getName());
        map.put("$targetLocation", locName);
        map.put("$targetFaction", targetFactionStr);
        map.put("$TargetFaction", Misc.ucFirst((String)targetFactionStr));
        map.put("$theTargetFaction", theTargetFactionStr);
        map.put("$TheTargetFaction", Misc.ucFirst((String)theTargetFactionStr));
        map.put("$dp", "" + dpEstimate);
        return map;
    }

    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList();
        this.addTokensToList(result, new String[]{"$dp"});
        return result.toArray(new String[0]);
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }

    public static enum FleetReturnReason {
        MISSION_COMPLETE,
        ALREADY_CAPTURED,
        NO_LONGER_HOSTILE,
        MARINE_LOSSES,
        SHIP_LOSSES,
        OTHER;

    }
}

