/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MarketCapturedEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(MarketCapturedEvent.class);
    protected static final int DAYS_TO_KEEP = 60;
    protected FactionAPI newOwner;
    protected FactionAPI oldOwner;
    protected List<String> factionsToNotify;
    protected float repChangeStrength;
    protected boolean playerInvolved;
    protected Map<String, Object> params;
    protected boolean done;
    protected float age;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.params = new HashMap<String, Object>();
        this.done = false;
        this.age = 0.0f;
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        this.newOwner = (FactionAPI)this.params.get("newOwner");
        this.oldOwner = (FactionAPI)this.params.get("oldOwner");
        this.repChangeStrength = ((Float)this.params.get("repChangeStrength")).floatValue();
        this.playerInvolved = (Boolean)this.params.get("playerInvolved");
        this.factionsToNotify = (List)this.params.get("factionsToNotify");
    }

    public void advance(float amount) {
        if (this.done) {
            return;
        }
        if (this.newOwner == this.oldOwner) {
            this.done = true;
            return;
        }
        this.age += Global.getSector().getClock().convertToDays(amount);
        if (this.age > 60.0f) {
            this.done = true;
            return;
        }
    }

    public void startEvent() {
        String stage = "report";
        MessagePriority priority = MessagePriority.ENSURE_DELIVERY;
        if (this.playerInvolved) {
            stage = "report_player";
        }
        Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, this.market.getPrimaryEntity(), priority, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

            public void beforeDelivery(CommMessageAPI message) {
                if (MarketCapturedEvent.this.playerInvolved) {
                    for (String factionId : MarketCapturedEvent.this.factionsToNotify) {
                        Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.COMBAT_WITH_ENEMY, (Object)Float.valueOf(MarketCapturedEvent.this.repChangeStrength)), factionId);
                    }
                }
            }
        });
    }

    public String getEventName() {
        String name = StringHelper.getString("exerelin_events", "marketCaptured");
        name = StringHelper.substituteToken(name, "$market", this.market.getName());
        name = StringHelper.substituteToken(name, "$faction", this.faction.getDisplayName());
        return name;
    }

    public String getCurrentImage() {
        return this.newOwner.getLogo();
    }

    public String getCurrentMessageIcon() {
        return this.newOwner.getCrest();
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.EVENT;
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        String newOwnerStr = this.newOwner.getDisplayName();
        String oldOwnerStr = this.oldOwner.getDisplayName();
        String theNewOwnerStr = this.newOwner.getDisplayNameWithArticle();
        String theOldOwnerStr = this.oldOwner.getDisplayNameWithArticle();
        map.put("$newOwner", newOwnerStr);
        map.put("$oldOwner", oldOwnerStr);
        map.put("$NewOwner", Misc.ucFirst((String)newOwnerStr));
        map.put("$OldOwner", Misc.ucFirst((String)oldOwnerStr));
        map.put("$theNewOwner", theNewOwnerStr);
        map.put("$theOldOwner", theOldOwnerStr);
        map.put("$TheNewOwner", Misc.ucFirst((String)theNewOwnerStr));
        map.put("$TheOldOwner", Misc.ucFirst((String)theOldOwnerStr));
        map.put("$oldOwnerMarketsNum", "" + ExerelinUtilsFaction.getFactionMarkets(this.oldOwner.getId()).size());
        map.put("$newOwnerMarketsNum", "" + ExerelinUtilsFaction.getFactionMarkets(this.newOwner.getId()).size());
        return map;
    }

    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList();
        this.addTokensToList(result, new String[]{"$newOwnerMarketsNum"});
        this.addTokensToList(result, new String[]{"$oldOwnerMarketsNum"});
        return result.toArray(new String[0]);
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }
}

