/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.campaign.events.InvasionFleetEvent;
import exerelin.campaign.fleets.InvasionFleetManager;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinUtilsMarket;
import exerelin.utilities.StringHelper;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

public class RevengeanceManagerEvent
extends BaseEventPlugin {
    public static final float POINTS_TO_SPAWN = 100.0f;
    public static Logger log = Global.getLogger(RevengeanceManagerEvent.class);
    private boolean ended = false;
    private final IntervalUtil interval = new IntervalUtil(1.0f, 1.0f);
    float points = 0.0f;

    public void addPoints(float addedPoints) {
        boolean success;
        if (!RevengeanceManagerEvent.isRevengeanceEnabled()) {
            return;
        }
        if (!SectorManager.getHardMode()) {
            addedPoints *= 0.5f;
        }
        this.points += addedPoints;
        String debugStr = "Adding revengeance points: " + addedPoints;
        log.info((Object)debugStr);
        if (this.points >= 100.0f && (success = this.generateRevengeanceFleet())) {
            this.points -= 100.0f;
        }
    }

    public String getCurrentImage() {
        return this.faction.getLogo();
    }

    public String getCurrentMessageIcon() {
        return this.faction.getCrest();
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.EVENT;
    }

    public String getEventIcon() {
        return this.faction.getCrest();
    }

    public String getEventName() {
        return StringHelper.getString("exerelin_fleets", "revengeanceFleetEvent");
    }

    public void init(String eventType, CampaignEventTarget eventTarget) {
        super.init(eventType, eventTarget, false);
    }

    public boolean isDone() {
        return this.ended;
    }

    public void endEvent() {
        this.ended = true;
    }

    public void reportBattle(CampaignFleetAPI winner, BattleAPI battle) {
        if (!battle.isPlayerInvolved()) {
            return;
        }
        List killedFleets = battle.getNonPlayerSide();
        float involvedFraction = battle.getPlayerInvolvementFraction();
        float recentFpKilled = 0.0f;
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        List<String> enemies = DiplomacyManager.getFactionsAtWarWithFaction(playerAlignedFactionId, ExerelinConfig.allowPirateInvasions, true, false);
        for (CampaignFleetAPI killedFleet : killedFleets) {
            String factionId = killedFleet.getFaction().getId();
            if (!enemies.contains(factionId)) continue;
            List killCurrent = killedFleet.getFleetData().getMembersListCopy();
            for (FleetMemberAPI member : killedFleet.getFleetData().getSnapshot()) {
                if (killCurrent.contains(member)) continue;
                recentFpKilled += (float)member.getFleetPointCost();
            }
        }
        float points = (recentFpKilled *= involvedFraction) * ExerelinConfig.revengePointsPerEnemyFP;
        this.addPoints(points);
    }

    public static boolean isRevengeanceEnabled() {
        int requiredSetting = 2;
        if (SectorManager.getHardMode()) {
            requiredSetting = 1;
        }
        log.info((Object)("Required revengeance setting: " + requiredSetting));
        return requiredSetting <= ExerelinConfig.enableRevengeFleets;
    }

    protected boolean generateRevengeanceFleet() {
        InvasionFleetEvent event;
        SectorAPI sector = Global.getSector();
        List markets = sector.getEconomy().getMarketsCopy();
        WeightedRandomPicker attackerPicker = new WeightedRandomPicker();
        WeightedRandomPicker sourcePicker = new WeightedRandomPicker();
        WeightedRandomPicker targetPicker = new WeightedRandomPicker();
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        List<String> enemies = DiplomacyManager.getFactionsAtWarWithFaction(playerAlignedFactionId, ExerelinConfig.allowPirateInvasions, true, false);
        if (enemies.isEmpty()) {
            return false;
        }
        for (String enemyId : enemies) {
            if (enemyId.equals("templars") && enemies.size() > 1) continue;
            attackerPicker.add((Object)enemyId);
        }
        String revengeFactionId = (String)attackerPicker.pick();
        if (revengeFactionId == null || revengeFactionId.isEmpty()) {
            return false;
        }
        FactionAPI revengeFaction = Global.getSector().getFaction(revengeFactionId);
        for (MarketAPI market : markets) {
            if (market.hasCondition("abandoned_station") || market.hasCondition("decivilized") || market.getPrimaryEntity() instanceof CampaignFleetAPI || !market.getFactionId().equals(revengeFactionId) || !market.hasCondition("spaceport") && !market.hasCondition("orbital_station") && !market.hasCondition("military_base") && !market.hasCondition("regional_capital") && !market.hasCondition("headquarters") || market.getSize() < 3) continue;
            float weight = 1.0f;
            if (market.hasCondition("military_base")) {
                weight *= 1.4f;
            }
            if (market.hasCondition("orbital_station")) {
                weight *= 1.15f;
            }
            if (market.hasCondition("spaceport")) {
                weight *= 1.35f;
            }
            if (market.hasCondition("headquarters")) {
                weight *= 1.3f;
            }
            if (market.hasCondition("regional_capital")) {
                weight *= 1.1f;
            }
            sourcePicker.add((Object)market, weight *= 0.5f + 0.5f * (float)market.getSize() * market.getStabilityValue());
        }
        MarketAPI originMarket = (MarketAPI)sourcePicker.pick();
        if (originMarket == null) {
            return false;
        }
        Vector2f originMarketLoc = originMarket.getLocationInHyperspace();
        for (MarketAPI market : markets) {
            FactionAPI marketFaction = market.getFaction();
            if (InvasionFleetManager.EXCEPTION_LIST.contains(marketFaction.getId()) || !marketFaction.getId().equals(playerAlignedFactionId) || !ExerelinUtilsMarket.shouldTargetForInvasions(market, 0)) continue;
            float dist = Misc.getDistance((Vector2f)market.getLocationInHyperspace(), (Vector2f)originMarketLoc);
            if (dist < 5000.0f) {
                dist = 5000.0f;
            }
            float weight = 20000.0f / dist;
            if (market.hasCondition("military_base")) {
                weight *= 1.25f;
            }
            if (market.hasCondition("headquarters")) {
                weight *= 1.5f;
            }
            if (market.hasCondition("regional_capital")) {
                weight *= 1.2f;
            }
            targetPicker.add((Object)market, weight);
        }
        MarketAPI targetMarket = (MarketAPI)targetPicker.pick();
        if (targetMarket == null) {
            return false;
        }
        String debugStr = "Spawning revengeance fleet for " + revengeFactionId + "; source " + originMarket.getName() + "; target " + targetMarket.getName();
        log.info((Object)debugStr);
        if (Global.getSettings().isDevMode()) {
            // empty if block
        }
        InvasionFleetManager.InvasionFleetData data = InvasionFleetManager.spawnInvasionFleet(revengeFaction, originMarket, targetMarket, 1.15f, 1.5f, false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("target", targetMarket);
        params.put("dp", Float.valueOf(data.startingFleetPoints));
        data.event = event = (InvasionFleetEvent)Global.getSector().getEventManager().startEvent(new CampaignEventTarget(originMarket), "exerelin_invasion_fleet", params);
        event.reportStart();
        return true;
    }

    public static RevengeanceManagerEvent getOngoingEvent() {
        CampaignEventPlugin eventSuper = Global.getSector().getEventManager().getOngoingEvent(null, "exerelin_revengeance_manager");
        if (eventSuper != null) {
            RevengeanceManagerEvent event = (RevengeanceManagerEvent)eventSuper;
            return event;
        }
        return null;
    }
}

