/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import exerelin.utilities.StringHelper;

public class SecurityAlertEvent
extends BaseEventPlugin {
    public static final float DAYS_PER_STAGE = 15.0f;
    public static final float ALERT_LEVEL_DECREMENT = 0.25f;
    protected float elapsedDays = 0.0f;
    protected float alertLevel = 0.0f;
    private boolean ended = false;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
    }

    public void startEvent() {
        super.startEvent();
        if (this.market == null) {
            this.endEvent();
            return;
        }
    }

    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.elapsedDays >= 15.0f) {
            this.elapsedDays -= 15.0f;
            this.alertLevel -= 0.25f;
        }
        if (this.alertLevel <= 0.0f) {
            this.endEvent();
        }
    }

    private void endEvent() {
        this.ended = true;
    }

    public boolean isDone() {
        return this.ended;
    }

    public float getAlertLevel() {
        return this.alertLevel;
    }

    public void setAlertLevel(float alertLevel) {
        this.alertLevel = alertLevel;
        if (alertLevel <= 0.0f) {
            this.endEvent();
        }
    }

    public void increaseAlertLevel(float level) {
        this.alertLevel += level;
        if (this.alertLevel <= 0.0f) {
            this.endEvent();
        }
    }

    public void decreaseAlertLevel(float level) {
        this.alertLevel -= level;
        if (this.alertLevel <= 0.0f) {
            this.endEvent();
        }
    }

    public String getEventName() {
        return StringHelper.getStringAndSubstituteToken("exerelin_events", "securityAlert", "$market", this.market.getName());
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }
}

