/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtilsReputation;
import exerelin.utilities.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SlavesSoldEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(SlavesSoldEvent.class);
    protected static final int DAYS_TO_KEEP = 60;
    protected float avgRepChange = 0.0f;
    protected List<String> factionsToNotify = new ArrayList<String>();
    protected Map<String, Object> params = new HashMap<String, Object>();
    protected Map<String, Float> repPenalties = new HashMap<String, Float>();
    protected int numSlaves = 0;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        this.factionsToNotify = (List)this.params.get("factionsToNotify");
        this.repPenalties = (HashMap)this.params.get("repPenalties");
        this.numSlaves = (Integer)this.params.get("numSlaves");
        this.avgRepChange = ((Float)this.params.get("avgRepChange")).floatValue();
    }

    public void startEvent() {
    }

    public void reportSlaveTrade(MarketAPI loc, Map<String, Object> params) {
        this.market = loc;
        this.setParam(params);
        MessagePriority priority = MessagePriority.ENSURE_DELIVERY;
        Global.getSector().reportEventStage((CampaignEventPlugin)this, "report", loc.getPrimaryEntity(), priority, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

            public void beforeDelivery(CommMessageAPI message) {
                for (String factionId : SlavesSoldEvent.this.factionsToNotify) {
                    float penalty = SlavesSoldEvent.this.repPenalties.get(factionId).floatValue();
                    if (factionId.equals(SlavesSoldEvent.this.market.getFactionId())) {
                        ExerelinUtilsReputation.adjustPlayerReputation(Global.getSector().getFaction(factionId), SlavesSoldEvent.this.market.getPrimaryEntity().getActivePerson(), penalty);
                        continue;
                    }
                    ExerelinUtilsReputation.adjustPlayerReputation(Global.getSector().getFaction(factionId), null, penalty);
                }
            }
        });
    }

    public String getEventName() {
        return StringHelper.getStringAndSubstituteToken("exerelin_events", "slaveTrade", "$market", this.market.getName());
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        map.put("$market", this.market.getName());
        map.put("$location", this.market.getPrimaryEntity().getContainingLocation().getName());
        map.put("$numFactions", "" + this.factionsToNotify.size());
        map.put("$repPenaltyAbs", "" + (int)Math.ceil(Math.abs(this.avgRepChange * 100.0f)));
        return map;
    }

    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList();
        this.addTokensToList(result, new String[]{"$numFactions"});
        this.addTokensToList(result, new String[]{"$repPenaltyAbs"});
        return result.toArray(new String[0]);
    }

    public boolean isDone() {
        return false;
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }

    public static float getSlaveRepPenalty(String factionId, int slaveCount) {
        FactionAPI faction = Global.getSector().getFaction(factionId);
        if (faction.isNeutralFaction() || faction.isPlayerFaction() || factionId.equals("player_npc")) {
            return 0.0f;
        }
        float penalty = 0.0f;
        ExerelinFactionConfig conf = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (conf.morality == ExerelinFactionConfig.Morality.NEUTRAL) {
            penalty = ExerelinConfig.prisonerSlaveRepValue;
        } else if (conf.morality == ExerelinFactionConfig.Morality.GOOD) {
            penalty = ExerelinConfig.prisonerSlaveRepValue * 2.0f;
        } else {
            return 0.0f;
        }
        return penalty * (float)slaveCount;
    }
}

