/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.campaign.events.CovertOpsEventBase;
import exerelin.utilities.ExerelinUtilsReputation;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SuperweaponEvent
extends BaseEventPlugin {
    public static final float DAYS_PER_STAGE = 20.0f;
    public static final float REPUTATION_PENALTY_BASE = 0.02f;
    protected float elapsedDays = 0.0f;
    protected int stabilityPenalty = 0;
    protected String conditionToken = null;
    protected Map<String, Object> params;
    protected FactionAPI lastAttackerFaction = null;
    protected float repPenalty = 0.0f;
    protected int numFactions = 0;
    protected float lastRepEffect = 0.0f;
    protected float avgRepLoss = 0.0f;
    protected boolean wasPlayer = false;
    protected boolean ended = false;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.params = new HashMap<String, Object>();
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
    }

    public void startEvent() {
        super.startEvent();
        if (this.market == null) {
            this.endEvent();
            return;
        }
        this.conditionToken = this.market.addCondition("exerelin_superweapon_condition", true, (Object)this);
    }

    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.elapsedDays >= 20.0f) {
            this.elapsedDays -= 20.0f;
            --this.stabilityPenalty;
            this.market.reapplyCondition(this.conditionToken);
        }
        if (this.stabilityPenalty <= 0) {
            this.endEvent();
        }
    }

    public void endEvent() {
        if (this.market != null && this.conditionToken != null) {
            this.market.removeSpecificCondition(this.conditionToken);
        }
        this.ended = true;
    }

    public boolean isDone() {
        return this.ended;
    }

    public int getStabilityPenalty() {
        return this.stabilityPenalty;
    }

    public void setStabilityPenalty(int stabilityPenalty) {
        this.stabilityPenalty = stabilityPenalty;
        if (stabilityPenalty <= 0) {
            this.endEvent();
        } else {
            this.market.reapplyCondition(this.conditionToken);
        }
    }

    public void increaseStabilityPenalty(int penalty) {
        this.stabilityPenalty += penalty;
        if (this.stabilityPenalty <= 0) {
            this.endEvent();
        } else {
            this.market.reapplyCondition(this.conditionToken);
        }
    }

    public void reduceStabilityPenalty(int penalty) {
        this.stabilityPenalty -= penalty;
        if (this.stabilityPenalty <= 0) {
            this.endEvent();
        } else {
            this.market.reapplyCondition(this.conditionToken);
        }
    }

    public void reportSuperweaponUse(CampaignFleetAPI attackingFleet) {
        String stage = "weaponUsed";
        FactionAPI attackerFaction = attackingFleet.getFaction();
        FactionAPI targetFaction = this.market.getFaction();
        String targetFactionId = this.market.getFactionId();
        final HashMap<String, Float> repLossThirdParty = new HashMap<String, Float>();
        if (attackingFleet == Global.getSector().getPlayerFleet()) {
            stage = stage + "_player";
            this.wasPlayer = true;
            String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
            attackerFaction = Global.getSector().getFaction(playerAlignedFactionId);
            float totalRepLoss = 0.0f;
            ArrayList<String> factions = SectorManager.getLiveFactionIdsCopy();
            for (String factionId : factions) {
                if (factionId.equals(targetFactionId) || targetFaction.isHostileTo(factionId) || factionId.equals("player_npc") || factionId.equals(playerAlignedFactionId)) continue;
                float loss = 0.02f;
                float repMult = 0.0f;
                RepLevel level = targetFaction.getRelationshipLevel(factionId);
                if (level == RepLevel.COOPERATIVE) {
                    repMult = 1.0f;
                } else if (level == RepLevel.FRIENDLY) {
                    repMult = 0.8f;
                } else if (level == RepLevel.WELCOMING) {
                    repMult = 0.6f;
                } else if (level == RepLevel.FAVORABLE) {
                    repMult = 0.4f;
                } else if (level == RepLevel.NEUTRAL) {
                    repMult = 0.2f;
                } else if (level == RepLevel.SUSPICIOUS) {
                    repMult = 0.1f;
                } else if (level == RepLevel.INHOSPITABLE) {
                    repMult = 0.05f;
                }
                if ((loss *= repMult * (float)this.market.getSize()) <= 0.0f) continue;
                ++this.numFactions;
                totalRepLoss += loss;
                repLossThirdParty.put(factionId, Float.valueOf(loss));
            }
            this.avgRepLoss = totalRepLoss / (float)this.numFactions;
        } else {
            this.wasPlayer = false;
        }
        this.repPenalty = (float)this.market.getSize() * 0.02f * 2.0f;
        RepLevel worst = RepLevel.HOSTILE;
        if (this.market.getSize() >= 5) {
            worst = RepLevel.VENGEFUL;
        }
        this.repPenalty = DiplomacyManager.adjustRelations((FactionAPI)targetFaction, (FactionAPI)attackerFaction, (float)(-this.repPenalty), (RepLevel)worst, null, null).delta;
        this.lastAttackerFaction = attackerFaction;
        MessagePriority priority = MessagePriority.DELIVER_IMMEDIATELY;
        Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, this.market.getPrimaryEntity(), priority, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

            public void beforeDelivery(CommMessageAPI message) {
                for (Map.Entry tmp : repLossThirdParty.entrySet()) {
                    String factionId = (String)tmp.getKey();
                    float loss = ((Float)tmp.getValue()).floatValue();
                    ExerelinUtilsReputation.adjustPlayerReputation(Global.getSector().getFaction(factionId), null, -loss);
                }
                ExerelinUtilsReputation.syncFactionRelationshipsToPlayer();
            }
        });
    }

    public Map<String, String> getTokenReplacements() {
        FactionAPI playerAlignedFaction = Global.getSector().getFaction(PlayerFactionStore.getPlayerFactionId());
        Map map = super.getTokenReplacements();
        SuperweaponEvent.addFactionNameTokens((Map)map, (String)"attacker", (FactionAPI)this.lastAttackerFaction);
        map.put("$stabilityPenalty", Math.abs(this.stabilityPenalty) + "");
        map.put("$relDeltaAbs", "" + (int)Math.ceil(Math.abs(this.repPenalty * 100.0f)));
        map.put("$newRelationStr", CovertOpsEventBase.getNewRelationStr(this.lastAttackerFaction, this.market.getFaction()));
        if (this.wasPlayer) {
            map.put("$numFactions", "" + this.numFactions);
            map.put("$repPenaltyAvgAbs", "" + (int)Math.ceil(this.avgRepLoss * 100.0f));
        }
        return map;
    }

    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList();
        this.addTokensToList(result, new String[]{"$stabilityPenalty"});
        this.addTokensToList(result, new String[]{"$relDeltaAbs"});
        this.addTokensToList(result, new String[]{"$newRelationStr"});
        if (stageId.contains("player")) {
            this.addTokensToList(result, new String[]{"$numFactions"});
            this.addTokensToList(result, new String[]{"$repPenaltyAvgAbs"});
        }
        return result.toArray(new String[0]);
    }

    public Color[] getHighlightColors(String stageId) {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Misc.getNegativeHighlightColor());
        colors.add(Misc.getNegativeHighlightColor());
        colors.add(this.lastAttackerFaction.getRelColor(this.market.getFactionId()));
        if (stageId.contains("player")) {
            colors.add(Misc.getHighlightColor());
            colors.add(Misc.getNegativeHighlightColor());
        }
        return colors.toArray(new Color[0]);
    }

    public String getEventName() {
        return StringHelper.getStringAndSubstituteToken("exerelin_events", "superweapon", "$market", this.market.getName());
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.EVENT;
    }
}

