/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.SectorManager;
import exerelin.utilities.StringHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class VictoryEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(VictoryEvent.class);
    protected boolean diplomaticVictory;
    protected String victorFactionId;
    protected Map<String, Object> params;
    protected boolean playerVictory;
    protected boolean retired;
    public boolean done;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.params = new HashMap<String, Object>();
        this.done = false;
        this.diplomaticVictory = false;
        this.playerVictory = false;
        this.retired = false;
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        this.diplomaticVictory = (Boolean)this.params.get("diplomaticVictory");
        this.victorFactionId = (String)this.params.get("victorFactionId");
        this.playerVictory = (Boolean)this.params.get("playerVictory");
        this.retired = (Boolean)this.params.get("retired");
    }

    public void startEvent() {
        MessagePriority priority = MessagePriority.DELIVER_IMMEDIATELY;
        String stage = "\u5f81\u670d\u6a21\u5f0f";
        if (this.retired) {
            stage = "retired";
            Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, (SectorEntityToken)Global.getSector().getPlayerFleet(), priority);
        } else {
            if (this.diplomaticVictory) {
                stage = "diplomatic";
            }
            if (this.playerVictory) {
                stage = stage + "_player";
            }
            Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, (SectorEntityToken)Global.getSector().getPlayerFleet(), priority);
            if (this.playerVictory) {
                Global.getSector().getCampaignUI().addMessage("\u4f60\u8d62\u4e86!", Global.getSettings().getColor("textFriendColor"));
            } else {
                Global.getSector().getCampaignUI().addMessage("\u4f60\u8f93\u4e86...", Global.getSettings().getColor("textEnemyColor"));
            }
        }
        log.info((Object)("\u80dc\u5229\u4e8b\u4ef6: " + stage));
    }

    public String getEventName() {
        FactionAPI victorFaction = Global.getSector().getFaction(this.victorFactionId);
        return Misc.ucFirst((String)StringHelper.getStringAndSubstituteToken("exerelin_events", "victory", "$faction", victorFaction.getDisplayName()));
    }

    public String getCurrentImage() {
        return Global.getSector().getFaction(this.victorFactionId).getLogo();
    }

    public String getCurrentMessageIcon() {
        return Global.getSector().getFaction(this.victorFactionId).getCrest();
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.EVENT;
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        FactionAPI victorFaction = Global.getSector().getFaction(this.victorFactionId);
        String victorFactionStr = victorFaction.getDisplayName();
        String theVictorFactionStr = victorFaction.getDisplayNameLongWithArticle();
        map.put("$victorFaction", victorFactionStr);
        map.put("$VictorFaction", Misc.ucFirst((String)victorFactionStr));
        map.put("$theVictorFaction", theVictorFactionStr);
        map.put("$TheVictorFaction", Misc.ucFirst((String)theVictorFactionStr));
        map.put("$clusterName", SectorManager.getFirstStarName());
        map.put("$isOrAre", victorFaction.getDisplayNameIsOrAre());
        return map;
    }

    public boolean isDone() {
        return false;
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }
}

