/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.PlayerFactionStore;
import exerelin.utilities.ExerelinUtilsReputation;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WarmongerEvent
extends BaseEventPlugin {
    public static Logger log = Global.getLogger(WarmongerEvent.class);
    protected static final int DAYS_TO_KEEP = 60;
    protected Map<String, Float> repLoss = new HashMap<String, Float>();
    protected float avgRepLoss = 0.0f;
    protected int numFactions = 0;
    protected float myFactionLoss = 0.0f;
    protected Map<String, Object> params;
    protected String targetFaction = "independent";
    protected float age;
    protected boolean done;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.params = new HashMap<String, Object>();
        this.done = false;
        this.age = 0.0f;
    }

    public void setParam(Object param) {
        this.params = (HashMap)param;
        this.repLoss = (HashMap)this.params.get("repLoss");
        this.avgRepLoss = ((Float)this.params.get("avgRepLoss")).floatValue();
        this.myFactionLoss = ((Float)this.params.get("myFactionLoss")).floatValue();
        this.numFactions = (Integer)this.params.get("numFactions");
        this.targetFaction = (String)this.params.get("targetFaction");
    }

    public void advance(float amount) {
        if (this.done) {
            return;
        }
        this.age += Global.getSector().getClock().convertToDays(amount);
        if (this.age > 60.0f) {
            this.done = true;
            return;
        }
    }

    public void startEvent() {
        MessagePriority priority = MessagePriority.DELIVER_IMMEDIATELY;
        String stage = "report";
        if (this.myFactionLoss <= 0.0f) {
            stage = "report_noOwnFaction";
        }
        Global.getSector().reportEventStage((CampaignEventPlugin)this, stage, (SectorEntityToken)Global.getSector().getPlayerFleet(), priority, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

            public void beforeDelivery(CommMessageAPI message) {
                for (Map.Entry<String, Float> tmp : WarmongerEvent.this.repLoss.entrySet()) {
                    String factionId = tmp.getKey();
                    float loss = tmp.getValue().floatValue();
                    ExerelinUtilsReputation.adjustPlayerReputation(Global.getSector().getFaction(factionId), null, -loss);
                }
                ExerelinUtilsReputation.syncFactionRelationshipsToPlayer();
            }
        });
    }

    public String getEventName() {
        return StringHelper.getString("exerelin_events", "warmonger");
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.DO_NOT_SHOW_IN_MESSAGE_FILTER;
    }

    protected String getNewRelationStr() {
        FactionAPI faction = Global.getSector().getFaction(PlayerFactionStore.getPlayerFactionId());
        RepLevel level = RepLevel.getLevelFor((float)(faction.getRelationship("player") - this.myFactionLoss));
        int repInt = (int)Math.ceil((faction.getRelationship("player") - this.myFactionLoss) * 100.0f);
        String standing = "" + repInt + "/100" + " (" + level.getDisplayName().toLowerCase() + ")";
        return standing;
    }

    public Map<String, String> getTokenReplacements() {
        FactionAPI playerAlignedFaction = Global.getSector().getFaction(PlayerFactionStore.getPlayerFactionId());
        Map map = super.getTokenReplacements();
        if (this.myFactionLoss > 0.0f) {
            map.put("$playerFaction", playerAlignedFaction.getDisplayName());
            map.put("$thePlayerFaction", playerAlignedFaction.getDisplayNameWithArticle());
            map.put("$repPenaltyMyFactionAbs", "" + (int)Math.ceil(this.myFactionLoss * 100.0f));
            map.put("$newRelationStr", this.getNewRelationStr());
        }
        map.put("$numFactions", "" + this.numFactions);
        map.put("$repPenaltyAvgAbs", "" + (int)Math.ceil(this.avgRepLoss * 100.0f));
        return map;
    }

    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList();
        if (this.myFactionLoss > 0.0f) {
            this.addTokensToList(result, new String[]{"$repPenaltyMyFactionAbs"});
            this.addTokensToList(result, new String[]{"$newRelationStr"});
            this.addTokensToList(result, new String[]{"$numFactions"});
        }
        this.addTokensToList(result, new String[]{"$repPenaltyAvgAbs"});
        return result.toArray(new String[0]);
    }

    public Color[] getHighlightColors(String stageId) {
        FactionAPI faction = Global.getSector().getFaction(PlayerFactionStore.getPlayerFactionId());
        Color colorRepEffect = Global.getSettings().getColor("textEnemyColor");
        faction.adjustRelationship("player", -this.myFactionLoss);
        Color colorNew = faction.getRelColor("player");
        faction.adjustRelationship("player", this.myFactionLoss);
        return new Color[]{colorRepEffect, colorNew, Misc.getHighlightColor(), colorRepEffect};
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }

    public boolean showAllMessagesIfOngoing() {
        return false;
    }
}

