/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.fleets.InvasionFleetManager;
import exerelin.utilities.ExerelinUtilsFleet;
import exerelin.utilities.StringHelper;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

public class DefenceFleetAI
implements EveryFrameScript {
    public static Logger log = Global.getLogger(DefenceFleetAI.class);
    private final InvasionFleetManager.InvasionFleetData data;
    private float daysTotal = 0.0f;
    private final CampaignFleetAPI fleet;
    private boolean orderedReturn = false;

    public DefenceFleetAI(CampaignFleetAPI fleet, InvasionFleetManager.InvasionFleetData data) {
        this.fleet = fleet;
        this.data = data;
        this.giveInitialAssignment();
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysTotal += days;
        if (this.daysTotal > 150.0f) {
            this.giveStandDownOrders();
            return;
        }
        FleetAssignmentDataAPI assignment = this.fleet.getAI().getCurrentAssignment();
        if (assignment != null) {
            float fp = this.fleet.getFleetPoints();
            if (fp < this.data.startingFleetPoints / 2.0f) {
                this.giveStandDownOrders();
            }
            if (this.orderedReturn) {
                return;
            }
        } else {
            MarketAPI market = this.data.targetMarket;
            StarSystemAPI system = market.getStarSystem();
            String entityName = this.data.target.getName();
            if (system != null) {
                Vector2f dest = Misc.getPointAtRadius((Vector2f)system.getLocation(), (float)1500.0f);
                LocationAPI loc = Global.getSector().getHyperspace();
                SectorEntityToken token = loc.createToken(dest.x, dest.y);
                String systemBaseName = system.getBaseName();
                if (system != this.fleet.getContainingLocation()) {
                    this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, token, 1000.0f, StringHelper.getFleetAssignmentString("travellingToStarSystem", systemBaseName));
                }
                if (this.data.noWander) {
                    this.fleet.addAssignment(FleetAssignment.DEFEND_LOCATION, market.getPrimaryEntity(), 40.0f, StringHelper.getFleetAssignmentString("defending", entityName));
                } else if (Math.random() > 0.8) {
                    this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, system.getHyperspaceAnchor(), 40.0f, StringHelper.getFleetAssignmentString("patrollingAroundStarSystem", systemBaseName));
                } else if (Math.random() > 0.5) {
                    this.fleet.addAssignment(FleetAssignment.DEFEND_LOCATION, market.getPrimaryEntity(), 40.0f, StringHelper.getFleetAssignmentString("defending", entityName));
                } else {
                    this.fleet.addAssignment(FleetAssignment.PATROL_SYSTEM, (SectorEntityToken)system.getStar(), 40.0f, StringHelper.getFleetAssignmentString("attackingStarSystem", systemBaseName));
                }
            } else {
                this.fleet.addAssignment(FleetAssignment.DEFEND_LOCATION, market.getPrimaryEntity(), 40.0f, StringHelper.getFleetAssignmentString("defending", entityName));
            }
        }
    }

    public boolean isDone() {
        return !this.fleet.isAlive();
    }

    public boolean runWhilePaused() {
        return false;
    }

    protected void giveInitialAssignment() {
        if (this.data.noWait) {
            return;
        }
        float daysToOrbit = ExerelinUtilsFleet.getDaysToOrbit(this.fleet);
        this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.source, daysToOrbit, StringHelper.getFleetAssignmentString("preparingFor", this.data.source.getName(), "missionPatrol"));
    }

    protected void giveStandDownOrders() {
        if (!this.orderedReturn) {
            this.orderedReturn = true;
            this.fleet.clearAssignments();
            SectorEntityToken destination = this.data.source;
            this.fleet.addAssignment(FleetAssignment.DELIVER_CREW, destination, 1000.0f, StringHelper.getFleetAssignmentString("returningTo", destination.getName()));
            this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, destination, ExerelinUtilsFleet.getDaysToOrbit(this.fleet), StringHelper.getFleetAssignmentString("standingDown", null, "missionPatrol"));
            this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, destination, 1000.0f);
        }
    }
}

