/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolAssignmentAI;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolFleetManager;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.RollingAverageTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtilsFleet;
import exerelin.utilities.ExerelinUtilsMarket;
import java.util.ArrayList;
import java.util.List;

public class ExerelinPatrolFleetManager
extends PatrolFleetManager {
    public static final float DAILY_POINT_MULT = 0.1f;
    public static final float MARKET_STABILITY_DIVISOR = 5.0f;
    protected MarketAPI market;
    protected List<PatrolFleetManager.PatrolFleetData> activePatrols = new ArrayList<PatrolFleetManager.PatrolFleetData>();
    protected IntervalUtil tracker;
    protected int maxPatrols;
    protected float patrolPoints = 20.0f;
    protected RollingAverageTracker patrolBattlesLost;

    public ExerelinPatrolFleetManager(MarketAPI market) {
        super(market);
        this.market = market;
        float interval = Global.getSettings().getFloat("averagePatrolSpawnInterval");
        this.tracker = new IntervalUtil(interval * 0.75f, interval * 1.25f);
        this.readResolve();
    }

    protected Object readResolve() {
        if (this.patrolBattlesLost == null) {
            float patrolStrengthCheckInterval = Global.getSettings().getFloat("economyIntervalnGameDays");
            float min = patrolStrengthCheckInterval - Math.min(patrolStrengthCheckInterval * 0.5f, 2.0f);
            float max = patrolStrengthCheckInterval + Math.min(patrolStrengthCheckInterval * 0.5f, 2.0f);
            this.patrolBattlesLost = new RollingAverageTracker(min, max, Misc.getEconomyInterval());
        }
        float interval = Global.getSettings().getFloat("averagePatrolSpawnInterval");
        if (this.tracker == null) {
            this.tracker = new IntervalUtil(interval * 0.75f, interval * 1.25f);
        } else {
            this.tracker.setInterval(interval * 0.75f, interval * 1.25f);
        }
        return this;
    }

    public float getMaxPoints(boolean raw) {
        float baseSize;
        float size = baseSize = (float)(this.market.getSize() * 5 + 8);
        if (raw) {
            return size;
        }
        if (this.market.hasCondition("military_base")) {
            size = (float)((double)size + (double)baseSize * 0.2);
        }
        if (this.market.hasCondition("orbital_station")) {
            size = (float)((double)size + (double)baseSize * 0.1);
        }
        if (this.market.hasCondition("spaceport")) {
            size = (float)((double)size + (double)baseSize * 0.1);
        }
        if (this.market.hasCondition("regional_capital")) {
            size = (float)((double)size + (double)baseSize * 0.1);
        }
        if (this.market.hasCondition("headquarters")) {
            size = (float)((double)size + (double)baseSize * 0.2);
        }
        return size;
    }

    public void addPatrolPoints(float points) {
        this.patrolPoints = Math.min(points + this.patrolPoints, this.getMaxPoints(false));
    }

    protected void addDailyPoints(float days) {
        ExerelinFactionConfig factionConfig;
        float baseIncrement;
        float marketSize = this.market.getSize();
        float increment = baseIncrement = marketSize * (0.5f + this.market.getStabilityValue() / 5.0f);
        if (this.market.hasCondition("headquarters")) {
            increment += baseIncrement * 0.2f;
        }
        if (this.market.hasCondition("military_base")) {
            increment += baseIncrement * 0.2f;
        }
        if (this.market.hasCondition("spaceport") || this.market.hasCondition("orbital_station")) {
            increment += baseIncrement * 0.1f;
        }
        if ((factionConfig = ExerelinConfig.getExerelinFactionConfig(this.market.getFactionId())) != null) {
            increment *= factionConfig.patrolSizeMult;
        }
        increment = increment * 0.1f * days;
        this.addPatrolPoints(increment);
    }

    public void advance(float amount) {
        boolean hasStationOrSpaceport;
        float days = Global.getSector().getClock().convertToDays(amount);
        this.patrolBattlesLost.advance(days);
        this.addDailyPoints(days);
        float losses = this.patrolBattlesLost.getAverage();
        float lossMod = Math.min(losses / 2.0f, 4.0f);
        this.tracker.advance(days * Math.max(1.0f, lossMod));
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        if (this.market.hasCondition("decivilized")) {
            return;
        }
        ExerelinFactionConfig factionConfig = ExerelinConfig.getExerelinFactionConfig(this.market.getFactionId());
        float sizeMult = 1.0f;
        if (this.market.getFaction().getCustom().optBoolean("noPatrols") && (factionConfig == null || !factionConfig.spawnPatrols)) {
            return;
        }
        sizeMult = factionConfig.patrolSizeMult;
        if (sizeMult <= 0.0f) {
            return;
        }
        if (ExerelinUtilsMarket.isMarketBeingInvaded(this.market)) {
            return;
        }
        ArrayList<PatrolFleetManager.PatrolFleetData> remove = new ArrayList<PatrolFleetManager.PatrolFleetData>();
        for (PatrolFleetManager.PatrolFleetData data : this.activePatrols) {
            if (data.fleet.getContainingLocation() != null && data.fleet.getContainingLocation().getFleets().contains(data.fleet)) continue;
            remove.add(data);
            log.info((Object)("Cleaning up orphaned patrol [" + data.fleet.getNameWithFaction() + "] for market [" + this.market.getName() + "]"));
        }
        this.activePatrols.removeAll(remove);
        if (this.patrolPoints < 4.0f) {
            return;
        }
        this.maxPatrols = (int)((float)Math.max(1, this.market.getSize() - 3) * (this.market.getStabilityValue() / 10.0f)) + (int)Math.max(0.0f, Math.min(losses, 5.0f));
        if (this.maxPatrols < 1) {
            this.maxPatrols = 1;
        }
        boolean bl = hasStationOrSpaceport = this.market.hasCondition("orbital_station") || this.market.hasCondition("spaceport");
        if (this.market.hasCondition("military_base")) {
            ++this.maxPatrols;
            if (hasStationOrSpaceport) {
                ++this.maxPatrols;
            }
        }
        if (hasStationOrSpaceport) {
            ++this.maxPatrols;
        }
        log.debug((Object)"");
        log.debug((Object)("Checking whether to spawn patrol for market [" + this.market.getName() + "]"));
        if (this.activePatrols.size() < this.maxPatrols) {
            log.info((Object)(this.activePatrols.size() + " out of a maximum " + this.maxPatrols + " patrols in play for market [" + this.market.getName() + "]"));
            WeightedRandomPicker picker = new WeightedRandomPicker();
            picker.add((Object)FleetFactory.PatrolType.FAST, (float)Math.max(1, this.maxPatrols - this.getCount(FleetFactory.PatrolType.COMBAT, FleetFactory.PatrolType.HEAVY)));
            picker.add((Object)FleetFactory.PatrolType.COMBAT, (float)Math.max(1, this.maxPatrols - this.getCount(FleetFactory.PatrolType.FAST, FleetFactory.PatrolType.HEAVY) + this.market.getSize()) + lossMod * 0.5f);
            if (this.market.getSize() >= 5 && this.patrolPoints >= 12.0f) {
                picker.add((Object)FleetFactory.PatrolType.HEAVY, (float)Math.max(1, this.maxPatrols - this.getCount(FleetFactory.PatrolType.FAST, FleetFactory.PatrolType.COMBAT) + this.market.getSize() - 5) + lossMod);
            }
            FleetFactory.PatrolType type = (FleetFactory.PatrolType)picker.pick();
            float combat = 0.0f;
            float tanker = 0.0f;
            float freighter = 0.0f;
            String fleetType = "patrolSmall";
            switch (type) {
                case FAST: {
                    fleetType = "patrolSmall";
                    combat = Math.round(3.0f + (float)Math.random() * 2.0f);
                    combat += Math.min(5.0f, lossMod * 2.0f);
                    break;
                }
                case COMBAT: {
                    fleetType = "patrolMedium";
                    combat = Math.round(6.0f + (float)Math.random() * 3.0f);
                    combat += Math.min(15.0f, lossMod * 4.0f);
                    tanker = Math.round((float)Math.random());
                    break;
                }
                case HEAVY: {
                    fleetType = "patrolLarge";
                    combat = Math.round(10.0f + (float)Math.random() * 5.0f);
                    combat += Math.min(25.0f, lossMod * 6.0f);
                    tanker = 2.0f;
                    freighter = 2.0f;
                }
            }
            combat *= 1.0f + this.market.getStabilityValue() / 20.0f;
            combat *= sizeMult;
            if (combat > this.patrolPoints) {
                log.info((Object)("Desired patrol size exceeding patrol points: " + combat + " / " + this.patrolPoints));
            }
            combat = Math.min(combat, this.patrolPoints);
            FleetParams params = new FleetParams(null, this.market, this.market.getFactionId(), null, fleetType, combat, freighter, tanker, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f + Math.min(1.0f, lossMod / 12.5f), 0 + (int)(lossMod * 0.75f));
            CampaignFleetAPI fleet = ExerelinUtilsFleet.customCreateFleet(this.market.getFaction(), params);
            if (fleet == null) {
                return;
            }
            SectorEntityToken entity = this.market.getPrimaryEntity();
            entity.getContainingLocation().addEntity((SectorEntityToken)fleet);
            fleet.setLocation(entity.getLocation().x, entity.getLocation().y);
            PatrolFleetManager.PatrolFleetData data = new PatrolFleetManager.PatrolFleetData(fleet, type);
            data.startingFleetPoints = fleet.getFleetPoints();
            data.sourceMarket = this.market;
            this.activePatrols.add(data);
            PatrolAssignmentAI ai = new PatrolAssignmentAI(fleet, data);
            fleet.addScript((EveryFrameScript)ai);
            fleet.getMemoryWithoutUpdate().set("$isPatrol", (Object)true);
            if (type == FleetFactory.PatrolType.FAST || type == FleetFactory.PatrolType.COMBAT) {
                fleet.getMemoryWithoutUpdate().set("$isCustomsInspector", (Object)true);
            }
            fleet.getCommander().setPostId(Ranks.POST_PATROL_COMMANDER);
            switch (type) {
                case FAST: {
                    fleet.getCommander().setRankId(Ranks.SPACE_LIEUTENANT);
                    break;
                }
                case COMBAT: {
                    fleet.getCommander().setRankId(Ranks.SPACE_COMMANDER);
                    break;
                }
                case HEAVY: {
                    fleet.getCommander().setRankId(Ranks.SPACE_CAPTAIN);
                }
            }
            this.patrolPoints -= combat;
            log.info((Object)("Spawned patrol fleet [" + fleet.getNameWithFaction() + "] from market " + this.market.getName()));
        } else {
            log.debug((Object)("Maximum number of " + this.maxPatrols + " patrols already in play for market [" + this.market.getName() + "]"));
        }
    }

    protected int getCount(FleetFactory.PatrolType ... types) {
        int count = 0;
        for (FleetFactory.PatrolType type : types) {
            for (PatrolFleetManager.PatrolFleetData data : this.activePatrols) {
                if (data.type != type) continue;
                ++count;
            }
        }
        return count;
    }

    public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        super.reportFleetDespawned(fleet, reason, param);
        for (PatrolFleetManager.PatrolFleetData data : this.activePatrols) {
            if (data.fleet != fleet) continue;
            this.activePatrols.remove(data);
            break;
        }
    }

    public void reportBattleOccurred(CampaignFleetAPI primaryWinner, BattleAPI battle) {
        boolean playerWon = battle.isPlayerSide(battle.getSideFor(primaryWinner));
        boolean playerLost = battle.isPlayerSide(battle.getOtherSideFor(primaryWinner));
        if (primaryWinner.isInOrNearSystem(this.market.getStarSystem())) {
            if (primaryWinner.getFaction().getId().equals("pirates")) {
                return;
            }
            if (primaryWinner.getFaction().getId().equals("luddic_path")) {
                return;
            }
            for (CampaignFleetAPI loser : battle.getOtherSideSnapshotFor(primaryWinner)) {
                if (loser.getFaction() == this.market.getFaction()) {
                    if (!playerWon) continue;
                    this.patrolBattlesLost.add(1.0f);
                    continue;
                }
                if (primaryWinner.getFaction() != this.market.getFaction()) continue;
                if (loser.getFaction().getId().equals("pirates")) {
                    return;
                }
                if (loser.getFaction().getId().equals("luddic_path")) {
                    return;
                }
                if (!playerLost) continue;
                this.patrolBattlesLost.sub(1.0f);
            }
        }
    }
}

