/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import data.scripts.world.exigency.Tasserus;
import exerelin.campaign.InvasionRound;
import exerelin.campaign.events.InvasionFleetEvent;
import exerelin.campaign.fleets.InvasionFleetManager;
import exerelin.campaign.fleets.ResponseFleetManager;
import exerelin.utilities.ExerelinUtilsFleet;
import exerelin.utilities.StringHelper;
import java.util.List;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

public class InvasionFleetAI
implements EveryFrameScript {
    public static Logger log = Global.getLogger(InvasionFleetAI.class);
    public static final float INVADE_ORBIT_TIME = 2.5f;
    public static final float INVADE_RESPONSE_DISTANCE = 1500.0f;
    public static final float RESERVE_CONVERSION_EFFICIENCY = 0.8f;
    protected final InvasionFleetManager.InvasionFleetData data;
    protected float daysTotal = 0.0f;
    protected final CampaignFleetAPI fleet;
    protected boolean orderedReturn = false;
    protected boolean responseFleetRequested = false;
    float interval = 0.0f;

    public InvasionFleetAI(CampaignFleetAPI fleet, InvasionFleetManager.InvasionFleetData data) {
        this.fleet = fleet;
        this.data = data;
        this.giveInitialAssignment();
    }

    protected void broadcastHostile() {
        if (this.orderedReturn) {
            return;
        }
        List fleets = this.fleet.getContainingLocation().getFleets();
        for (CampaignFleetAPI otherFleet : fleets) {
            CampaignFleetAIAPI ai;
            CampaignFleetAIAPI.EncounterOption option;
            float dist;
            if (otherFleet == this.fleet || !(otherFleet.getAI() instanceof CampaignFleetAIAPI) || !this.fleet.getFaction().isHostileTo(otherFleet.getFaction()) || !((dist = Misc.getDistance((Vector2f)otherFleet.getLocation(), (Vector2f)this.fleet.getLocation())) <= 1500.0f) || (option = (ai = otherFleet.getAI()).pickEncounterOption(null, this.fleet)) != CampaignFleetAIAPI.EncounterOption.ENGAGE && option != CampaignFleetAIAPI.EncounterOption.HOLD) continue;
            ai.addAssignmentAtStart(FleetAssignment.INTERCEPT, (SectorEntityToken)this.fleet, 2.0f, StringHelper.getFleetAssignmentString("intercepting", this.fleet.getName()), null);
        }
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysTotal += days;
        if (this.daysTotal > 150.0f) {
            this.giveStandDownOrders();
            return;
        }
        this.interval += days;
        if (this.interval > 0.25f) {
            this.interval -= 0.25f;
        } else {
            return;
        }
        FleetAssignmentDataAPI assignment = this.fleet.getAI().getCurrentAssignment();
        if (assignment != null) {
            int marines;
            float fp;
            if (!this.data.target.getFaction().isHostileTo(this.fleet.getFaction())) {
                if (this.data.event != null) {
                    if (this.data.target.getFaction() == this.fleet.getFaction()) {
                        this.data.event.endEvent(InvasionFleetEvent.FleetReturnReason.ALREADY_CAPTURED, this.data.target);
                    } else {
                        this.data.event.endEvent(InvasionFleetEvent.FleetReturnReason.NO_LONGER_HOSTILE, this.data.target);
                    }
                }
                this.giveStandDownOrders();
            }
            if ((fp = (float)this.fleet.getFleetPoints()) < this.data.startingFleetPoints / 2.0f) {
                if (this.data.event != null) {
                    this.data.event.endEvent(InvasionFleetEvent.FleetReturnReason.SHIP_LOSSES, (SectorEntityToken)this.data.fleet);
                }
                this.giveStandDownOrders();
            }
            if ((float)(marines = this.fleet.getCargo().getMarines()) < (float)this.data.marineCount * 0.4f) {
                if (this.data.event != null) {
                    this.data.event.endEvent(InvasionFleetEvent.FleetReturnReason.MARINE_LOSSES, this.data.target);
                }
                this.giveStandDownOrders();
            }
            if (this.orderedReturn) {
                return;
            }
            if (assignment.getAssignment() == FleetAssignment.ORBIT_PASSIVE && this.data.target.getContainingLocation() == this.data.fleet.getContainingLocation() && Misc.getDistance((Vector2f)this.data.target.getLocation(), (Vector2f)this.data.fleet.getLocation()) < 600.0f) {
                this.fleet.getMemoryWithoutUpdate().set("$core_fleetBusy", (Object)true, 2.5f);
                if (!this.responseFleetRequested) {
                    ResponseFleetManager.requestResponseFleet(this.data.targetMarket, (SectorEntityToken)this.data.fleet);
                    this.broadcastHostile();
                }
                this.data.targetMarket.getMemoryWithoutUpdate().set("$beingInvaded", (Object)true, 2.5f);
            } else if (assignment.getAssignment() == FleetAssignment.HOLD && this.data.target.getContainingLocation() == this.data.fleet.getContainingLocation() && Misc.getDistance((Vector2f)this.data.target.getLocation(), (Vector2f)this.data.fleet.getLocation()) < 600.0f) {
                if (!this.data.target.getFaction().isHostileTo(this.fleet.getFaction())) {
                    this.giveStandDownOrders();
                } else {
                    InvasionRound.InvasionRoundResult result = InvasionRound.AttackMarket(this.fleet, this.data.target, false);
                    if (result.getSuccess()) {
                        this.data.event.endEvent(InvasionFleetEvent.FleetReturnReason.MISSION_COMPLETE, this.data.target);
                        this.data.targetMarket.getMemoryWithoutUpdate().unset("$beingInvaded");
                    }
                }
            }
        } else {
            MarketAPI market = this.data.targetMarket;
            StarSystemAPI system = market.getStarSystem();
            String locName = market.getPrimaryEntity().getContainingLocation().getName();
            String marketName = market.getName();
            if (system != null) {
                locName = " " + system.getName();
            }
            if (system != null && system != this.fleet.getContainingLocation()) {
                LocationAPI hyper = Global.getSector().getHyperspace();
                Vector2f dest = Misc.getPointAtRadius((Vector2f)system.getLocation(), (float)1500.0f);
                SectorEntityToken token = hyper.createToken(dest.x, dest.y);
                this.fleet.addAssignment(FleetAssignment.DELIVER_MARINES, token, 1000.0f, StringHelper.getFleetAssignmentString("travellingTo", locName));
                this.fleet.addAssignment(FleetAssignment.DELIVER_MARINES, market.getPrimaryEntity(), 1000.0f, StringHelper.getFleetAssignmentString("travellingTo", marketName));
            } else {
                this.fleet.addAssignment(FleetAssignment.DELIVER_MARINES, market.getPrimaryEntity(), 1000.0f, StringHelper.getFleetAssignmentString("travellingTo", marketName));
            }
            this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, market.getPrimaryEntity(), 2.5f, StringHelper.getFleetAssignmentString("beginningInvasion", marketName));
            this.fleet.addAssignment(FleetAssignment.HOLD, market.getPrimaryEntity(), 2.0f, StringHelper.getFleetAssignmentString("invading", marketName));
        }
    }

    public boolean isDone() {
        return !this.fleet.isAlive();
    }

    public boolean runWhilePaused() {
        return false;
    }

    protected void giveInitialAssignment() {
        if (this.data.noWait) {
            return;
        }
        float daysToOrbit = ExerelinUtilsFleet.getDaysToOrbit(this.fleet);
        this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.source, daysToOrbit, StringHelper.getFleetAssignmentString("preparingFor", this.data.source.getName(), "missionInvasion"));
    }

    protected void giveStandDownOrders() {
        if (!this.orderedReturn) {
            float distToTarget;
            float distToSource;
            this.orderedReturn = true;
            if (this.data.event != null) {
                this.data.event.endEvent(InvasionFleetEvent.FleetReturnReason.OTHER, this.data.source);
            }
            this.fleet.clearAssignments();
            Script despawnScript = null;
            Script despawnScriptFinal = null;
            boolean despawningAtTarget = false;
            if (this.data.target.getFaction() == this.data.fleet.getFaction() && (distToSource = Misc.getDistance((Vector2f)this.data.fleet.getLocationInHyperspace(), (Vector2f)this.data.source.getLocationInHyperspace())) > (distToTarget = Misc.getDistance((Vector2f)this.data.fleet.getLocationInHyperspace(), (Vector2f)this.data.target.getLocationInHyperspace()))) {
                despawningAtTarget = true;
                despawnScript = new Script(){

                    public void run() {
                        float points = (float)InvasionFleetAI.this.fleet.getFleetPoints() * 0.8f;
                        log.info((Object)("Invasion fleet despawning at target " + InvasionFleetAI.this.data.target.getName() + "; can restore " + points + " points"));
                        ResponseFleetManager.modifyReserveSize(InvasionFleetAI.this.data.targetMarket, points);
                    }
                };
            }
            final SectorEntityToken destination = despawningAtTarget ? this.data.target : this.data.source;
            despawnScriptFinal = new Script(){

                public void run() {
                    if (destination.getId().equals("exigency_anomaly")) {
                        Tasserus.getAnomalyPlugin().createBigPulse(Math.min(1.0f, (float)InvasionFleetAI.this.fleet.getFleetSizeCount() / 10.0f), true);
                    }
                }
            };
            this.fleet.addAssignment(FleetAssignment.DELIVER_CREW, destination, 1000.0f, StringHelper.getFleetAssignmentString("returningTo", destination.getName()));
            this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, destination, ExerelinUtilsFleet.getDaysToOrbit(this.fleet), StringHelper.getFleetAssignmentString("endingMission", destination.getName()), despawnScript);
            this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, destination, 1000.0f, despawnScriptFinal);
        }
    }
}

