/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.InvasionRound;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.campaign.events.InvasionFleetEvent;
import exerelin.campaign.fleets.DefenceFleetAI;
import exerelin.campaign.fleets.InvasionFleetAI;
import exerelin.campaign.fleets.InvasionSupportFleetAI;
import exerelin.campaign.fleets.RespawnFleetAI;
import exerelin.campaign.fleets.ResponseFleetManager;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.ExerelinUtilsFleet;
import exerelin.utilities.ExerelinUtilsMarket;
import exerelin.utilities.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class InvasionFleetManager
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static final String MANAGER_MAP_KEY = "exerelin_invasionFleetManager";
    public static final int MIN_MARINE_STOCKPILE_FOR_INVASION = 200;
    public static final float MAX_MARINE_STOCKPILE_TO_DEPLOY = 0.5f;
    public static final float DEFENDER_STRENGTH_FP_MULT = 0.3f;
    public static final float DEFENDER_STRENGTH_MARINE_MULT = 1.15f;
    public static final float RESPAWN_FLEET_SPAWN_DISTANCE = 18000.0f;
    public static final float ALL_AGAINST_ONE_INVASION_POINT_MOD = 0.27f;
    public static final float ONE_AGAINST_ALL_INVASION_BE_TARGETED_MOD = 0.35f;
    public static final float ONE_AGAINST_ALL_INVASION_POINT_MOD = 0.215f;
    public static final float HARD_MODE_INVASION_TARGETING_CHANCE = 1.5f;
    public static final float TEMPLAR_INVASION_POINT_MULT = 1.25f;
    public static final float TEMPLAR_COUNTER_INVASION_FLEET_MULT = 1.25f;
    public static final float TANKER_FP_PER_FLEET_FP_PER_10K_DIST = 0.05f;
    public static final Set<String> EXCEPTION_LIST = new HashSet<String>(Arrays.asList("templars"));
    public static final int MAX_FLEETS = 50;
    public static Logger log = Global.getLogger(InvasionFleetManager.class);
    protected final List<InvasionFleetData> activeFleets = new LinkedList<InvasionFleetData>();
    protected HashMap<String, Float> spawnCounter = new HashMap();
    private final IntervalUtil tracker;
    protected float daysElapsed = 0.0f;
    protected float templarInvasionPoints = 0.0f;
    protected float templarCounterInvasionPoints = 0.0f;
    private static InvasionFleetManager invasionFleetManager;

    public InvasionFleetManager() {
        super(true);
        float interval = 8.0f;
        this.tracker = new IntervalUtil(1.0f, 1.0f);
    }

    public static float calculateMaxFpForFleet(MarketAPI originMarket, MarketAPI targetMarket) {
        ExerelinFactionConfig factionConfig;
        float responseFleetSize = ResponseFleetManager.getMaxReserveSize(targetMarket, true);
        float maxFPbase = responseFleetSize * 0.3f + (float)(8 * (2 + originMarket.getSize()));
        maxFPbase *= (float)(0.5 + (double)(originMarket.getStabilityValue() / 10.0f));
        float maxFP = maxFPbase *= 0.3f;
        if (originMarket.hasCondition("military_base")) {
            maxFP = (float)((double)maxFP + (double)maxFPbase * 0.15);
        }
        if (originMarket.hasCondition("orbital_station")) {
            maxFP = (float)((double)maxFP + (double)maxFPbase * 0.05);
        }
        if (originMarket.hasCondition("spaceport")) {
            maxFP = (float)((double)maxFP + (double)maxFPbase * 0.05);
        }
        if (originMarket.hasCondition("regional_capital")) {
            maxFP = (float)((double)maxFP + (double)maxFPbase * 0.05);
        }
        if (originMarket.hasCondition("headquarters")) {
            maxFP = (float)((double)maxFP + (double)maxFPbase * 0.1);
        }
        if ((factionConfig = ExerelinConfig.getExerelinFactionConfig(originMarket.getFactionId())) != null) {
            maxFP += maxFPbase * factionConfig.invasionFleetSizeMod;
        }
        return (maxFP += (float)Global.getSector().getPlayerPerson().getStats().getLevel() * ExerelinConfig.fleetBonusFpPerPlayerLevel) * (MathUtils.getRandomNumberInRange((float)0.75f, (float)1.0f) + MathUtils.getRandomNumberInRange((float)0.0f, (float)0.25f));
    }

    public static InvasionFleetData spawnFleet(FleetSpawnParams params) {
        float distance;
        int tankerFP;
        int fp;
        String factionId = params.faction.getId();
        FleetParams fleetParams = new FleetParams(null, params.originMarket, factionId, null, params.fleetType, (float)(fp = params.fp) * 0.85f, (float)fp * 0.1f, (float)(tankerFP = (int)((float)fp * 0.05f * (distance = ExerelinUtilsMarket.getHyperspaceDistance(params.originMarket, params.targetMarket)) / 10000.0f)), (float)(params.numMarines / 100 * 2), 0.0f, 0.0f, (float)fp * 0.05f, 0.0f, params.qualityOverride, 1.25f, 1);
        CampaignFleetAPI fleet = ExerelinUtilsFleet.customCreateFleet(params.faction, fleetParams);
        if (fleet == null) {
            return null;
        }
        fleet.getCargo().addMarines(params.numMarines);
        fleet.setName(params.name);
        fleet.setAIMode(true);
        if (params.fleetType.equals("exerelinDefenceFleet")) {
            fleet.getMemoryWithoutUpdate().set("$isPatrol", (Object)true);
        }
        InvasionFleetData data = new InvasionFleetData(fleet);
        data.startingFleetPoints = fleet.getFleetPoints();
        data.sourceMarket = params.originMarket;
        data.source = params.originMarket.getPrimaryEntity();
        data.targetMarket = params.targetMarket;
        data.target = params.targetMarket.getPrimaryEntity();
        data.marineCount = params.numMarines;
        data.noWait = params.noWait;
        data.noWander = params.noWander;
        if (params.spawnLoc == null) {
            params.spawnLoc = params.originMarket.getContainingLocation();
        }
        params.spawnLoc.addEntity((SectorEntityToken)fleet);
        if (params.jumpToOrigin) {
            SectorEntityToken entity = params.originMarket.getPrimaryEntity();
            fleet.setLocation(entity.getLocation().x, entity.getLocation().y);
        }
        Object ai = null;
        if (params.fleetType.equals("exerelinInvasionFleet")) {
            ai = new InvasionFleetAI(fleet, data);
        } else if (params.fleetType.equals("exerelinRespawnFleet")) {
            ai = new RespawnFleetAI(fleet, data);
        } else if (params.fleetType.equals("exerelinDefenceFleet")) {
            ai = new DefenceFleetAI(fleet, data);
        } else if (params.fleetType.equals("exerelinInvasionSupportFleet")) {
            ai = new InvasionSupportFleetAI(fleet, data);
        }
        fleet.addScript((EveryFrameScript)ai);
        if (invasionFleetManager != null) {
            InvasionFleetManager.invasionFleetManager.activeFleets.add(data);
        }
        return data;
    }

    public static String getFleetName(String fleetType, String factionId, float fp) {
        String name = "Fleet";
        ExerelinFactionConfig factionConfig = ExerelinConfig.getExerelinFactionConfig(factionId);
        switch (fleetType) {
            case "exerelinInvasionFleet": 
            case "exerelinRespawnFleet": {
                name = StringHelper.getString("exerelin_fleets", "invasionFleetName");
                if (factionConfig != null) {
                    name = factionConfig.invasionFleetName;
                }
                if (fp <= 18.0f) {
                    name = StringHelper.getString("exerelin_fleets", "invasionFleetPrefixSmall") + " " + name;
                    break;
                }
                if (!(fp >= 54.0f)) break;
                name = StringHelper.getString("exerelin_fleets", "invasionFleetPrefixLarge") + " " + name;
                break;
            }
            case "exerelinInvasionSupportFleet": {
                name = StringHelper.getString("exerelin_fleets", "invasionSupportFleetName");
                if (factionConfig != null) {
                    name = factionConfig.invasionSupportFleetName;
                }
                if (fp <= 15.0f) {
                    name = StringHelper.getString("exerelin_fleets", "invasionSupportFleetPrefixSmall") + " " + name;
                    break;
                }
                if (!(fp >= 45.0f)) break;
                name = StringHelper.getString("exerelin_fleets", "invasionSupportFleetPrefixLarge") + " " + name;
                break;
            }
            case "exerelinDefenceFleet": {
                name = StringHelper.getString("exerelin_fleets", "defenceFleetName");
                if (factionConfig != null) {
                    name = factionConfig.defenceFleetName;
                }
                if (fp <= 15.0f) {
                    name = StringHelper.getString("exerelin_fleets", "defenceFleetPrefixSmall") + " " + name;
                    break;
                }
                if (!(fp >= 45.0f)) break;
                name = StringHelper.getString("exerelin_fleets", "defenceFleetPrefixLarge") + " " + name;
            }
        }
        return name;
    }

    public static InvasionFleetData spawnRespawnFleet(FactionAPI faction, MarketAPI originMarket, MarketAPI targetMarket, boolean useOriginLocation) {
        float defenderStrength = InvasionRound.GetDefenderStrength(targetMarket, 1.0f, false);
        float responseFleetSize = ResponseFleetManager.getMaxReserveSize(targetMarket, false);
        float maxFPbase = responseFleetSize * 0.3f + (float)(8 * (2 + originMarket.getSize()));
        float maxFP = maxFPbase + (float)Global.getSector().getPlayerPerson().getStats().getLevel() * ExerelinConfig.fleetBonusFpPerPlayerLevel;
        maxFP *= MathUtils.getRandomNumberInRange((float)0.75f, (float)1.0f) + MathUtils.getRandomNumberInRange((float)0.0f, (float)0.25f);
        maxFP = (float)((double)maxFP * 0.35);
        String name = InvasionFleetManager.getFleetName("exerelinRespawnFleet", faction.getId(), maxFP);
        LocationAPI spawnLoc = Global.getSector().getHyperspace();
        if (useOriginLocation) {
            spawnLoc = originMarket.getContainingLocation();
        } else if (Global.getSector().getStarSystems().size() == 1) {
            SectorEntityToken entity = originMarket.getPrimaryEntity();
            spawnLoc = entity.getContainingLocation();
        }
        FleetSpawnParams params = new FleetSpawnParams();
        params.name = name;
        params.fleetType = "exerelinRespawnFleet";
        params.faction = faction;
        params.fp = (int)maxFP;
        params.qualityOverride = 1.0f;
        params.originMarket = originMarket;
        params.targetMarket = targetMarket;
        params.spawnLoc = spawnLoc;
        params.jumpToOrigin = false;
        params.noWait = true;
        params.numMarines = (int)(defenderStrength * 1.15f);
        InvasionFleetData fleetData = InvasionFleetManager.spawnFleet(params);
        if (fleetData == null) {
            return null;
        }
        if (useOriginLocation) {
            Vector2f originLoc = originMarket.getPrimaryEntity().getLocation();
            fleetData.fleet.setLocation(originLoc.x, originLoc.y);
        } else {
            float distance = 18000.0f;
            float angle = MathUtils.getRandomNumberInRange((int)0, (int)359);
            fleetData.fleet.setLocation((float)Math.cos(angle) * distance, (float)Math.sin(angle) * distance);
        }
        log.info((Object)("\tSpawned respawn fleet " + fleetData.fleet.getNameWithFaction() + " of size " + maxFP));
        return fleetData;
    }

    public static InvasionFleetData spawnDefenceFleet(FactionAPI faction, MarketAPI originMarket, MarketAPI targetMarket, boolean noWander, boolean noWait) {
        int maxFP = (int)(InvasionFleetManager.calculateMaxFpForFleet(originMarket, targetMarket) * 0.66f);
        float qf = originMarket.getShipQualityFactor();
        qf = Math.max(qf + 0.1f, 0.4f);
        String name = InvasionFleetManager.getFleetName("exerelinDefenseFleet", faction.getId(), maxFP);
        FleetSpawnParams params = new FleetSpawnParams();
        params.name = name;
        params.fleetType = "exerelinDefenseFleet";
        params.faction = faction;
        params.fp = maxFP;
        params.qualityOverride = qf;
        params.originMarket = originMarket;
        params.targetMarket = targetMarket;
        params.noWander = noWander;
        params.noWait = noWait;
        InvasionFleetData fleetData = InvasionFleetManager.spawnFleet(params);
        log.info((Object)("\tSpawned defence fleet " + fleetData.fleet.getNameWithFaction() + " of size " + maxFP));
        return fleetData;
    }

    public static InvasionFleetData spawnSupportFleet(FactionAPI faction, MarketAPI originMarket, MarketAPI targetMarket, boolean noWander, boolean noWait) {
        int maxFP = (int)(InvasionFleetManager.calculateMaxFpForFleet(originMarket, targetMarket) * 0.66f);
        float qf = originMarket.getShipQualityFactor();
        qf = Math.max(qf + 0.1f, 0.4f);
        String name = InvasionFleetManager.getFleetName("exerelinInvasionSupportFleet", faction.getId(), maxFP);
        FleetSpawnParams params = new FleetSpawnParams();
        params.name = name;
        params.fleetType = "exerelinInvasionSupportFleet";
        params.faction = faction;
        params.fp = maxFP;
        params.qualityOverride = qf;
        params.originMarket = originMarket;
        params.targetMarket = targetMarket;
        params.noWander = true;
        params.noWait = noWait;
        InvasionFleetData fleetData = InvasionFleetManager.spawnFleet(params);
        log.info((Object)("\tSpawned strike fleet " + fleetData.fleet.getNameWithFaction() + " of size " + maxFP));
        return fleetData;
    }

    public static InvasionFleetData spawnInvasionFleet(FactionAPI faction, MarketAPI originMarket, MarketAPI targetMarket, float marineMult, boolean noWait) {
        return InvasionFleetManager.spawnInvasionFleet(faction, originMarket, targetMarket, marineMult, 1.0f, noWait);
    }

    public static InvasionFleetData spawnInvasionFleet(FactionAPI faction, MarketAPI originMarket, MarketAPI targetMarket, float marineMult, float fpMult, boolean noWait) {
        float defenderStrength = InvasionRound.GetDefenderStrength(targetMarket, 0.5f, false);
        int maxFP = (int)(InvasionFleetManager.calculateMaxFpForFleet(originMarket, targetMarket) * fpMult);
        float qf = originMarket.getShipQualityFactor();
        qf = Math.max(qf + 0.2f, 0.6f);
        String name = InvasionFleetManager.getFleetName("exerelinInvasionFleet", faction.getId(), maxFP);
        FleetSpawnParams params = new FleetSpawnParams();
        params.name = name;
        params.fleetType = "exerelinInvasionFleet";
        params.faction = faction;
        params.fp = maxFP;
        params.qualityOverride = qf;
        params.originMarket = originMarket;
        params.targetMarket = targetMarket;
        params.noWait = noWait;
        params.numMarines = (int)(defenderStrength * marineMult);
        InvasionFleetData fleetData = InvasionFleetManager.spawnFleet(params);
        log.info((Object)("\tSpawned invasion fleet " + fleetData.fleet.getNameWithFaction() + " of size " + maxFP));
        return fleetData;
    }

    public boolean generateInvasionFleet(FactionAPI faction, FactionAPI targetFaction, boolean strikeOnly) {
        return this.generateInvasionFleet(faction, targetFaction, strikeOnly, 1.0f);
    }

    public boolean generateInvasionFleet(FactionAPI faction, FactionAPI targetFaction, boolean strikeOnly, float sizeMult) {
        SectorAPI sector = Global.getSector();
        List markets = sector.getEconomy().getMarketsCopy();
        WeightedRandomPicker sourcePicker = new WeightedRandomPicker();
        WeightedRandomPicker targetPicker = new WeightedRandomPicker();
        String factionId = faction.getId();
        boolean allowPirates = ExerelinConfig.allowPirateInvasions;
        for (MarketAPI market : markets) {
            if (market.hasCondition("abandoned_station") || !allowPirates && ExerelinUtilsFaction.isPirateFaction(factionId) || market.getPrimaryEntity() instanceof CampaignFleetAPI || ExerelinUtilsMarket.isMarketBeingInvaded(market) || !market.getFactionId().equals(factionId) || market.hasCondition("decivilized") || !market.hasCondition("spaceport") && !market.hasCondition("orbital_station") && !market.hasCondition("military_base") && !market.hasCondition("regional_capital") && !market.hasCondition("headquarters") || market.getSize() < 3) continue;
            float weight = 1.0f;
            if (market.hasCondition("military_base")) {
                weight *= 1.4f;
            }
            if (market.hasCondition("orbital_station")) {
                weight *= 1.15f;
            }
            if (market.hasCondition("spaceport")) {
                weight *= 1.35f;
            }
            if (market.hasCondition("headquarters")) {
                weight *= 1.3f;
            }
            if (market.hasCondition("regional_capital")) {
                weight *= 1.1f;
            }
            sourcePicker.add((Object)market, weight *= 0.5f + 0.5f * (float)market.getSize() * market.getStabilityValue());
        }
        MarketAPI originMarket = (MarketAPI)sourcePicker.pick();
        if (originMarket == null) {
            return false;
        }
        Vector2f originMarketLoc = originMarket.getLocationInHyperspace();
        for (MarketAPI market : markets) {
            FactionAPI marketFaction = market.getFaction();
            String marketFactionId = marketFaction.getId();
            if (EXCEPTION_LIST.contains(marketFactionId) && targetFaction != marketFaction || targetFaction != null && targetFaction != marketFaction || !marketFaction.isHostileTo(faction) || !ExerelinUtilsMarket.shouldTargetForInvasions(market, 0)) continue;
            float dist = Misc.getDistance((Vector2f)market.getLocationInHyperspace(), (Vector2f)originMarketLoc);
            if (dist < 5000.0f) {
                dist = 5000.0f;
            }
            float weight = 20000.0f / dist;
            if (ExerelinUtilsFaction.isFactionHostileToAll(marketFactionId)) {
                weight *= 0.35f;
            }
            if (SectorManager.getHardMode() && (marketFactionId.equals(PlayerFactionStore.getPlayerFactionId()) || marketFactionId.equals("player_npc"))) {
                weight *= 1.5f;
            }
            targetPicker.add((Object)market, weight);
        }
        MarketAPI targetMarket = (MarketAPI)targetPicker.pick();
        if (targetMarket == null) {
            return false;
        }
        if (!strikeOnly) {
            InvasionFleetEvent event;
            log.info((Object)("Spawning invasion fleet for " + faction.getDisplayName() + "; source " + originMarket.getName() + "; target " + targetMarket.getName()));
            InvasionFleetData data = InvasionFleetManager.spawnInvasionFleet(faction, originMarket, targetMarket, 1.15f, false);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("target", targetMarket);
            params.put("dp", Float.valueOf(data.startingFleetPoints));
            data.event = event = (InvasionFleetEvent)Global.getSector().getEventManager().startEvent(new CampaignEventTarget(originMarket), "exerelin_invasion_fleet", params);
            event.reportStart();
        }
        InvasionFleetManager.spawnSupportFleet(faction, originMarket, targetMarket, false, false);
        InvasionFleetManager.spawnSupportFleet(faction, originMarket, targetMarket, false, false);
        return true;
    }

    protected void processInvasionPoints() {
        SectorAPI sector = Global.getSector();
        List markets = sector.getEconomy().getMarketsCopy();
        float marineStockpile = 0.0f;
        boolean allowPirates = ExerelinConfig.allowPirateInvasions;
        if (this.spawnCounter == null) {
            this.spawnCounter = new HashMap();
        }
        HashMap<String, Float> pointsPerFaction = new HashMap<String, Float>();
        for (MarketAPI market : markets) {
            String factionId = market.getFactionId();
            if (EXCEPTION_LIST.contains(factionId)) continue;
            if (!pointsPerFaction.containsKey(factionId)) {
                pointsPerFaction.put(factionId, Float.valueOf(0.0f));
            }
            float points = ((Float)pointsPerFaction.get(factionId)).floatValue();
            pointsPerFaction.put(factionId, Float.valueOf(points += (float)market.getSize() * market.getStabilityValue() * ExerelinConfig.invasionPointEconomyMult));
        }
        int playerLevel = Global.getSector().getPlayerPerson().getStats().getLevel();
        ArrayList<String> liveFactionIds = SectorManager.getLiveFactionIdsCopy();
        for (String factionId : liveFactionIds) {
            float pointsRequired;
            float counter;
            ExerelinFactionConfig config;
            FactionAPI faction;
            if (EXCEPTION_LIST.contains(factionId) || (faction = sector.getFaction(factionId)).isNeutralFaction() || faction.isPlayerFaction() || (config = ExerelinConfig.getExerelinFactionConfig(factionId)) != null && !config.playableFaction) continue;
            boolean isPirateFaction = ExerelinUtilsFaction.isPirateFaction(factionId);
            if (!allowPirates && isPirateFaction) continue;
            float mult = 0.0f;
            List<String> enemies = DiplomacyManager.getFactionsAtWarWithFaction(faction, ExerelinConfig.allowPirateInvasions, false, false);
            if (enemies.isEmpty()) continue;
            if (ExerelinUtilsFaction.isFactionHostileToAll(factionId)) {
                float numWars = enemies.size();
                numWars = (float)Math.sqrt(numWars);
                mult = numWars * 0.215f + 0.78499997f;
            } else {
                for (String enemyId : enemies) {
                    if (EXCEPTION_LIST.contains(factionId)) continue;
                    if (ExerelinUtilsFaction.isFactionHostileToAll(enemyId)) {
                        float enemyWars = DiplomacyManager.getFactionsAtWarWithFaction(enemyId, ExerelinConfig.allowPirateInvasions, true, false).size();
                        if (!((enemyWars = (float)Math.sqrt(enemyWars)) > 0.0f)) continue;
                        mult += 1.0f / (enemyWars * 0.27f + 1.0f);
                        continue;
                    }
                    mult = 1.0f;
                    break;
                }
                if (mult > 1.0f) {
                    mult = 1.0f;
                }
            }
            if (!this.spawnCounter.containsKey(factionId)) {
                this.spawnCounter.put(factionId, Float.valueOf(0.0f));
            }
            float oldCounter = counter = this.spawnCounter.get(factionId).floatValue();
            float increment = ((Float)pointsPerFaction.get(factionId)).floatValue() + ExerelinConfig.baseInvasionPointsPerFaction;
            increment += ExerelinConfig.invasionPointsPerPlayerLevel * (float)playerLevel;
            increment *= mult * MathUtils.getRandomNumberInRange((float)0.75f, (float)1.25f);
            if (config != null) {
                increment *= config.invasionPointMult;
            }
            if ((counter += increment) < (pointsRequired = ExerelinConfig.pointsRequiredForInvasionFleet)) {
                this.spawnCounter.put(factionId, Float.valueOf(counter));
                if (!(counter > pointsRequired / 2.0f) || !(oldCounter < pointsRequired / 2.0f)) continue;
                this.generateInvasionFleet(faction, null, true);
                continue;
            }
            boolean success = this.generateInvasionFleet(faction, null, false);
            if (!success) continue;
            this.spawnCounter.put(factionId, Float.valueOf(counter -= pointsRequired));
        }
    }

    protected void processTemplarInvasionPoints() {
        boolean success;
        ArrayList<String> liveFactionIds = SectorManager.getLiveFactionIdsCopy();
        if (!liveFactionIds.contains("templars")) {
            return;
        }
        List<String> enemies = DiplomacyManager.getFactionsAtWarWithFaction("templars", ExerelinConfig.allowPirateInvasions, false, false);
        if (enemies.isEmpty()) {
            return;
        }
        float templarDominance = DiplomacyManager.getDominanceFactor("templars");
        float perLevelPoints = (float)Global.getSector().getPlayerPerson().getStats().getLevel() * ExerelinConfig.invasionPointsPerPlayerLevel;
        this.templarInvasionPoints += (100.0f + perLevelPoints) * ExerelinConfig.getExerelinFactionConfig((String)"templars").invasionPointMult * 1.25f;
        this.templarCounterInvasionPoints += (100.0f + 200.0f * templarDominance + perLevelPoints) * 1.25f;
        float req = ExerelinConfig.pointsRequiredForInvasionFleet;
        if (this.templarInvasionPoints >= req && (success = this.generateInvasionFleet(Global.getSector().getFaction("templars"), null, false))) {
            this.templarInvasionPoints -= req;
        }
        if (this.templarCounterInvasionPoints >= req) {
            WeightedRandomPicker picker = new WeightedRandomPicker();
            for (String factionId : enemies) {
                picker.add((Object)factionId, (float)ExerelinUtilsFaction.getFactionMarketSizeSum(factionId));
            }
            FactionAPI faction = Global.getSector().getFaction((String)picker.pick());
            boolean success2 = this.generateInvasionFleet(faction, Global.getSector().getFaction("templars"), false, 1.25f);
            if (success2) {
                this.templarCounterInvasionPoints -= req;
            }
        }
    }

    public void advance(float amount) {
        if (Global.getSector().isInNewGameAdvance()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.daysElapsed < ExerelinConfig.invasionGracePeriod) {
            this.daysElapsed += days;
            return;
        }
        this.tracker.advance(days);
        if (!this.tracker.intervalElapsed()) {
            return;
        }
        LinkedList<InvasionFleetData> remove = new LinkedList<InvasionFleetData>();
        for (InvasionFleetData data : this.activeFleets) {
            if (data.fleet.getContainingLocation() != null && data.fleet.getContainingLocation().getFleets().contains(data.fleet) && data.fleet.isAlive()) continue;
            remove.add(data);
        }
        this.activeFleets.removeAll(remove);
        if (this.activeFleets.size() < 50) {
            this.processInvasionPoints();
        }
        this.processTemplarInvasionPoints();
    }

    public static InvasionFleetManager create() {
        Map data = Global.getSector().getPersistentData();
        invasionFleetManager = (InvasionFleetManager)((Object)data.get(MANAGER_MAP_KEY));
        if (invasionFleetManager != null) {
            return invasionFleetManager;
        }
        invasionFleetManager = new InvasionFleetManager();
        data.put(MANAGER_MAP_KEY, invasionFleetManager);
        return invasionFleetManager;
    }

    public boolean isDone() {
        return false;
    }

    public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        super.reportFleetDespawned(fleet, reason, param);
        for (InvasionFleetData data : this.activeFleets) {
            if (data.fleet != fleet) continue;
            this.activeFleets.remove(data);
            break;
        }
    }

    public boolean runWhilePaused() {
        return false;
    }

    public static class FleetSpawnParams {
        public String name = "Fleet";
        public String fleetType = "genericFleet";
        public int fp = 0;
        public float qualityOverride = -1.0f;
        public FactionAPI faction;
        public MarketAPI originMarket;
        public MarketAPI targetMarket;
        public LocationAPI spawnLoc;
        public boolean noWait = false;
        public boolean jumpToOrigin = true;
        public boolean noWander = false;
        public int numMarines = 0;
    }

    public static class InvasionFleetData {
        public CampaignFleetAPI fleet;
        public SectorEntityToken source;
        public SectorEntityToken target;
        public MarketAPI sourceMarket;
        public MarketAPI targetMarket;
        public float startingFleetPoints = 0.0f;
        public int marineCount = 0;
        public boolean noWait = false;
        public boolean noWander = false;
        public InvasionFleetEvent event;

        public InvasionFleetData(CampaignFleetAPI fleet) {
            this.fleet = fleet;
        }
    }
}

