/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.fleets.InvasionFleetManager;
import exerelin.utilities.ExerelinUtilsFleet;
import exerelin.utilities.StringHelper;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

public class InvasionSupportFleetAI
implements EveryFrameScript {
    public static Logger log = Global.getLogger(InvasionSupportFleetAI.class);
    private final InvasionFleetManager.InvasionFleetData data;
    private float daysTotal = 0.0f;
    private final CampaignFleetAPI fleet;
    private boolean orderedReturn = false;
    private boolean criticalDamage = false;
    float interval = 0.0f;

    public InvasionSupportFleetAI(CampaignFleetAPI fleet, InvasionFleetManager.InvasionFleetData data) {
        this.fleet = fleet;
        this.data = data;
        this.giveInitialAssignment();
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysTotal += days;
        if (this.daysTotal > 150.0f) {
            this.giveStandDownOrders();
            return;
        }
        this.interval += days;
        if (this.interval >= 0.25f) {
            this.interval -= 0.25f;
        } else {
            return;
        }
        FleetAssignmentDataAPI assignment = this.fleet.getAI().getCurrentAssignment();
        if (assignment != null) {
            float fp = this.fleet.getFleetPoints();
            if (fp < this.data.startingFleetPoints / 2.0f) {
                this.criticalDamage = true;
                this.giveStandDownOrders();
            }
            if (!this.data.target.getFaction().isHostileTo(this.fleet.getFaction())) {
                this.giveStandDownOrders();
            }
            if (this.orderedReturn) {
                return;
            }
        } else {
            MarketAPI market = this.data.targetMarket;
            StarSystemAPI system = market.getStarSystem();
            String entityName = this.data.target.getName();
            if (system != null) {
                Vector2f dest = Misc.getPointAtRadius((Vector2f)system.getLocation(), (float)1500.0f);
                LocationAPI loc = Global.getSector().getHyperspace();
                SectorEntityToken token = loc.createToken(dest.x, dest.y);
                String systemBaseName = system.getBaseName();
                if (system != this.fleet.getContainingLocation()) {
                    this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, token, 1000.0f, StringHelper.getFleetAssignmentString("travellingToStarSystem", systemBaseName));
                }
                if (this.data.noWander) {
                    this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, market.getPrimaryEntity(), 40.0f, StringHelper.getFleetAssignmentString("attacking", entityName));
                    this.fleet.addAssignment(FleetAssignment.ATTACK_LOCATION, market.getPrimaryEntity(), 40.0f, StringHelper.getFleetAssignmentString("attacking", entityName));
                } else if (Math.random() > 0.8) {
                    this.fleet.addAssignment(FleetAssignment.RAID_SYSTEM, system.getHyperspaceAnchor(), 40.0f, StringHelper.getFleetAssignmentString("attackingAroundStarSystem", systemBaseName));
                } else if (Math.random() > 0.5) {
                    this.fleet.addAssignment(FleetAssignment.ATTACK_LOCATION, market.getPrimaryEntity(), 40.0f, StringHelper.getFleetAssignmentString("attacking", entityName));
                } else {
                    this.fleet.addAssignment(FleetAssignment.RAID_SYSTEM, (SectorEntityToken)system.getStar(), 40.0f, StringHelper.getFleetAssignmentString("attackingStarSystem", systemBaseName));
                }
            } else {
                this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, market.getPrimaryEntity(), 40.0f, StringHelper.getFleetAssignmentString("attacking", entityName));
                this.fleet.addAssignment(FleetAssignment.ATTACK_LOCATION, market.getPrimaryEntity(), 40.0f, StringHelper.getFleetAssignmentString("attacking", entityName));
            }
        }
    }

    public boolean isDone() {
        return !this.fleet.isAlive();
    }

    public boolean runWhilePaused() {
        return false;
    }

    protected void giveInitialAssignment() {
        if (this.data.noWait) {
            return;
        }
        float daysToOrbit = ExerelinUtilsFleet.getDaysToOrbit(this.fleet);
        this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.source, daysToOrbit, StringHelper.getFleetAssignmentString("preparingFor", this.data.source.getName(), "missionStrike"));
    }

    protected void giveStandDownOrders() {
        if (!this.orderedReturn) {
            this.orderedReturn = true;
            this.fleet.clearAssignments();
            float daysToOrbit = ExerelinUtilsFleet.getDaysToOrbit(this.fleet);
            SectorEntityToken destination = this.data.source;
            if (this.criticalDamage) {
                float distToTarget;
                float distToSource;
                if (this.data.target.getFaction() == this.data.fleet.getFaction() && (distToSource = Misc.getDistance((Vector2f)this.data.fleet.getLocationInHyperspace(), (Vector2f)this.data.source.getLocationInHyperspace())) > (distToTarget = Misc.getDistance((Vector2f)this.data.fleet.getLocationInHyperspace(), (Vector2f)this.data.target.getLocationInHyperspace()))) {
                    destination = this.data.target;
                }
                this.fleet.addAssignment(FleetAssignment.DELIVER_CREW, destination, 1000.0f, StringHelper.getFleetAssignmentString("returningTo", destination.getName()));
                this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, destination, daysToOrbit, StringHelper.getFleetAssignmentString("standingDown", null, "missionStrike"));
            } else if (this.data.target.getFaction() == this.data.fleet.getFaction()) {
                destination = this.data.target;
                LocationAPI loc = this.data.target.getContainingLocation();
                StarSystemAPI system = this.data.targetMarket.getStarSystem();
                if (system != null && system != this.fleet.getContainingLocation()) {
                    Vector2f dest = Misc.getPointAtRadius((Vector2f)system.getLocation(), (float)1500.0f);
                    SectorEntityToken token = loc.createToken(dest.x, dest.y);
                    this.fleet.addAssignment(FleetAssignment.DELIVER_CREW, token, 1000.0f, StringHelper.getFleetAssignmentString("travellingToStarSystem", system.getBaseName()));
                }
                destination = this.data.target;
                this.fleet.addAssignment(FleetAssignment.DEFEND_LOCATION, destination, 40.0f, StringHelper.getFleetAssignmentString("defending", this.data.target.getName()));
                this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, destination, daysToOrbit, StringHelper.getFleetAssignmentString("endingMission", destination.getName()));
            } else {
                this.fleet.addAssignment(FleetAssignment.DELIVER_CREW, destination, 1000.0f, StringHelper.getFleetAssignmentString("returningTo", destination.getName()));
                this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, destination, daysToOrbit, StringHelper.getFleetAssignmentString("endingMission", destination.getName()));
            }
            this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, destination, 1000.0f);
            log.info((Object)("Strike fleet standing down; critical damage? " + this.criticalDamage));
        }
    }
}

