/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.MiningHelperLegacy;
import exerelin.campaign.fleets.MiningFleetManager;
import exerelin.plugins.ExerelinModPlugin;
import exerelin.utilities.ExerelinUtilsCargo;
import exerelin.utilities.ExerelinUtilsFleet;
import exerelin.utilities.StringHelper;
import java.util.List;
import org.apache.log4j.Logger;
import org.histidine.industry.scripts.MiningHelper;
import org.lwjgl.util.vector.Vector2f;

public class MiningFleetAI
implements EveryFrameScript {
    public static Logger log = Global.getLogger(MiningFleetAI.class);
    public static final float UPDATE_INTERVAL = 0.25f;
    protected final MiningFleetManager.MiningFleetData data;
    protected float daysTotal = 0.0f;
    protected float miningDailyProgress = 0.0f;
    protected final CampaignFleetAPI fleet;
    protected boolean orderedReturn = false;
    protected boolean unloaded = false;
    protected boolean responseFleetRequested = false;
    float interval = 0.0f;

    public MiningFleetAI(CampaignFleetAPI fleet, MiningFleetManager.MiningFleetData data) {
        this.fleet = fleet;
        this.data = data;
        this.giveInitialAssignment();
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysTotal += days;
        if (this.daysTotal > 150.0f) {
            this.giveStandDownOrders();
            return;
        }
        this.interval += days;
        if (this.interval >= 0.25f) {
            this.interval -= 0.25f;
        } else {
            return;
        }
        FleetAssignmentDataAPI assignment = this.fleet.getAI().getCurrentAssignment();
        if (assignment != null) {
            CargoAPI cargo;
            float fp = this.fleet.getFleetPoints();
            if (fp < this.data.startingFleetPoints / 2.0f) {
                this.giveStandDownOrders();
            }
            if ((cargo = this.fleet.getCargo()).getSpaceUsed() / cargo.getMaxCapacity() > 0.9f) {
                this.giveStandDownOrders();
            }
            if (this.orderedReturn) {
                if (!this.unloaded && assignment.getAssignment() == FleetAssignment.ORBIT_PASSIVE && this.data.source.getContainingLocation() == this.data.fleet.getContainingLocation() && Misc.getDistance((Vector2f)this.data.source.getLocation(), (Vector2f)this.data.fleet.getLocation()) < 600.0f) {
                    List cargoStacks = cargo.getStacksCopy();
                    for (CargoStackAPI stack : cargoStacks) {
                        if (!stack.isCommodityStack() || stack.isSupplyStack()) continue;
                        ExerelinUtilsCargo.addCommodityStockpile(this.data.sourceMarket, stack.getCommodityId(), stack.getSize());
                        cargo.addCommodity(stack.getCommodityId(), -stack.getSize());
                    }
                    cargo.removeEmptyStacks();
                    this.unloaded = true;
                }
                return;
            }
            if (assignment.getAssignment() == FleetAssignment.ORBIT_PASSIVE || assignment.getAssignment() == FleetAssignment.INTERCEPT && this.data.target.getContainingLocation() == this.data.fleet.getContainingLocation() && Misc.getDistance((Vector2f)this.data.target.getLocation(), (Vector2f)this.data.fleet.getLocation()) < 600.0f) {
                this.fleet.getMemoryWithoutUpdate().set("$core_fleetBusy", (Object)true, 0.5f);
                this.miningDailyProgress += 0.25f;
                if (this.miningDailyProgress > 1.0f) {
                    this.miningDailyProgress -= 1.0f;
                    if (ExerelinModPlugin.HAVE_STELLAR_INDUSTRIALIST) {
                        if (MiningHelper.getFleetMiningStrength((CampaignFleetAPI)this.fleet) < this.data.miningStrength * 0.5f) {
                            this.giveStandDownOrders();
                        } else {
                            MiningHelper.getMiningResults((CampaignFleetAPI)this.fleet, (SectorEntityToken)this.data.target, (float)1.0f, (boolean)false);
                        }
                    } else if (MiningHelperLegacy.getFleetMiningStrength(this.fleet) < this.data.miningStrength * 0.5f) {
                        this.giveStandDownOrders();
                    } else {
                        MiningHelperLegacy.getMiningResults(this.fleet, this.data.target, 1.0f, false);
                    }
                }
            }
        } else {
            SectorEntityToken target = this.data.target;
            LocationAPI loc = target.getContainingLocation();
            String locName = " " + loc.getName();
            if (loc != this.fleet.getContainingLocation()) {
                LocationAPI hyper = Global.getSector().getHyperspace();
                Vector2f dest = Misc.getPointAtRadius((Vector2f)loc.getLocation(), (float)1500.0f);
                SectorEntityToken token = hyper.createToken(dest.x, dest.y);
                this.fleet.addAssignment(FleetAssignment.DELIVER_RESOURCES, token, 1000.0f, StringHelper.getFleetAssignmentString("travellingTo", locName));
                this.fleet.addAssignment(FleetAssignment.DELIVER_RESOURCES, target, 1000.0f, StringHelper.getFleetAssignmentString("travellingTo", target.getName()));
            } else {
                this.fleet.addAssignment(FleetAssignment.DELIVER_RESOURCES, target, 1000.0f, StringHelper.getFleetAssignmentString("travellingTo", target.getName()));
            }
            if (target instanceof AsteroidAPI) {
                this.fleet.addAssignment(FleetAssignment.INTERCEPT, target, 30.0f, StringHelper.getFleetAssignmentString("mining", target.getName()));
            } else {
                this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, target, 30.0f, StringHelper.getFleetAssignmentString("mining", target.getName()));
            }
        }
    }

    public boolean isDone() {
        return !this.fleet.isAlive();
    }

    public boolean runWhilePaused() {
        return false;
    }

    protected void giveInitialAssignment() {
        if (this.data.noWait) {
            return;
        }
        float daysToOrbit = ExerelinUtilsFleet.getDaysToOrbit(this.fleet);
        this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.source, daysToOrbit, StringHelper.getFleetAssignmentString("preparingFor", this.data.source.getName(), "missionMining"));
    }

    protected void giveStandDownOrders() {
        if (!this.orderedReturn) {
            this.orderedReturn = true;
            this.fleet.clearAssignments();
            SectorEntityToken destination = this.data.source;
            this.fleet.addAssignment(FleetAssignment.DELIVER_RESOURCES, destination, 1000.0f, StringHelper.getFleetAssignmentString("returningTo", destination.getName()));
            this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, destination, ExerelinUtilsFleet.getDaysToOrbit(this.fleet), StringHelper.getFleetAssignmentString("miningUnload", null));
            this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, destination, 1000.0f);
        }
    }
}

