/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.MiningHelperLegacy;
import exerelin.campaign.fleets.MiningFleetAI;
import exerelin.plugins.ExerelinModPlugin;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.ExerelinUtilsFleet;
import exerelin.utilities.StringHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.histidine.industry.scripts.MiningHelper;

public class MiningFleetManager
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static final String MANAGER_MAP_KEY = "exerelin_miningFleetManager";
    public static Logger log = Global.getLogger(MiningFleetManager.class);
    protected static final float POINT_INCREMENT_PER_DAY = 2.0f;
    protected static final float MARKET_STABILITY_DIVISOR = 5.0f;
    protected static final float POINTS_TO_SPAWN = 100.0f;
    protected static final float POINT_INCREMENT_PERIOD = 1.0f;
    protected static final float GAS_FLEET_CHANCE = 0.4f;
    protected final List<MiningFleetData> activeFleets = new LinkedList<MiningFleetData>();
    protected HashMap<String, Float> spawnCounter = new HashMap();
    protected float timer = 0.0f;
    protected float daysElapsed = 0.0f;
    private static MiningFleetManager miningFleetManager;

    public MiningFleetManager() {
        super(true);
    }

    protected boolean hasOreFacilities(MarketAPI market) {
        FactionAPI faction = market.getFaction();
        return market.hasCondition("ore_complex") || market.hasCondition("ore_refining_complex") || market.hasCondition("aiw_inorganic_populace");
    }

    protected boolean hasGasFacilities(MarketAPI market) {
        return market.hasCondition("volatiles_complex") || market.hasCondition("volatiles_depot") || market.hasCondition("cryosanctum") || market.hasCondition("antimatter_fuel_production") || market.hasCondition("light_industrial_complex");
    }

    protected boolean isOreMineable(SectorEntityToken entity) {
        if (entity instanceof AsteroidAPI) {
            return true;
        }
        if (!(entity instanceof PlanetAPI)) {
            return false;
        }
        if (ExerelinModPlugin.HAVE_STELLAR_INDUSTRIALIST) {
            float exhaustion = MiningHelper.getExhaustion((SectorEntityToken)entity);
            if (exhaustion > 0.7f) {
                return false;
            }
            MiningHelper.MiningReport report = MiningHelper.getMiningReport(null, (SectorEntityToken)entity, (float)(1.0f - exhaustion));
            if (report.totalOutput.containsKey("ore")) {
                return (double)((Float)report.totalOutput.get("ore")).floatValue() > 0.5;
            }
            if (report.totalOutput.containsKey("rare_ore")) {
                return (double)((Float)report.totalOutput.get("rare_ore")).floatValue() > 0.05;
            }
            return false;
        }
        float exhaustion = MiningHelperLegacy.getExhaustion(entity);
        if (exhaustion > 0.7f) {
            return false;
        }
        MiningHelperLegacy.MiningReport report = MiningHelperLegacy.getMiningReport(null, entity, 1.0f - exhaustion);
        if (report.totalOutput.containsKey("ore")) {
            return (double)report.totalOutput.get("ore").floatValue() > 0.5;
        }
        if (report.totalOutput.containsKey("rare_ore")) {
            return (double)report.totalOutput.get("rare_ore").floatValue() > 0.05;
        }
        return false;
    }

    protected boolean isGasMineable(SectorEntityToken entity) {
        if (!(entity instanceof PlanetAPI)) {
            return false;
        }
        if (ExerelinModPlugin.HAVE_STELLAR_INDUSTRIALIST) {
            float exhaustion = MiningHelper.getExhaustion((SectorEntityToken)entity);
            if (exhaustion > 0.7f) {
                return false;
            }
            MiningHelper.MiningReport report = MiningHelper.getMiningReport(null, (SectorEntityToken)entity, (float)(1.0f - exhaustion));
            if (report.totalOutput.containsKey("volatiles")) {
                return (double)((Float)report.totalOutput.get("volatiles")).floatValue() > 0.4;
            }
            return false;
        }
        float exhaustion = MiningHelperLegacy.getExhaustion(entity);
        if (exhaustion > 0.7f) {
            return false;
        }
        MiningHelperLegacy.MiningReport report = MiningHelperLegacy.getMiningReport(null, entity, 1.0f - exhaustion);
        if (report.totalOutput.containsKey("volatiles")) {
            return (double)report.totalOutput.get("volatiles").floatValue() > 0.4;
        }
        return false;
    }

    public void spawnMiningFleet(MarketAPI origin) {
        float machineryToTake;
        float machineryRequired;
        log.info((Object)("Trying mining fleet for market " + origin.getName()));
        SectorEntityToken target = null;
        LocationAPI loc = origin.getContainingLocation();
        if (loc == Global.getSector().getHyperspace()) {
            return;
        }
        FactionAPI faction = origin.getFaction();
        if (faction.getId().equals("templars")) {
            return;
        }
        int marketSize = origin.getSize();
        int maxFP = (int)Math.pow(marketSize, 1.5);
        float qf = origin.getShipQualityFactor();
        boolean isGasMiningFleet = false;
        boolean hasOreFacilities = this.hasOreFacilities(origin);
        boolean hasGasFacilities = this.hasGasFacilities(origin);
        if (hasOreFacilities && hasGasFacilities) {
            isGasMiningFleet = Math.random() < (double)0.4f;
        } else if (hasOreFacilities) {
            isGasMiningFleet = false;
        } else if (hasGasFacilities) {
            isGasMiningFleet = true;
        } else {
            return;
        }
        WeightedRandomPicker targetPicker = new WeightedRandomPicker();
        List planets = origin.getContainingLocation().getEntitiesWithTag("planet");
        if (!isGasMiningFleet) {
            planets.addAll(origin.getContainingLocation().getAsteroids());
        }
        for (SectorEntityToken planetToken : planets) {
            FactionAPI owner;
            OrbitAPI orbit;
            if (planetToken.getMarket() != null && !planetToken.getMarket().isPlanetConditionMarketOnly()) continue;
            if (isGasMiningFleet) {
                if (!this.isGasMineable(planetToken)) continue;
                targetPicker.add((Object)planetToken);
                continue;
            }
            if (!this.isOreMineable(planetToken) || (orbit = planetToken.getOrbit()) != null && orbit.getFocus() != null && (owner = orbit.getFocus().getFaction()) != null && owner.isHostileTo(faction)) continue;
            targetPicker.add((Object)planetToken);
        }
        if (targetPicker.isEmpty()) {
            return;
        }
        target = (SectorEntityToken)targetPicker.pick();
        if (target == null) {
            return;
        }
        String name = StringHelper.getString("exerelin_fleets", "miningFleetName");
        String factionId = origin.getFactionId();
        ExerelinFactionConfig factionConfig = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (factionConfig != null) {
            name = factionConfig.asteroidMiningFleetName;
        }
        if (maxFP < 10) {
            name = StringHelper.getString("exerelin_fleets", "miningFleetPrefixSmall") + " " + name;
        } else if (maxFP > 20) {
            name = StringHelper.getString("exerelin_fleets", "miningFleetPrefixLarge") + " " + name;
        }
        FleetParams params = new FleetParams(null, origin, factionId, null, "exerelinMiningFleet", (float)(maxFP / 4), (float)maxFP * 0.45f, 0.0f, 0.0f, 0.0f, 0.0f, (float)maxFP * 0.05f, -0.25f, -1.0f, 0.5f, -5);
        CampaignFleetAPI fleet = ExerelinUtilsFleet.customCreateFleet(faction, params);
        if (fleet == null) {
            return;
        }
        fleet.setName(name);
        fleet.setAIMode(true);
        fleet.getMemoryWithoutUpdate().set("$isTradeFleet", (Object)true);
        int minerFP = (int)((float)maxFP * 0.25f + 0.5f);
        while (minerFP > 0) {
            FleetMemberAPI miner = ExerelinUtilsFleet.addMiningShipToFleet(fleet);
            minerFP = (int)((float)minerFP - FleetFactoryV2.getPointsForVariant((String)miner.getVariant().getHullVariantId()));
        }
        float miningStrength = 0.0f;
        if (ExerelinModPlugin.HAVE_STELLAR_INDUSTRIALIST) {
            miningStrength = MiningHelper.getFleetMiningStrength((CampaignFleetAPI)fleet);
            machineryRequired = MiningHelper.getRequiredMachinery((float)miningStrength);
            machineryToTake = Math.min(machineryRequired * 1.25f, origin.getCommodityData("heavy_machinery").getStockpile());
            fleet.getCargo().addCommodity("heavy_machinery", machineryToTake);
            origin.getCommodityData("heavy_machinery").removeFromStockpile(machineryToTake);
        } else {
            miningStrength = MiningHelperLegacy.getFleetMiningStrength(fleet);
            machineryRequired = MiningHelperLegacy.getRequiredMachinery(miningStrength);
            machineryToTake = Math.min(machineryRequired * 1.25f, origin.getCommodityData("heavy_machinery").getStockpile());
            fleet.getCargo().addCommodity("heavy_machinery", machineryToTake);
            origin.getCommodityData("heavy_machinery").removeFromStockpile(machineryToTake);
        }
        SectorEntityToken entity = origin.getPrimaryEntity();
        entity.getContainingLocation().addEntity((SectorEntityToken)fleet);
        fleet.setLocation(entity.getLocation().x, entity.getLocation().y);
        MiningFleetData data = new MiningFleetData(fleet);
        data.startingFleetPoints = fleet.getFleetPoints();
        data.sourceMarket = origin;
        data.source = origin.getPrimaryEntity();
        data.target = target;
        data.miningStrength = miningStrength;
        this.activeFleets.add(data);
        MiningFleetAI ai = new MiningFleetAI(fleet, data);
        fleet.addScript((EveryFrameScript)ai);
        log.info((Object)("\tSpawned " + fleet.getNameWithFaction() + " of size " + maxFP));
    }

    public void updateMiningFleetPoints(float days) {
        if (Global.getSector() == null || Global.getSector().getEconomy() == null) {
            return;
        }
        List markets = Global.getSector().getEconomy().getMarketsCopy();
        for (MarketAPI market : markets) {
            float baseIncrement;
            if (ExerelinUtilsFaction.isPirateOrTemplarFaction(market.getFactionId())) continue;
            if (!this.spawnCounter.containsKey(market.getId())) {
                this.spawnCounter.put(market.getId(), Float.valueOf(0.0f));
            }
            float increment = baseIncrement = 0.5f + market.getStabilityValue() / 5.0f;
            if (market.hasCondition("spaceport")) {
                increment += baseIncrement * 0.25f;
            }
            if (market.hasCondition("orbital_station")) {
                increment += baseIncrement * 0.25f;
            }
            increment = increment * 2.0f * days;
            float newValue = this.spawnCounter.get(market.getId()).floatValue() + increment;
            if (newValue > 100.0f) {
                newValue -= 100.0f;
                this.spawnMiningFleet(market);
            }
            this.spawnCounter.put(market.getId(), Float.valueOf(newValue));
        }
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.timer += days;
        if (this.timer < 1.0f) {
            return;
        }
        this.timer -= 1.0f;
        LinkedList<MiningFleetData> remove = new LinkedList<MiningFleetData>();
        for (MiningFleetData data : this.activeFleets) {
            if (data.fleet.getContainingLocation() != null && data.fleet.getContainingLocation().getFleets().contains(data.fleet) && data.fleet.isAlive()) continue;
            remove.add(data);
        }
        this.activeFleets.removeAll(remove);
        this.updateMiningFleetPoints(1.0f);
        if (ExerelinModPlugin.HAVE_STELLAR_INDUSTRIALIST) {
            MiningHelper.renewResources((float)1.0f);
        } else {
            MiningHelperLegacy.renewResources(1.0f);
        }
    }

    public static MiningFleetManager create() {
        Map data = Global.getSector().getPersistentData();
        miningFleetManager = (MiningFleetManager)((Object)data.get(MANAGER_MAP_KEY));
        if (miningFleetManager != null) {
            return miningFleetManager;
        }
        miningFleetManager = new MiningFleetManager();
        data.put(MANAGER_MAP_KEY, miningFleetManager);
        return miningFleetManager;
    }

    public static MiningFleetManager getFleetManager() {
        return miningFleetManager;
    }

    public boolean isDone() {
        return false;
    }

    public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        super.reportFleetDespawned(fleet, reason, param);
        for (MiningFleetData data : this.activeFleets) {
            if (data.fleet != fleet) continue;
            this.activeFleets.remove(data);
            break;
        }
    }

    public boolean runWhilePaused() {
        return false;
    }

    public static class MiningFleetData {
        public CampaignFleetAPI fleet;
        public SectorEntityToken source;
        public SectorEntityToken target;
        public MarketAPI sourceMarket;
        public float startingFleetPoints = 0.0f;
        public float miningStrength = 0.0f;
        public boolean noWait = false;

        public MiningFleetData(CampaignFleetAPI fleet) {
            this.fleet = fleet;
        }
    }
}

