/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.LionsGuardFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolFleetManager;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.IntervalUtil;
import exerelin.campaign.fleets.ExerelinLionsGuardFleetManager;
import exerelin.campaign.fleets.ExerelinPatrolFleetManager;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class PatrolFleetManagerReplacer
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static Logger log = Global.getLogger(PatrolFleetManagerReplacer.class);
    protected final IntervalUtil timer = new IntervalUtil(0.5f, 1.5f);
    protected final Set<String> marketsWithAssignedPatrolScripts = new HashSet<String>();
    protected boolean firstFrame = true;

    public PatrolFleetManagerReplacer() {
        super(true);
    }

    public void advance(float amount) {
        SectorAPI sector = Global.getSector();
        if (sector.isPaused()) {
            return;
        }
        if (this.firstFrame) {
            this.firstFrame = false;
        }
        float days = sector.getClock().convertToDays(amount);
        this.timer.advance(days);
        if (this.timer.intervalElapsed()) {
            this.assignPatrolSpawningScripts();
        }
    }

    public void assignPatrolSpawningScripts() {
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            Object script;
            ExerelinFactionConfig factionConfig;
            String id = market.getId();
            if (SharedData.getData().getMarketsWithoutPatrolSpawn().contains(id) || market.getFaction().getCustom().optBoolean("noPatrols") && ((factionConfig = ExerelinConfig.getExerelinFactionConfig(market.getFactionId())) == null || !factionConfig.spawnPatrols) || this.marketsWithAssignedPatrolScripts.contains(id)) continue;
            this.marketsWithAssignedPatrolScripts.add(id);
            SectorEntityToken entity = market.getPrimaryEntity();
            if (id.equals("sindria")) {
                ExerelinUtils.removeScriptAndListener(entity, LionsGuardFleetManager.class, ExerelinLionsGuardFleetManager.class);
                script = new ExerelinLionsGuardFleetManager(market);
                entity.addScript((EveryFrameScript)script);
            } else if (id.equals("tem_ascalon")) continue;
            script = new ExerelinPatrolFleetManager(market);
            ExerelinUtils.removeScriptAndListener(entity, PatrolFleetManager.class, ExerelinPatrolFleetManager.class);
            entity.addScript((EveryFrameScript)script);
            log.info((Object)("Added patrol fleet spawning script to market [" + market.getName() + "]"));
        }
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return true;
    }
}

