/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.InvasionRound;
import exerelin.campaign.fleets.InvasionFleetAI;
import exerelin.campaign.fleets.InvasionFleetManager;
import exerelin.campaign.fleets.ResponseFleetManager;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.ExerelinUtilsReputation;
import exerelin.utilities.StringHelper;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

public class RespawnFleetAI
extends InvasionFleetAI {
    public static Logger log = Global.getLogger(RespawnFleetAI.class);
    protected boolean captureSuccessful = false;
    protected boolean forceHostile = false;

    public RespawnFleetAI(CampaignFleetAPI fleet, InvasionFleetManager.InvasionFleetData data) {
        super(fleet, data);
    }

    @Override
    protected void giveInitialAssignment() {
    }

    @Override
    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysTotal += days;
        if (this.daysTotal > 150.0f) {
            this.giveStandDownOrders();
            return;
        }
        this.interval += days;
        if (this.interval >= 0.25f) {
            this.interval -= 0.25f;
        } else {
            return;
        }
        FleetAssignmentDataAPI assignment = this.fleet.getAI().getCurrentAssignment();
        if (assignment != null) {
            int marines;
            float fp;
            if (this.data.targetMarket.getFaction() == this.fleet.getFaction()) {
                this.captureSuccessful = true;
                this.giveStandDownOrders();
            }
            if ((fp = (float)this.fleet.getFleetPoints()) < this.data.startingFleetPoints / 2.0f) {
                this.giveStandDownOrders();
            }
            if ((float)(marines = this.fleet.getCargo().getMarines()) < (float)this.data.marineCount * 0.4f) {
                this.giveStandDownOrders();
            }
            if (this.orderedReturn) {
                return;
            }
            if (assignment.getAssignment() == FleetAssignment.ORBIT_PASSIVE && this.data.target.getContainingLocation() == this.data.fleet.getContainingLocation() && Misc.getDistance((Vector2f)this.data.target.getLocation(), (Vector2f)this.data.fleet.getLocation()) < 600.0f) {
                this.fleet.getMemoryWithoutUpdate().set("$core_fleetBusy", (Object)true, 2.5f);
                FactionAPI fleetFaction = this.fleet.getFaction();
                FactionAPI targetFaction = this.data.targetMarket.getFaction();
                if (!fleetFaction.isHostileTo(targetFaction) && !this.forceHostile) {
                    DiplomacyManager.adjustRelations(fleetFaction, targetFaction, 0.0f, RepLevel.HOSTILE, null, null);
                    AllianceManager.doAlliancePeaceStateChange(fleetFaction.getId(), targetFaction.getId(), true);
                    this.forceHostile = true;
                }
                if (!this.responseFleetRequested) {
                    ResponseFleetManager.requestResponseFleet(this.data.targetMarket, (SectorEntityToken)this.data.fleet);
                    this.broadcastHostile();
                }
                this.data.targetMarket.getMemoryWithoutUpdate().set("$beingInvaded", (Object)true, 2.5f);
            } else if (assignment.getAssignment() == FleetAssignment.HOLD && this.data.target.getContainingLocation() == this.data.fleet.getContainingLocation() && Misc.getDistance((Vector2f)this.data.target.getLocation(), (Vector2f)this.data.fleet.getLocation()) < 600.0f) {
                if (!this.data.target.getFaction().isHostileTo(this.fleet.getFaction())) {
                    this.giveStandDownOrders();
                } else {
                    InvasionRound.InvasionRoundResult result = InvasionRound.AttackMarket(this.fleet, this.data.target, false);
                    if (result.getSuccess()) {
                        this.data.targetMarket.getMemoryWithoutUpdate().unset("$beingInvaded");
                    }
                }
            }
        } else {
            MarketAPI market = this.data.targetMarket;
            StarSystemAPI system = market.getStarSystem();
            String locName = market.getPrimaryEntity().getContainingLocation().getName();
            String marketName = market.getName();
            if (system != null) {
                locName = " " + system.getName();
            }
            if (system != null && system != this.fleet.getContainingLocation()) {
                LocationAPI hyper = Global.getSector().getHyperspace();
                Vector2f dest = Misc.getPointAtRadius((Vector2f)system.getLocation(), (float)1500.0f);
                SectorEntityToken token = hyper.createToken(dest.x, dest.y);
                this.fleet.addAssignment(FleetAssignment.DELIVER_MARINES, token, 1000.0f, StringHelper.getFleetAssignmentString("travellingTo", locName));
                this.fleet.addAssignment(FleetAssignment.DELIVER_MARINES, market.getPrimaryEntity(), 1000.0f, StringHelper.getFleetAssignmentString("travellingTo", marketName));
            } else {
                this.fleet.addAssignment(FleetAssignment.DELIVER_MARINES, market.getPrimaryEntity(), 1000.0f, StringHelper.getFleetAssignmentString("travellingTo", marketName));
            }
            this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, market.getPrimaryEntity(), 2.5f, StringHelper.getFleetAssignmentString("beginningInvasion", marketName));
            this.fleet.addAssignment(FleetAssignment.HOLD, market.getPrimaryEntity(), 2.0f, StringHelper.getFleetAssignmentString("invading", marketName));
        }
    }

    @Override
    protected void giveStandDownOrders() {
        if (!this.orderedReturn) {
            FactionAPI faction = this.fleet.getFaction();
            String targetFactionId = this.data.targetMarket.getFactionId();
            if (!this.captureSuccessful && faction.isHostileTo(targetFactionId)) {
                boolean reset = this.forceHostile;
                String factionId = faction.getId();
                if (ExerelinUtilsFaction.isFactionHostileToAll(factionId)) {
                    reset = false;
                } else if (ExerelinUtilsFaction.isFactionHostileToAll(targetFactionId)) {
                    reset = false;
                }
                if (reset) {
                    faction.setRelationship(targetFactionId, 0.0f);
                    AllianceManager.doAlliancePeaceStateChange(faction.getId(), targetFactionId, false);
                    ExerelinUtilsReputation.syncPlayerRelationshipsToFaction();
                }
            }
        }
        super.giveStandDownOrders();
    }
}

