/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import exerelin.campaign.fleets.ResponseFleetManager;
import exerelin.utilities.ExerelinUtilsFleet;
import exerelin.utilities.StringHelper;
import org.apache.log4j.Logger;

public class ResponseFleetAI
implements EveryFrameScript {
    public static final float RESERVE_RESTORE_EFFICIENCY = 0.75f;
    public static Logger log = Global.getLogger(ResponseFleetAI.class);
    protected final ResponseFleetManager.ResponseFleetData data;
    protected float daysTotal = 0.0f;
    protected final CampaignFleetAPI fleet;
    protected boolean orderedReturn = false;
    float interval = 0.0f;

    public ResponseFleetAI(CampaignFleetAPI fleet, ResponseFleetManager.ResponseFleetData data) {
        this.fleet = fleet;
        this.data = data;
        this.giveInitialAssignment();
    }

    public void advance(float amount) {
        CampaignFleetAPI targetFleet;
        float days = Global.getSector().getClock().convertToDays(amount);
        this.daysTotal += days;
        if (this.daysTotal > 60.0f) {
            this.giveStandDownOrders();
            return;
        }
        this.interval += days;
        if (this.interval >= 0.25f) {
            this.interval -= 0.25f;
        } else {
            return;
        }
        FleetAssignmentDataAPI assignment = this.fleet.getAI().getCurrentAssignment();
        float fp = this.fleet.getFleetPoints();
        boolean tooWeak = true;
        SectorEntityToken target = this.data.target;
        if (target != null && target.isAlive() && (float)(targetFleet = (CampaignFleetAPI)this.data.target).getFleetPoints() < fp * 2.0f) {
            tooWeak = false;
        }
        if (fp < this.data.startingFleetPoints / 2.0f && tooWeak) {
            this.giveStandDownOrders();
        } else {
            MarketAPI market = this.data.sourceMarket;
            StarSystemAPI system = market.getStarSystem();
            if (system != null) {
                if (system != this.fleet.getContainingLocation()) {
                    this.fleet.addAssignment(FleetAssignment.DELIVER_SUPPLIES, market.getPrimaryEntity(), 1000.0f, StringHelper.getFleetAssignmentString("travellingToStarSystem", system.getBaseName()));
                }
                this.fleet.addAssignment(FleetAssignment.DEFEND_LOCATION, market.getPrimaryEntity(), 1000.0f, StringHelper.getFleetAssignmentString("defending", market.getName()));
            }
        }
    }

    public boolean isDone() {
        return !this.fleet.isAlive();
    }

    public boolean runWhilePaused() {
        return false;
    }

    protected void giveInitialAssignment() {
        String targetName = this.data.target.getName();
        if (this.data.target == Global.getSector().getPlayerFleet()) {
            targetName = StringHelper.getString("yourFleet");
        }
        this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.data.source, 0.1f, StringHelper.getFleetAssignmentString("scramblingFrom", this.data.sourceMarket.getName()));
        this.fleet.addAssignment(FleetAssignment.INTERCEPT, this.data.target, 3.0f, StringHelper.getFleetAssignmentString("intercepting", targetName));
    }

    protected void giveStandDownOrders() {
        if (!this.orderedReturn) {
            this.orderedReturn = true;
            this.fleet.clearAssignments();
            Script despawnScript = new Script(){

                public void run() {
                    float points = (float)ResponseFleetAI.this.fleet.getFleetPoints() * 0.75f;
                    log.info((Object)("Response fleet despawning at base " + ResponseFleetAI.this.data.source.getName() + "; can restore " + points + " points"));
                    ResponseFleetManager.modifyReserveSize(ResponseFleetAI.this.data.sourceMarket, points);
                }
            };
            SectorEntityToken destination = this.data.source;
            this.fleet.addAssignment(FleetAssignment.DELIVER_CREW, destination, 1000.0f, StringHelper.getFleetAssignmentString("returningTo", destination.getName()));
            this.fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, destination, ExerelinUtilsFleet.getDaysToOrbit(this.fleet), StringHelper.getFleetAssignmentString("standingDown", null, "missionPatrol"), despawnScript);
            this.fleet.addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, destination, 1000.0f);
        }
    }
}

