/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.fleets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseCampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.util.IntervalUtil;
import exerelin.campaign.fleets.ResponseFleetAI;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtilsFleet;
import exerelin.utilities.StringHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResponseFleetManager
extends BaseCampaignEventListener
implements EveryFrameScript {
    public static final String MANAGER_MAP_KEY = "exerelin_responseFleetManager";
    private static final float RESERVE_INCREMENT_PER_DAY = 0.08f;
    private static final float RESERVE_MARKET_STABILITY_DIVISOR = 5.0f;
    private static final float INITIAL_RESERVE_SIZE_MULT = 0.75f;
    private static final float MIN_FP_TO_SPAWN = 5.0f;
    protected static final float REVENGE_FLEET_BASE_SIZE = 75.0f;
    protected static final float REVENGE_GROWTH_MULT = 0.25f;
    protected Map<String, Float> revengeStrength = new HashMap<String, Float>();
    protected Map<String, Float> reserves = new HashMap<String, Float>();
    public static Logger log = Global.getLogger(ResponseFleetManager.class);
    private final List<ResponseFleetData> activeFleets = new LinkedList<ResponseFleetData>();
    private final IntervalUtil tracker;
    private static ResponseFleetManager responseFleetManager;
    float lastReserveUpdateAge = 0.0f;

    public ResponseFleetManager() {
        super(true);
        float interval = Global.getSettings().getFloat("averagePatrolSpawnInterval");
        this.tracker = new IntervalUtil(interval * 0.75f, interval * 1.25f);
        this.reserves = new HashMap<String, Float>();
        List markets = Global.getSector().getEconomy().getMarketsCopy();
        for (MarketAPI market : markets) {
            this.reserves.put(market.getId(), Float.valueOf(ResponseFleetManager.getMaxReserveSize(market, false) * 0.75f));
        }
    }

    public void spawnResponseFleet(MarketAPI origin, SectorEntityToken target) {
        String factionId;
        float reserveSize = ResponseFleetManager.getReserveSize(origin);
        int maxFP = (int)reserveSize;
        if ((float)maxFP < 5.0f) {
            log.info((Object)(origin.getName() + " has insufficient FP for response fleet: " + maxFP));
            return;
        }
        int enemyFP = ((CampaignFleetAPI)target).getFleetPoints();
        if (enemyFP > maxFP * 8) {
            // empty if block
        }
        float qf = origin.getShipQualityFactor();
        String fleetFactionId = factionId = origin.getFactionId();
        ExerelinFactionConfig factionConfig = ExerelinConfig.getExerelinFactionConfig(factionId);
        ExerelinFactionConfig fleetFactionConfig = null;
        if (factionConfig.factionIdForHqResponse != null) {
            fleetFactionId = factionConfig.factionIdForHqResponse;
            fleetFactionConfig = ExerelinConfig.getExerelinFactionConfig(fleetFactionId);
        }
        String name = "";
        name = fleetFactionConfig != null ? fleetFactionConfig.responseFleetName : factionConfig.responseFleetName;
        if (maxFP <= 18) {
            name = StringHelper.getString("exerelin_fleets", "responseFleetPrefixSmall") + " " + name;
        } else if (maxFP >= 54) {
            name = StringHelper.getString("exerelin_fleets", "responseFleetPrefixLarge") + " " + name;
        }
        FleetParams fleetParams = new FleetParams(null, origin, fleetFactionId, null, "exerelinResponseFleet", (float)maxFP, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.15f, -1.0f, 1.25f, 1);
        CampaignFleetAPI fleet = ExerelinUtilsFleet.customCreateFleet(Global.getSector().getFaction(fleetFactionId), fleetParams);
        if (fleet == null) {
            return;
        }
        fleet.setFaction(factionId, true);
        fleet.setName(name);
        fleet.setAIMode(true);
        fleet.getMemoryWithoutUpdate().set("$isPatrol", (Object)true);
        SectorEntityToken entity = origin.getPrimaryEntity();
        entity.getContainingLocation().addEntity((SectorEntityToken)fleet);
        fleet.setLocation(entity.getLocation().x, entity.getLocation().y);
        ResponseFleetData data = new ResponseFleetData(fleet);
        data.startingFleetPoints = fleet.getFleetPoints();
        data.sourceMarket = origin;
        data.source = origin.getPrimaryEntity();
        data.target = target;
        this.activeFleets.add(data);
        fleet.getMemoryWithoutUpdate().set("$cfai_makeAggressive", (Object)true);
        ResponseFleetAI ai = new ResponseFleetAI(fleet, data);
        fleet.addScript((EveryFrameScript)ai);
        log.info((Object)("\tSpawned " + fleet.getNameWithFaction() + " of size " + maxFP));
        this.reserves.put(origin.getId(), Float.valueOf(0.0f));
        if (target == Global.getSector().getPlayerFleet()) {
            data.fleet.getMemoryWithoutUpdate().set("$sawPlayerTransponderOn", (Object)true, 5.0f);
        }
    }

    public static float getMaxReserveSize(MarketAPI market, boolean raw) {
        ExerelinFactionConfig factionConfig;
        float baseSize;
        int marketSize = market.getSize();
        if (market.getId().equals("exipirated_avesta")) {
            marketSize += 2;
        }
        float size = baseSize = (float)(marketSize * 5 + 8);
        if (raw) {
            return size;
        }
        if (market.hasCondition("military_base")) {
            size = (float)((double)size + (double)baseSize * 0.1);
        }
        if (market.hasCondition("orbital_station")) {
            size = (float)((double)size + (double)baseSize * 0.05);
        }
        if (market.hasCondition("spaceport")) {
            size = (float)((double)size + (double)baseSize * 0.05);
        }
        if (market.hasCondition("regional_capital")) {
            size = (float)((double)size + (double)baseSize * 0.1);
        }
        if (market.hasCondition("headquarters")) {
            size = (float)((double)size + (double)baseSize * 0.2);
        }
        if ((factionConfig = ExerelinConfig.getExerelinFactionConfig(market.getFactionId())) != null) {
            size += baseSize * factionConfig.responseFleetSizeMod;
        }
        return size += (float)Global.getSector().getPlayerPerson().getStats().getLevel() * ExerelinConfig.fleetBonusFpPerPlayerLevel;
    }

    public void updateReserves(float days) {
        if (Global.getSector() == null || Global.getSector().getEconomy() == null) {
            return;
        }
        List markets = Global.getSector().getEconomy().getMarketsCopy();
        for (MarketAPI market : markets) {
            ExerelinFactionConfig factionConfig;
            float baseIncrement;
            if (!this.reserves.containsKey(market.getId())) {
                this.reserves.put(market.getId(), Float.valueOf(ResponseFleetManager.getMaxReserveSize(market, false) * 0.75f));
            }
            int marketSize = market.getSize();
            if (market.getId().equals("exipirated_avesta")) {
                ++marketSize;
            }
            float increment = baseIncrement = (float)marketSize * (0.5f + market.getStabilityValue() / 5.0f);
            if (market.hasCondition("headquarters")) {
                increment += baseIncrement * 0.25f;
            }
            if ((factionConfig = ExerelinConfig.getExerelinFactionConfig(market.getFactionId())) != null) {
                increment += baseIncrement * factionConfig.responseFleetSizeMod;
            }
            increment = increment * 0.08f * days;
            float newValue = Math.min(ResponseFleetManager.getReserveSize(market) + increment, ResponseFleetManager.getMaxReserveSize(market, false));
            this.reserves.put(market.getId(), Float.valueOf(newValue));
        }
    }

    public static void requestResponseFleet(MarketAPI market, SectorEntityToken attacker) {
        if (responseFleetManager == null) {
            return;
        }
        responseFleetManager.spawnResponseFleet(market, attacker);
    }

    public static float modifyReserveSize(MarketAPI market, float delta) {
        if (responseFleetManager == null) {
            return 0.0f;
        }
        String marketId = market.getId();
        if (!ResponseFleetManager.responseFleetManager.reserves.containsKey(marketId)) {
            return 0.0f;
        }
        float current = ResponseFleetManager.getReserveSize(market);
        float newValue = current + delta;
        float max = ResponseFleetManager.getMaxReserveSize(market, false);
        if (newValue < 0.0f) {
            newValue = 0.0f;
        } else if (newValue > max) {
            newValue = max;
        }
        ResponseFleetManager.responseFleetManager.reserves.put(marketId, Float.valueOf(newValue));
        return newValue - current;
    }

    public static float getReserveSize(MarketAPI market) {
        if (responseFleetManager == null) {
            return -1.0f;
        }
        if (market == null) {
            return -1.0f;
        }
        Map<String, Float> reserves = ResponseFleetManager.responseFleetManager.reserves;
        String marketId = market.getId();
        if (!reserves.containsKey(marketId)) {
            if (!market.isInEconomy()) {
                return -1.0f;
            }
            reserves.put(marketId, Float.valueOf(ResponseFleetManager.getMaxReserveSize(market, false) * 0.75f));
        }
        return reserves.get(marketId).floatValue();
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.lastReserveUpdateAge += days;
        if (this.lastReserveUpdateAge >= 1.0f) {
            this.lastReserveUpdateAge -= 1.0f;
            this.updateReserves(1.0f);
        }
        this.tracker.advance(days);
        if (this.tracker.intervalElapsed()) {
            return;
        }
        LinkedList<ResponseFleetData> remove = new LinkedList<ResponseFleetData>();
        for (ResponseFleetData data : this.activeFleets) {
            if (data.fleet.getContainingLocation() != null && data.fleet.getContainingLocation().getFleets().contains(data.fleet) && data.fleet.isAlive()) continue;
            remove.add(data);
        }
        this.activeFleets.removeAll(remove);
    }

    public boolean isDone() {
        return false;
    }

    public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        super.reportFleetDespawned(fleet, reason, param);
        for (ResponseFleetData data : this.activeFleets) {
            if (data.fleet != fleet) continue;
            this.activeFleets.remove(data);
            break;
        }
    }

    public boolean runWhilePaused() {
        return false;
    }

    public static ResponseFleetManager create() {
        Map data = Global.getSector().getPersistentData();
        responseFleetManager = (ResponseFleetManager)((Object)data.get(MANAGER_MAP_KEY));
        if (responseFleetManager != null) {
            return responseFleetManager;
        }
        responseFleetManager = new ResponseFleetManager();
        data.put(MANAGER_MAP_KEY, responseFleetManager);
        return responseFleetManager;
    }

    public static class ResponseFleetData {
        public CampaignFleetAPI fleet;
        public SectorEntityToken source;
        public SectorEntityToken target;
        public MarketAPI sourceMarket;
        public float startingFleetPoints = 0.0f;

        public ResponseFleetData(CampaignFleetAPI fleet) {
            this.fleet = fleet;
        }
    }
}

