/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignMissionPlugin;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventManagerAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.missions.BaseCampaignMission;
import exerelin.utilities.StringHelper;
import java.util.UUID;

public class ConquestMission
extends BaseCampaignMission {
    public static final float MIN_DURATION_REMAINING_TO_OFFER = 30.0f;
    public static final float MIN_BONUS_DUR = 5.0f;
    protected MarketAPI target;
    protected FactionAPI issuer;
    protected float baseDuration = 30.0f;
    protected float bonusDuration = 30.0f;
    protected float baseReward = 0.0f;
    protected float bonusReward = 0.0f;

    public ConquestMission(MarketAPI target, FactionAPI issuer, float baseDuration, float bonusDuration, float baseReward, float bonusReward) {
        this.target = target;
        this.issuer = issuer;
        this.baseDuration = baseDuration;
        this.bonusDuration = bonusDuration;
        this.baseReward = baseReward;
        this.bonusReward = bonusReward;
        CampaignEventManagerAPI eventManager = Global.getSector().getEventManager();
        CampaignEventTarget eventTarget = new CampaignEventTarget(target);
        eventTarget.setExtra((Object)(UUID.randomUUID().toString() + issuer.getId()));
        this.event = eventManager.primeEvent(eventTarget, "exerelin_conquest_mission", (Object)this);
    }

    public MarketAPI getTarget() {
        return this.target;
    }

    public FactionAPI getIssuer() {
        return this.issuer;
    }

    public void advance(float amount) {
        if (!this.target.getFaction().isHostileTo(this.issuer)) {
            Global.getSector().getMissionBoard().removeMission((CampaignMissionPlugin)this, true);
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.baseDuration -= days;
        this.bonusDuration -= days;
        if (this.baseDuration < 30.0f) {
            Global.getSector().getMissionBoard().removeMission((CampaignMissionPlugin)this, true);
        }
        if (this.bonusDuration <= 5.0f) {
            this.bonusDuration = 0.0f;
        }
    }

    public void playerAccept(SectorEntityToken entity) {
        super.playerAccept(entity);
        CampaignEventManagerAPI eventManager = Global.getSector().getEventManager();
        eventManager.startEvent(this.event);
    }

    public float getBaseDuration() {
        return this.baseDuration;
    }

    public float getBonusDuration() {
        return this.bonusDuration;
    }

    public float getBaseReward() {
        return this.baseReward;
    }

    public float getBonusReward() {
        return this.bonusReward;
    }

    public boolean hasBonus(float eventElapsed) {
        return this.bonusDuration - eventElapsed > 0.0f;
    }

    public CoreReputationPlugin.MissionCompletionRep getRepChange(boolean hasBonus) {
        float rep = (float)this.target.getSize() * 0.01f;
        if (hasBonus) {
            rep *= 1.5f;
        }
        return new CoreReputationPlugin.MissionCompletionRep(rep, RepLevel.COOPERATIVE, -0.05f, RepLevel.INHOSPITABLE);
    }

    public String getName() {
        return StringHelper.getString("exerelin_missions", "conquestMission") + " - " + this.target.getName();
    }

    public String getFactionId() {
        return this.issuer.getId();
    }

    public CampaignEventPlugin getPrimedEvent() {
        return this.event;
    }

    public String getPostingStage() {
        if (this.hasBonus(0.0f)) {
            return "posting_bonus";
        }
        return super.getPostingStage();
    }
}

