/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.missions;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignMissionPlugin;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.MissionBoardAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.SectorManager;
import exerelin.campaign.missions.ConquestMission;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinUtilsFaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;

public class ConquestMissionCreator
implements EveryFrameScript {
    public static final int NUM_MISSIONS_PER_WAR = 2;
    public static final float REWARD_MULT = 1000.0f;
    public static final float DURATION_MULT = 15.0f;
    protected MissionBoardAPI board;
    protected IntervalUtil tracker = new IntervalUtil(5.0f, 7.0f);
    protected IntervalUtil trackerShort = new IntervalUtil(0.45f, 0.55f);
    public static Logger log = Global.getLogger(ConquestMissionCreator.class);

    public ConquestMissionCreator() {
        this.board = Global.getSector().getMissionBoard();
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    protected List<String> getFactionsAtWar() {
        ArrayList<String> atWar = new ArrayList<String>();
        ArrayList<String> liveFactions = SectorManager.getLiveFactionIdsCopy();
        for (String factionId : liveFactions) {
            List<String> enemies;
            if (!ExerelinConfig.allowPirateInvasions && ExerelinUtilsFaction.isPirateFaction(factionId) || (enemies = DiplomacyManager.getFactionsAtWarWithFaction(factionId, ExerelinConfig.allowPirateInvasions, true, false)).isEmpty()) continue;
            atWar.add(factionId);
        }
        return atWar;
    }

    protected boolean doesFactionTargetPairAlreadyExist(String factionId, MarketAPI target) {
        List existingMissions = this.board.getMissionsCopy();
        for (MissionBoardAPI.MissionAvailabilityAPI existing : existingMissions) {
            ConquestMission cMission;
            CampaignMissionPlugin mission = existing.getMission();
            if (mission.getClass() != ConquestMission.class || !(cMission = (ConquestMission)mission).getFactionId().equals(factionId) || cMission.getTarget() != target) continue;
            return true;
        }
        return false;
    }

    protected void createMission(List<String> factions) {
        WeightedRandomPicker factionPicker = new WeightedRandomPicker();
        WeightedRandomPicker targetPicker = new WeightedRandomPicker();
        HashMap<String, Object> enemiesByFaction = new HashMap<String, Object>();
        for (String factionId : factions) {
            if (factionId.equals("player_npc")) continue;
            List<String> enemies = DiplomacyManager.getFactionsAtWarWithFaction(factionId, ExerelinConfig.allowPirateInvasions, true, false);
            enemiesByFaction.put(factionId, enemies);
            factionPicker.add((Object)factionId, (float)enemies.size());
        }
        String factionId = (String)factionPicker.pick();
        if (factionId == null) {
            return;
        }
        List enemies = (List)enemiesByFaction.get(factionId);
        for (String enemyId : enemies) {
            if (enemyId.equals("player_npc")) continue;
            List<MarketAPI> markets = ExerelinUtilsFaction.getFactionMarkets(enemyId, true);
            for (MarketAPI market : markets) {
                if (this.doesFactionTargetPairAlreadyExist(factionId, market)) continue;
                targetPicker.add((Object)market);
            }
        }
        MarketAPI target = (MarketAPI)targetPicker.pick();
        if (target == null) {
            return;
        }
        FactionAPI faction = Global.getSector().getFaction(factionId);
        float duration = target.getSize();
        float bonusDuration = MathUtils.getRandomNumberInRange((int)-1, (int)3);
        duration *= 15.0f;
        bonusDuration *= 15.0f;
        float reward = (float)Math.pow(3.0, target.getSize());
        reward *= MathUtils.getRandomNumberInRange((float)0.75f, (float)1.25f) * ExerelinConfig.conquestMissionRewardMult;
        if (target.hasCondition("military_base")) {
            reward *= 1.25f;
        }
        if (target.hasCondition("spaceport")) {
            reward *= 1.1f;
        }
        if (target.hasCondition("orbital_station")) {
            reward *= 1.1f;
        }
        if (target.hasCondition("regional_capital")) {
            reward *= 1.1f;
        }
        if (target.hasCondition("headquarters")) {
            reward *= 1.2f;
        }
        if (target.getFactionId().equals("templars")) {
            reward *= 2.0f;
        }
        float bonusReward = reward * MathUtils.getRandomNumberInRange((float)0.5f, (float)1.0f);
        reward = (float)((int)reward) * 1000.0f;
        bonusReward = (float)((int)bonusReward) * 1000.0f;
        ConquestMission mission = new ConquestMission(target, faction, duration, bonusDuration, reward, bonusReward);
        log.info((Object)("Creating conquest mission: " + factionId + "," + target.getName()));
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!market.getFaction().isHostileTo(target.getFactionId()) || market.getFaction().isAtBest(faction, RepLevel.INHOSPITABLE) || !market.hasCondition("military_base") && !market.hasCondition("regional_capital") && !market.hasCondition("headquarters")) continue;
            this.board.makeAvailableAt((CampaignMissionPlugin)mission, market);
        }
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.tracker.advance(days);
        if (this.tracker.intervalElapsed()) {
            List<String> factionsAtWar = this.getFactionsAtWar();
            int maxConcurrent = factionsAtWar.size() * 2;
            int num = this.board.getNumMissions(ConquestMission.class);
            if (num < maxConcurrent) {
                this.createMission(factionsAtWar);
            }
        }
        if (this.trackerShort == null) {
            this.trackerShort = new IntervalUtil(0.45f, 0.55f);
        }
        this.trackerShort.advance(days);
        if (this.trackerShort.intervalElapsed()) {
            ArrayList<ConquestMission> toRemove = new ArrayList<ConquestMission>();
            List missions = this.board.getMissionsCopy();
            for (MissionBoardAPI.MissionAvailabilityAPI mission : missions) {
                if (!(mission.getMission() instanceof ConquestMission)) continue;
                ConquestMission cm = (ConquestMission)mission.getMission();
                FactionAPI targetFaction = cm.getTarget().getFaction();
                if (!targetFaction.isHostileTo(cm.issuer)) {
                    toRemove.add(cm);
                    continue;
                }
                Set tokens = mission.getAvailableAt();
                ArrayList<SectorEntityToken> toDelist = new ArrayList<SectorEntityToken>();
                for (SectorEntityToken token : tokens) {
                    if (token == null || token.getFaction() == null || token.getFaction().isHostileTo(targetFaction) && !token.getFaction().isAtBest(cm.issuer, RepLevel.INHOSPITABLE)) continue;
                    toDelist.add(token);
                }
                for (SectorEntityToken token : toDelist) {
                    this.board.makeUnavailableAt((CampaignMissionPlugin)cm, token);
                }
            }
            for (ConquestMission cm : toRemove) {
                this.board.removeMission((CampaignMissionPlugin)cm, true);
            }
        }
    }
}

