/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.missions.ConquestMission;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;

public class ConquestMissionEvent
extends BaseEventPlugin {
    protected static final String STRING_HELPER_CAT = "exerelin_missions";
    protected ConquestMission mission;
    protected float elapsedDays = 0.0f;
    protected String daysLeftStr = "";
    protected String bonusDaysLeftStr = "";
    protected boolean ended = false;

    public void setParam(Object param) {
        this.mission = (ConquestMission)((Object)param);
    }

    public void startEvent() {
        super.startEvent();
        String stageId = "accept";
        if (this.mission.hasBonus(this.elapsedDays)) {
            stageId = "accept_bonus";
        }
        Global.getSector().reportEventStage((CampaignEventPlugin)this, stageId, this.mission.target.getPrimaryEntity(), MessagePriority.DELIVER_IMMEDIATELY);
        Misc.makeImportant((SectorEntityToken)this.entity, (String)"nex_conquest", (float)this.mission.getBaseDuration());
    }

    protected SectorEntityToken findMessageSender() {
        WeightedRandomPicker military = new WeightedRandomPicker();
        WeightedRandomPicker nonMilitary = new WeightedRandomPicker();
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (market.getFaction() != this.faction || market.getPrimaryEntity() == null) continue;
            float dist = Misc.getDistanceToPlayerLY((SectorEntityToken)market.getPrimaryEntity());
            float weight = Math.max(1.0f, 10.0f - dist);
            if (market.hasCondition("headquarters") || market.hasCondition("regional_capital") || market.hasCondition("military_base")) {
                military.add((Object)market, weight);
                continue;
            }
            nonMilitary.add((Object)market, weight);
        }
        MarketAPI pick = (MarketAPI)military.pick();
        if (pick == null) {
            pick = (MarketAPI)nonMilitary.pick();
        }
        if (pick != null) {
            return pick.getPrimaryEntity();
        }
        return this.mission.target.getPrimaryEntity();
    }

    public void advance(float amount) {
        String targetFactionId = this.mission.getTarget().getFactionId();
        if (targetFactionId.equals("player_npc") || targetFactionId.equals(PlayerFactionStore.getPlayerFactionId())) {
            String stageId = "success";
            if (this.mission.hasBonus(this.elapsedDays)) {
                stageId = "success_bonus";
            }
            Global.getSector().reportEventStage((CampaignEventPlugin)this, stageId, this.findMessageSender(), MessagePriority.ENSURE_DELIVERY, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){
                boolean hasBonus;
                {
                    this.hasBonus = ConquestMissionEvent.this.mission.hasBonus(ConquestMissionEvent.this.elapsedDays);
                }

                public void beforeDelivery(CommMessageAPI message) {
                    ReputationActionResponsePlugin.ReputationAdjustmentResult result = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_SUCCESS, (Object)ConquestMissionEvent.this.mission.getRepChange(this.hasBonus), message, null, true), ConquestMissionEvent.this.mission.getIssuer().getId());
                    float reward = ConquestMissionEvent.this.mission.baseReward;
                    if (this.hasBonus) {
                        reward += ConquestMissionEvent.this.mission.bonusReward;
                    }
                    Global.getSector().getPlayerFleet().getCargo().getCredits().add(reward);
                }
            });
            this.endEvent();
        } else if (!this.mission.getIssuer().isHostileTo(targetFactionId)) {
            Global.getSector().reportEventStage((CampaignEventPlugin)this, "cancelled", (SectorEntityToken)Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY);
            this.endEvent();
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.mission.getBaseDuration() - this.elapsedDays <= 0.0f) {
            Global.getSector().reportEventStage((CampaignEventPlugin)this, "failure", (SectorEntityToken)Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

                public void beforeDelivery(CommMessageAPI message) {
                    ReputationActionResponsePlugin.ReputationAdjustmentResult result = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_FAILURE, (Object)ConquestMissionEvent.this.mission.getRepChange(false), message, null, true), ConquestMissionEvent.this.mission.getIssuer().getId());
                }
            });
            this.endEvent();
        }
    }

    public void endEvent() {
        Misc.makeUnimportant((SectorEntityToken)this.entity, (String)"nex_conquest");
        this.ended = true;
    }

    private void updateDaysLeft() {
        int bonusDaysLeft;
        int daysLeft = (int)(this.mission.getBaseDuration() - this.elapsedDays);
        if (daysLeft < 1) {
            daysLeft = 1;
        }
        this.daysLeftStr = daysLeft + " days";
        if (daysLeft <= 1) {
            this.daysLeftStr = daysLeft + " day";
        }
        if ((bonusDaysLeft = (int)(this.mission.getBonusDuration() - this.elapsedDays)) < 1) {
            bonusDaysLeft = 1;
        }
        this.bonusDaysLeftStr = bonusDaysLeft + " days";
        if (bonusDaysLeft <= 1) {
            this.bonusDaysLeftStr = bonusDaysLeft + " day";
        }
    }

    public Map<String, String> getTokenReplacements() {
        this.updateDaysLeft();
        Map map = super.getTokenReplacements();
        map.put("$sender", StringHelper.getString(STRING_HELPER_CAT, "missionBoard"));
        LocationAPI loc = this.market.getContainingLocation();
        String locName = Misc.lcFirst((String)loc.getName());
        if (loc instanceof StarSystemAPI) {
            locName = ((StarSystemAPI)loc).getBaseName();
        }
        map.put("$target", "" + this.mission.getTarget().getName());
        map.put("$targetLocation", locName);
        map.put("$targetSize", "" + this.mission.getTarget().getSize());
        ConquestMissionEvent.addFactionNameTokens((Map)map, (String)"target", (FactionAPI)this.mission.getTarget().getFaction());
        ConquestMissionEvent.addFactionNameTokens((Map)map, (String)"issuer", (FactionAPI)this.mission.getIssuer());
        ConquestMissionEvent.addFactionNameTokens((Map)map, (String)"player", (FactionAPI)Global.getSector().getFaction(PlayerFactionStore.getPlayerFactionId()));
        map.put("$daysLeft", this.daysLeftStr);
        map.put("$bonusDays", this.bonusDaysLeftStr);
        map.put("$rewardCredits", Misc.getWithDGS((float)((int)this.mission.getBaseReward())) + "\u00a2");
        map.put("$bonusCredits", Misc.getWithDGS((float)((int)this.mission.getBonusReward())) + "\u00a2");
        if (this.mission.hasBonus(this.elapsedDays)) {
            map.put("$actualReward", Misc.getWithDGS((float)((int)this.mission.getBaseReward() + (int)this.mission.getBonusReward())) + "\u00a2");
        } else {
            map.put("$actualReward", Misc.getWithDGS((float)((int)this.mission.getBaseReward())) + "\u00a2");
        }
        return map;
    }

    public String[] getHighlights(String stageId) {
        int daysLeft = (int)(this.mission.getBaseDuration() - this.elapsedDays);
        if (daysLeft < 1) {
            daysLeft = 1;
        }
        int bonusDaysLeft = (int)(this.mission.getBonusDuration() - this.elapsedDays);
        ArrayList<String> result = new ArrayList<String>();
        if ("posting".equals(stageId)) {
            result.add("" + daysLeft);
            this.addTokensToList(result, new String[]{"$rewardCredits"});
            this.addTokensToList(result, new String[]{"$targetFaction"});
            this.addTokensToList(result, new String[]{"$targetSize"});
        } else if ("posting_bonus".equals(stageId)) {
            result.add("" + daysLeft);
            this.addTokensToList(result, new String[]{"$rewardCredits"});
            this.addTokensToList(result, new String[]{"$bonusCredits"});
            result.add("" + bonusDaysLeft);
            this.addTokensToList(result, new String[]{"$targetFaction"});
            this.addTokensToList(result, new String[]{"$targetSize"});
        } else if ("success".equals(stageId) || "success_bonus".equals(stageId)) {
            this.addTokensToList(result, new String[]{"$actualReward"});
            this.addTokensToList(result, new String[]{"$bonusCredits"});
        } else if ("accept".equals(stageId)) {
            result.add("" + daysLeft);
            this.addTokensToList(result, new String[]{"$rewardCredits"});
        } else if ("accept_bonus".equals(stageId)) {
            result.add("" + daysLeft);
            this.addTokensToList(result, new String[]{"$rewardCredits"});
            this.addTokensToList(result, new String[]{"$bonusCredits"});
            result.add("" + bonusDaysLeft);
        } else if ("failure".equals(stageId)) {
            // empty if block
        }
        return result.toArray(new String[0]);
    }

    public Color[] getHighlightColors(String stageId) {
        return super.getHighlightColors(stageId);
    }

    public boolean isDone() {
        return this.ended;
    }

    public String getEventIcon() {
        return this.mission.issuer.getCrest();
    }

    public String getEventName() {
        int daysLeft = (int)(this.mission.getBaseDuration() - this.elapsedDays);
        String days = "";
        if (daysLeft > 0) {
            days = ", " + StringHelper.getStringAndSubstituteToken(STRING_HELPER_CAT, "daysLeft", "$days", daysLeft + "");
        }
        String conquer = Misc.ucFirst((String)StringHelper.getStringAndSubstituteToken(STRING_HELPER_CAT, "conquer", "$target", this.mission.getTarget().getName()));
        if (this.isDone()) {
            return conquer + " - " + StringHelper.getString(STRING_HELPER_CAT, "over");
        }
        return conquer + days;
    }

    public String getCurrentImage() {
        return this.mission.issuer.getLogo();
    }

    public boolean allowMultipleOngoingForSameTarget() {
        return true;
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.MISSION;
    }
}

