/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.missions.MarketProcurementMission;
import com.fs.starfarer.api.impl.campaign.shared.PlayerTradeDataForSubmarket;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.Vector2f;

@Deprecated
public class ExerelinMarketProcurementMissionEvent
extends BaseEventPlugin {
    private MarketProcurementMission mission = null;
    private float elapsedDays = 0.0f;
    private boolean wantsToSendPirate = true;
    private boolean sentPirate = false;
    private IntervalUtil pirateTracker = new IntervalUtil(0.1f, 0.3f);
    private boolean contactWillInitiateComms = false;
    private boolean ended = false;
    private String bonusDaysLeftStr;
    private String daysLeftStr;

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget, false);
    }

    public void setParam(Object param) {
        this.mission = (MarketProcurementMission)param;
        this.updateDaysLeft();
    }

    public void startEvent() {
        super.startEvent();
        this.wantsToSendPirate = (float)Math.random() > 0.66f;
        String stageId = "accept";
        if (this.mission.hasBonus(this.elapsedDays)) {
            stageId = "accept_bonus";
        }
        Global.getSector().reportEventStage((CampaignEventPlugin)this, stageId, this.mission.getAcceptLocation(), MessagePriority.DELIVER_IMMEDIATELY, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

            public void beforeDelivery(CommMessageAPI message) {
                if (ExerelinMarketProcurementMissionEvent.this.market.getStarSystem() != null) {
                    message.setStarSystemId(ExerelinMarketProcurementMissionEvent.this.market.getStarSystem().getId());
                }
            }
        });
        this.mission.getMarket().getCommDirectory().addPerson(this.mission.getContact());
        this.mission.getContact().getMemoryWithoutUpdate().set("$mpm_isPlayerContact", (Object)true, this.mission.getBaseDuration());
        this.mission.getContact().getMemoryWithoutUpdate().set("$mpm_eventRef", (Object)this, this.mission.getBaseDuration());
        this.mission.getContact().getMemoryWithoutUpdate().set("$mpm_commodityName", (Object)this.mission.getCOM().getCommodity().getName().toLowerCase(), this.mission.getBaseDuration());
        this.mission.getContact().getMemoryWithoutUpdate().set("$mpm_quantity", (Object)Misc.getWithDGS((float)((int)this.mission.getQuantity())), this.mission.getBaseDuration());
        Misc.setFlagWithReason((MemoryAPI)this.mission.getContact().getMemoryWithoutUpdate(), (String)"$requiresDiscretionToDeal", (String)("mpm_" + this.mission.getCommodityId()), (boolean)true, (float)this.mission.getBaseDuration());
        Misc.setFlagWithReason((MemoryAPI)this.mission.getContact().getMemoryWithoutUpdate(), (String)"$missionImportant", (String)"mpm", (boolean)true, (float)this.mission.getBaseDuration());
        this.updateDaysLeft();
        this.contactWillInitiateComms = (float)Math.random() > 0.5f;
        boolean illegal = this.mission.getContact().getFaction().isHostileTo(this.market.getFaction());
        if (illegal) {
            this.contactWillInitiateComms = false;
        }
        if (this.contactWillInitiateComms) {
            this.mission.getContact().incrWantsToContactReasons();
        }
    }

    private void endEvent() {
        this.ended = true;
        this.mission.getContact().getMemoryWithoutUpdate().unset("$mpm_isPlayerContact");
        this.mission.getContact().getMemoryWithoutUpdate().unset("$mpm_eventRef");
        this.mission.getContact().getMemoryWithoutUpdate().unset("$mpm_commodityName");
        this.mission.getContact().getMemoryWithoutUpdate().unset("$mpm_quantity");
        Misc.setFlagWithReason((MemoryAPI)this.mission.getContact().getMemoryWithoutUpdate(), (String)"$requiresDiscretionToDeal", (String)("mpm_" + this.mission.getCommodityId()), (boolean)false, (float)0.0f);
        Misc.setFlagWithReason((MemoryAPI)this.mission.getContact().getMemoryWithoutUpdate(), (String)"$missionImportant", (String)"mpm", (boolean)false, (float)0.0f);
        if (this.contactWillInitiateComms) {
            this.mission.getContact().decrWantsToContactReasons();
        }
        Global.getSector().getImportantPeople().returnPerson(this.mission.getContact(), "MPM_mission_contact");
        if (!Global.getSector().getImportantPeople().isCheckedOutForAnything(this.mission.getContact())) {
            this.market.getCommDirectory().removePerson(this.mission.getContact());
        }
    }

    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        this.updateDaysLeft();
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        if (this.mission.getBaseDuration() - this.elapsedDays <= 0.0f) {
            Global.getSector().reportEventStage((CampaignEventPlugin)this, "failure", (SectorEntityToken)Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

                public void beforeDelivery(CommMessageAPI message) {
                    ReputationActionResponsePlugin.ReputationAdjustmentResult result = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_FAILURE, (Object)ExerelinMarketProcurementMissionEvent.this.mission.getRepChange(), message, null, true), ExerelinMarketProcurementMissionEvent.this.mission.getContact().getFaction().getId());
                    result = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_FAILURE, (Object)ExerelinMarketProcurementMissionEvent.this.mission.getRepChange(), message, null, true), ExerelinMarketProcurementMissionEvent.this.mission.getContact());
                }
            });
            this.endEvent();
            return;
        }
        if (this.wantsToSendPirate && !this.sentPirate) {
            CampaignFleetAPI playerFleet;
            float playerQty;
            this.pirateTracker.advance(days);
            if (this.pirateTracker.intervalElapsed() && (playerQty = (playerFleet = Global.getSector().getPlayerFleet()).getCargo().getCommodityQuantity(this.mission.getCommodityId())) >= this.mission.getQuantity() && playerFleet.isInHyperspace()) {
                CampaignFleetAPI pirateFleet = this.createPirateFleet();
                if (pirateFleet != null) {
                    playerFleet.getContainingLocation().addEntity((SectorEntityToken)pirateFleet);
                    Vector2f pirateLoc = Misc.getPointAtRadius((Vector2f)playerFleet.getLocation(), (float)500.0f);
                    pirateFleet.setLocation(pirateLoc.x, pirateLoc.y);
                    pirateFleet.getAI().addAssignmentAtStart(FleetAssignment.INTERCEPT, (SectorEntityToken)playerFleet, 1000.0f, null);
                    pirateFleet.getMemoryWithoutUpdate().set("$mpm_isSpawnedByMPM", (Object)true);
                    PersonAPI person = pirateFleet.getCommander();
                    person.getMemoryWithoutUpdate().set("$mpm_eventRef", (Object)this, this.mission.getBaseDuration());
                    person.getMemoryWithoutUpdate().set("$mpm_commodityName", (Object)this.mission.getCOM().getCommodity().getName().toLowerCase(), this.mission.getBaseDuration());
                    person.getMemoryWithoutUpdate().set("$mpm_quantity", (Object)Misc.getWithDGS((float)((int)this.mission.getQuantity())), this.mission.getBaseDuration());
                }
                this.sentPirate = true;
            }
        }
    }

    protected CampaignFleetAPI createPirateFleet() {
        CampaignFleetAPI fleet;
        float pts = 5.0f + Math.min(10.0f, this.mission.getBaseReward() / 10000.0f);
        float quantity = this.mission.getQuantity();
        float freighterPts = quantity / 100.0f;
        if (freighterPts > 8.0f) {
            freighterPts = 8.0f;
        }
        if ((fleet = FleetFactoryV2.createFleet((FleetParams)new FleetParams(Global.getSector().getPlayerFleet().getLocationInHyperspace(), null, "pirates", null, "mercPrivateer", pts, freighterPts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0))) == null) {
            return null;
        }
        Misc.setFlagWithReason((MemoryAPI)fleet.getMemoryWithoutUpdate(), (String)"$lowRepImpact", (String)"mpm", (boolean)true, (float)10000.0f);
        return fleet;
    }

    public boolean callEvent(String ruleId, final InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        String action = params.get(0).getString(memoryMap);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        CargoAPI cargo = playerFleet.getCargo();
        if (action.equals("performDelivery")) {
            cargo.removeItems(CargoAPI.CargoItemType.RESOURCES, (Object)this.mission.getCommodityId(), this.mission.getQuantity());
            int reward = (int)this.mission.getBaseReward();
            if (this.mission.hasBonus(this.elapsedDays)) {
                reward = (int)(this.mission.getBaseReward() + this.mission.getBonusReward());
            }
            cargo.getCredits().add((float)reward);
            this.mission.getContact().getMemoryWithoutUpdate().set("$mpm_rewardCredits", (Object)Misc.getWithDGS((float)reward), 0.0f);
            this.applyTradeValueImpact(reward);
            Global.getSector().reportEventStage((CampaignEventPlugin)this, "success", (SectorEntityToken)Global.getSector().getPlayerFleet(), MessagePriority.DELIVER_IMMEDIATELY, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

                public void beforeDelivery(CommMessageAPI message) {
                    ReputationActionResponsePlugin.ReputationAdjustmentResult result = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_SUCCESS, (Object)ExerelinMarketProcurementMissionEvent.this.mission.getRepChange(), message, dialog.getTextPanel(), true), ExerelinMarketProcurementMissionEvent.this.mission.getContact().getFaction().getId());
                    result = Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.MISSION_SUCCESS, (Object)ExerelinMarketProcurementMissionEvent.this.mission.getRepChange(), message, dialog.getTextPanel(), true), ExerelinMarketProcurementMissionEvent.this.mission.getContact());
                }
            });
        } else {
            if (action.equals("hasEnough")) {
                return cargo.getCommodityQuantity(this.mission.getCommodityId()) >= this.mission.getQuantity();
            }
            if (action.equals("endEvent")) {
                this.endEvent();
            } else if (action.equals("handOver")) {
                CargoAPI pirateCargo = dialog.getInteractionTarget().getCargo();
                cargo.removeItems(CargoAPI.CargoItemType.RESOURCES, (Object)this.mission.getCommodityId(), this.mission.getQuantity());
                pirateCargo.addItems(CargoAPI.CargoItemType.RESOURCES, (Object)this.mission.getCommodityId(), this.mission.getQuantity());
                CampaignFleetAPI pirateFleet = (CampaignFleetAPI)dialog.getInteractionTarget();
                pirateFleet.getAI().removeFirstAssignment();
                pirateFleet.getAI().addAssignmentAtStart(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.market.getPrimaryEntity(), 1000.0f, null);
                pirateFleet.getMemoryWithoutUpdate().unset("$mpm_isSpawnedByMPM");
                pirateFleet.getMemoryWithoutUpdate().set("$cfai_makeHostile", (Object)false, 10.0f);
            } else if (action.equals("hasBonus")) {
                return this.mission.hasBonus(this.elapsedDays);
            }
        }
        return true;
    }

    protected void applyTradeValueImpact(float totalReward) {
        boolean illegal = this.mission.getContact().getFaction().isHostileTo(this.market.getFaction());
        SubmarketAPI submarket = null;
        for (SubmarketAPI curr : this.market.getSubmarketsCopy()) {
            if (!curr.getPlugin().isParticipatesInEconomy() || this.mission.getContact().getFaction() != curr.getFaction()) continue;
            submarket = curr;
            break;
        }
        if (submarket == null) {
            for (SubmarketAPI curr : this.market.getSubmarketsCopy()) {
                if (!curr.getPlugin().isParticipatesInEconomy()) continue;
                if (illegal && curr.getPlugin().isBlackMarket()) {
                    submarket = curr;
                    break;
                }
                if (illegal || !curr.getPlugin().isOpenMarket()) continue;
                submarket = curr;
                break;
            }
        }
        if (submarket == null) {
            return;
        }
        PlayerTradeDataForSubmarket tradeData = SharedData.getData().getPlayerActivityTracker().getPlayerTradeData(submarket);
        CargoStackAPI stack = Global.getFactory().createCargoStack(CargoAPI.CargoItemType.RESOURCES, (Object)this.mission.getCommodityId(), null);
        stack.setSize(this.mission.getQuantity());
        tradeData.addToTrackedPlayerSold(stack, totalReward);
    }

    private void updateDaysLeft() {
        int bonusDaysLeft;
        int daysLeft = (int)(this.mission.getBaseDuration() - this.elapsedDays);
        if (daysLeft < 1) {
            daysLeft = 1;
        }
        this.daysLeftStr = daysLeft + " days";
        if (daysLeft <= 1) {
            this.daysLeftStr = daysLeft + " day";
        }
        if ((bonusDaysLeft = (int)(this.mission.getBonusDuration() - this.elapsedDays)) < 1) {
            bonusDaysLeft = 1;
        }
        this.bonusDaysLeftStr = bonusDaysLeft + " days";
        if (bonusDaysLeft <= 1) {
            this.bonusDaysLeftStr = bonusDaysLeft + " day";
        }
        this.mission.getContact().getMemoryWithoutUpdate().set("$mpm_daysLeft", (Object)this.daysLeftStr, 1.0f);
        this.mission.getContact().getMemoryWithoutUpdate().set("$mpm_bonusDays", (Object)this.bonusDaysLeftStr, 1.0f);
    }

    public Map<String, String> getTokenReplacements() {
        this.updateDaysLeft();
        Map map = super.getTokenReplacements();
        map.put("$sender", "Mission Board");
        map.put("$quantity", "" + Misc.getWithDGS((float)((int)this.mission.getQuantity())));
        map.put("$commodity", this.mission.getCOM().getCommodity().getName().toLowerCase());
        map.put("$daysLeft", this.daysLeftStr);
        map.put("$bonusDays", this.bonusDaysLeftStr);
        map.put("$rewardCredits", Misc.getWithDGS((float)((int)this.mission.getBaseReward())) + "\u00a2");
        map.put("$bonusCredits", Misc.getWithDGS((float)((int)this.mission.getBonusReward())) + "\u00a2");
        if (this.mission.hasBonus(this.elapsedDays)) {
            map.put("$actualReward", Misc.getWithDGS((float)((int)this.mission.getBaseReward() + (int)this.mission.getBonusReward())) + "\u00a2");
        } else {
            map.put("$actualReward", Misc.getWithDGS((float)((int)this.mission.getBaseReward())) + "\u00a2");
        }
        map.put("$perUnit", Misc.getWithDGS((float)((int)(this.mission.getBaseReward() / this.mission.getQuantity()))) + "\u00a2");
        String desc = this.mission.getContact().getPost();
        if (desc == null || Ranks.POST_SHADY.equals(this.mission.getContact().getPostId()) || Ranks.POST_FENCE.equals(this.mission.getContact().getPostId()) || Ranks.POST_GANGSTER.equals(this.mission.getContact().getPostId()) || Ranks.POST_SMUGGLER.equals(this.mission.getContact().getPostId())) {
            desc = "one";
        }
        if (desc == null) {
            desc = this.mission.getContact().getRank();
        }
        map.put("$contactDesc", desc);
        ExerelinMarketProcurementMissionEvent.addPersonTokens((Map)map, (String)"contact", (PersonAPI)this.mission.getContact());
        if (this.market.getFaction().isHostileTo(this.mission.getContact().getFaction())) {
            map.put("$contactDetail", "is affiliated with the local underworld and will require clandestine delivery, which may attract the interest of local authorities");
        } else if (this.market.getFaction() != this.mission.getContact().getFaction()) {
            map.put("$contactDetail", "is " + this.mission.getContact().getFaction().getPersonNamePrefixAOrAn() + " " + this.mission.getContact().getFaction().getPersonNamePrefix() + " " + desc + " operating with the knowledge of the local authorities and the delivery may be made openly");
        } else {
            map.put("$contactDetail", "is working for the local authorities and the delivery may be made openly");
        }
        return map;
    }

    public String[] getHighlights(String stageId) {
        int daysLeft = (int)(this.mission.getBaseDuration() - this.elapsedDays);
        if (daysLeft < 1) {
            daysLeft = 1;
        }
        int bonusDaysLeft = (int)(this.mission.getBonusDuration() - this.elapsedDays);
        ArrayList<String> result = new ArrayList<String>();
        if ("posting".equals(stageId)) {
            this.addTokensToList(result, new String[]{"$quantity"});
            result.add("" + daysLeft);
            this.addTokensToList(result, new String[]{"$rewardCredits"});
            this.addTokensToList(result, new String[]{"$perUnit"});
        } else if ("posting_bonus".equals(stageId)) {
            this.addTokensToList(result, new String[]{"$quantity"});
            result.add("" + daysLeft);
            this.addTokensToList(result, new String[]{"$rewardCredits"});
            this.addTokensToList(result, new String[]{"$bonusCredits"});
            result.add("" + bonusDaysLeft);
            this.addTokensToList(result, new String[]{"$perUnit"});
        } else if ("success".equals(stageId) || "success_bonus".equals(stageId)) {
            this.addTokensToList(result, new String[]{"$quantity"});
            this.addTokensToList(result, new String[]{"$actualReward"});
            this.addTokensToList(result, new String[]{"$bonusCredits"});
        } else if ("accept".equals(stageId)) {
            this.addTokensToList(result, new String[]{"$quantity"});
            result.add("" + daysLeft);
            this.addTokensToList(result, new String[]{"$rewardCredits"});
            this.addTokensToList(result, new String[]{"$perUnit"});
        } else if ("accept_bonus".equals(stageId)) {
            this.addTokensToList(result, new String[]{"$quantity"});
            result.add("" + daysLeft);
            this.addTokensToList(result, new String[]{"$rewardCredits"});
            this.addTokensToList(result, new String[]{"$perUnit"});
            this.addTokensToList(result, new String[]{"$bonusCredits"});
            result.add("" + bonusDaysLeft);
        } else if ("failure".equals(stageId)) {
            this.addTokensToList(result, new String[]{"$quantity"});
        }
        return result.toArray(new String[0]);
    }

    public Color[] getHighlightColors(String stageId) {
        return super.getHighlightColors(stageId);
    }

    public boolean isDone() {
        return this.ended;
    }

    public String getEventName() {
        CommodityOnMarketAPI com = this.mission.getCOM();
        float quantity = this.mission.getQuantity();
        int daysLeft = (int)(this.mission.getBaseDuration() - this.elapsedDays);
        String days = "";
        days = daysLeft > 0 ? ", " + daysLeft + "d" : ", <1d";
        if (this.isDone()) {
            return "" + (int)quantity + " " + "\u00d7" + " " + com.getCommodity().getName().toLowerCase() + " - done";
        }
        return "" + (int)quantity + " " + "\u00d7" + " " + com.getCommodity().getName().toLowerCase() + "" + days;
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.MISSION;
    }

    public String getEventIcon() {
        return this.mission.getCOM().getCommodity().getIconName();
    }

    public String getCurrentImage() {
        return Global.getSector().getFaction(this.mission.getFactionId()).getLogo();
    }
}

