/*
 * Decompiled with CFR 0.152.
 */
package exerelin.campaign.submarkets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.campaign.events.SWP_IBBTracker;
import data.scripts.campaign.missions.SWP_FamousBountyEvent;
import exerelin.campaign.ExerelinSetupData;
import exerelin.plugins.ExerelinModPlugin;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.StringHelper;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PrismMarket
extends BaseSubmarketPlugin {
    public static final RepLevel MIN_STANDING = RepLevel.NEUTRAL;
    public static final String IBB_FILE = "data/config/prism/prism_boss_ships.csv";
    public static final String SHIPS_BLACKLIST = "data/config/prism/prism_ships_blacklist.csv";
    public static final String WEAPONS_BLACKLIST = "data/config/prism/prism_weapons_blacklist.csv";
    public static final String ILLEGAL_TRANSFER_MESSAGE = StringHelper.getString("exerelin_markets", "prismNoSale");
    public static final Set<String> DISALLOWED_FACTIONS = new HashSet<String>(Arrays.asList("templars", "derelict", "remnant", "pirates"));
    public static final Set<String> DISALLOWED_PREFIXES = new HashSet<String>(Arrays.asList("tem_"));
    public static Logger log = Global.getLogger(PrismMarket.class);
    protected static Set<String> restrictedWeapons;
    protected static Set<String> restrictedShips;
    public Set<String> alreadyBoughtShips = new HashSet<String>();

    public static String getIBBFile() {
        return IBB_FILE;
    }

    public void init(SubmarketAPI submarket) {
        super.init(submarket);
    }

    public static Set getRestrictedShips() {
        return new HashSet<String>(restrictedShips);
    }

    public static Set getRestrictedWeapons() {
        return new HashSet<String>(restrictedWeapons);
    }

    public void updateCargoPrePlayerInteraction() {
        if (!this.okToUpdateCargo()) {
            return;
        }
        this.sinceLastCargoUpdate = 0.0f;
        CargoAPI cargo = this.getCargo();
        for (CargoStackAPI s : cargo.getStacksCopy()) {
            if (!(Math.random() > 0.5)) continue;
            float qty = s.getSize();
            cargo.removeItems(s.getType(), s.getData(), qty);
            cargo.removeEmptyStacks();
        }
        this.addShips();
        this.addWings();
        this.addWeapons();
        cargo.sort();
    }

    public boolean isShipAllowed(FleetMemberAPI member, float requiredFP) {
        if (member.getHullSpec().isDHull()) {
            return false;
        }
        if ((float)member.getFleetPointCost() < requiredFP) {
            return false;
        }
        if (restrictedShips.contains(member.getHullSpec().getBaseHullId())) {
            return false;
        }
        return !member.getHullSpec().getHints().contains(ShipHullSpecAPI.ShipTypeHints.STATION);
    }

    public boolean isWingAllowed(FighterWingSpecAPI spec) {
        if (spec.getTier() < 2) {
            return false;
        }
        if (spec.getTier() >= 5) {
            return false;
        }
        if (spec.hasTag("no_sell")) {
            return false;
        }
        String specId = spec.getId();
        for (String prefix : DISALLOWED_PREFIXES) {
            if (!specId.startsWith(prefix)) continue;
            return false;
        }
        return !restrictedShips.contains(specId);
    }

    public boolean isWeaponAllowed(WeaponSpecAPI spec) {
        if (spec.getTier() < 2) {
            return false;
        }
        String specId = spec.getWeaponId();
        for (String prefix : DISALLOWED_PREFIXES) {
            if (!specId.startsWith(prefix)) continue;
            return false;
        }
        return !restrictedWeapons.contains(specId);
    }

    protected void addRandomWeapons(int max, int maxTier) {
        CargoAPI cargo = this.getCargo();
        List weaponIds = Global.getSector().getAllWeaponIds();
        WeightedRandomPicker picker = new WeightedRandomPicker();
        if (Global.getSettings().isDevMode()) {
            // empty if block
        }
        picker.setRandom(this.itemGenRandom);
        for (String id : weaponIds) {
            WeaponSpecAPI spec = Global.getSettings().getWeaponSpec(id);
            if (spec.getTier() > maxTier) continue;
            float qualityDiff = 0.0f;
            float f = Math.max(0.0f, 1.0f - qualityDiff);
            float weight = Math.max(0.05f, f * f);
            picker.add((Object)spec.getWeaponId(), weight *= spec.getRarity());
        }
        if (!picker.isEmpty()) {
            for (int i = 0; i < max; ++i) {
                String weaponId = (String)picker.pick();
                int quantity = 2;
                cargo.addWeapons(weaponId, quantity);
            }
        }
    }

    protected void addWeapons() {
        CargoAPI cargo = this.getCargo();
        float variation = (float)Math.random() * 0.5f + 0.75f;
        float i = 0.0f;
        while (i < (float)ExerelinConfig.prismMaxWeapons * variation) {
            this.addRandomWeapons(10, 3);
            for (CargoStackAPI s : cargo.getStacksCopy()) {
                if (!s.isWeaponStack() || this.isWeaponAllowed(s.getWeaponSpecIfWeapon())) continue;
                float qty = s.getSize();
                cargo.removeItems(s.getType(), s.getData(), qty);
                cargo.removeEmptyStacks();
            }
            i = cargo.getWeapons().size();
        }
    }

    protected void addWings() {
        CargoAPI cargo = this.getCargo();
        WeightedRandomPicker fighterPicker = new WeightedRandomPicker();
        for (Object spec : Global.getSettings().getAllFighterWingSpecs()) {
            if (!this.isWingAllowed((FighterWingSpecAPI)spec)) continue;
            fighterPicker.add((Object)spec.getId());
        }
        int picks = 0;
        for (CargoAPI.CargoItemQuantity quantity : cargo.getFighters()) {
            picks += quantity.getCount();
        }
        while (!fighterPicker.isEmpty() && picks < ExerelinConfig.prismNumWings) {
            String id = (String)fighterPicker.pick();
            cargo.addItems(CargoAPI.CargoItemType.FIGHTER_CHIP, (Object)id, 1.0f);
            ++picks;
        }
    }

    protected void addShips() {
        FactionAPI faction;
        CargoAPI cargo = this.getCargo();
        FleetDataAPI data = cargo.getMothballedShips();
        Set<String> allBossShips = this.getAllBossShips();
        for (FleetMemberAPI member : data.getMembersListCopy()) {
            if (allBossShips.contains(member.getHullId())) {
                data.removeFleetMember(member);
                continue;
            }
            if (!(Math.random() > 0.5)) continue;
            data.removeFleetMember(member);
        }
        WeightedRandomPicker rolePicker = new WeightedRandomPicker();
        rolePicker.add((Object)"civilianRandom", 1.0f);
        rolePicker.add((Object)"freighterSmall", 1.0f);
        rolePicker.add((Object)"freighterMedium", 1.0f);
        rolePicker.add((Object)"freighterLarge", 5.0f);
        rolePicker.add((Object)"tankerSmall", 1.0f);
        rolePicker.add((Object)"tankerMedium", 1.0f);
        rolePicker.add((Object)"tankerLarge", 1.0f);
        rolePicker.add((Object)"combatFreighterSmall", 1.0f);
        rolePicker.add((Object)"combatFreighterMedium", 1.0f);
        rolePicker.add((Object)"combatFreighterLarge", 5.0f);
        rolePicker.add((Object)"combatSmall", 25.0f);
        rolePicker.add((Object)"combatMedium", 30.0f);
        rolePicker.add((Object)"combatLarge", 25.0f);
        rolePicker.add((Object)"combatCapital", 15.0f);
        rolePicker.add((Object)"carrierSmall", 5.0f);
        rolePicker.add((Object)"carrierMedium", 5.0f);
        rolePicker.add((Object)"carrierLarge", 5.0f);
        WeightedRandomPicker factionPicker = new WeightedRandomPicker();
        SectorAPI sector = Global.getSector();
        for (String factionId : ExerelinSetupData.getInstance().getAllFactions()) {
            faction = sector.getFaction(factionId);
            if (!faction.isShowInIntelTab() || DISALLOWED_FACTIONS.contains(factionId)) continue;
            factionPicker.add((Object)sector.getFaction(factionId));
        }
        float variation = (float)Math.random() * 0.5f + 0.75f;
        int i = 0;
        while ((float)i < (float)ExerelinConfig.prismNumShips * variation) {
            faction = (FactionAPI)factionPicker.pick();
            String role = (String)rolePicker.pick();
            List picks = faction.pickShip(role, 1.0f, rolePicker.getRandom());
            for (ShipRolePick pick : picks) {
                FleetMemberType type = FleetMemberType.SHIP;
                String variantId = pick.variantId;
                FleetMemberAPI member = Global.getFactory().createFleetMember(type, variantId);
                variantId = member.getHullId() + "_Hull";
                int FP = (member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variantId)).isCapital() ? 20 : (member.isCruiser() ? 14 : (member.isDestroyer() ? 10 : (member.isFrigate() ? 5 : 6)));
                if (this.isShipAllowed(member, FP)) {
                    member.getRepairTracker().setMothballed(true);
                    this.getCargo().getMothballedShips().addFleetMember(member);
                    continue;
                }
                --i;
            }
            i = cargo.getMothballedShips().getNumMembers();
        }
        List<String> bossShips = this.getBossShips();
        for (String variantId : bossShips) {
            try {
                if (variantId.endsWith("_wing")) {
                    this.getCargo().addFighters(variantId, 1);
                    continue;
                }
                variantId = variantId + "_Hull";
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variantId);
                member.getRepairTracker().setMothballed(true);
                this.getCargo().getMothballedShips().addFleetMember(member);
            }
            catch (RuntimeException rex) {}
        }
    }

    public Set<String> getAllBossShips() {
        HashSet<String> bossShips = new HashSet<String>();
        try {
            JSONArray config = Global.getSettings().getMergedSpreadsheetDataForMod("id", PrismMarket.getIBBFile(), "nexerelin");
            for (int i = 0; i < config.length(); ++i) {
                JSONObject row = config.getJSONObject(i);
                String hullId = row.getString("id");
                String factionId = row.optString("faction");
                if (!this.canLoadShips(factionId)) continue;
                bossShips.add(hullId);
            }
        }
        catch (IOException | JSONException ex) {
            log.error((Object)ex);
        }
        return bossShips;
    }

    public List<String> getBossShips() {
        ArrayList<BossShipEntry> validShips = new ArrayList<BossShipEntry>();
        ArrayList<String> ret = new ArrayList<String>();
        WeightedRandomPicker picker = new WeightedRandomPicker();
        int ibbProgress = 999;
        boolean doIBBCheck = ExerelinConfig.prismUseIBBProgressForBossShips && ExerelinModPlugin.HAVE_SWP;
        int highestIBBNum = 0;
        try {
            JSONArray config = Global.getSettings().getMergedSpreadsheetDataForMod("id", PrismMarket.getIBBFile(), "nexerelin");
            for (int i = 0; i < config.length(); ++i) {
                JSONObject row = config.getJSONObject(i);
                String hullId = row.getString("id");
                String factionId = row.optString("faction");
                if (!this.canLoadShips(factionId)) continue;
                int ibbNum = row.getInt("ibbNum");
                String stage = row.optString("stage");
                validShips.add(new BossShipEntry(hullId, ibbNum, stage));
                if (ibbNum <= highestIBBNum) continue;
                highestIBBNum = ibbNum;
            }
            if (ibbProgress == 999) {
                ibbProgress = highestIBBNum;
            }
            for (BossShipEntry entry : validShips) {
                boolean proceed = true;
                String stageStr = entry.stage;
                if (doIBBCheck && stageStr != null && !stageStr.isEmpty()) {
                    try {
                        SWP_FamousBountyEvent.FamousBountyStage stage = SWP_FamousBountyEvent.FamousBountyStage.valueOf((String)stageStr);
                        if (!SWP_IBBTracker.getTracker().isStageComplete(stage)) {
                            log.info((Object)("IBB not completed for " + entry.id + " (" + stageStr + ")"));
                            proceed = false;
                        }
                    }
                    catch (IllegalArgumentException | NullPointerException ex) {
                        log.error((Object)("Failed to check IBB completion for " + entry.id + ": " + ex));
                    }
                }
                if (!proceed || !ExerelinConfig.prismRenewBossShips && this.alreadyBoughtShips.contains(entry.id)) continue;
                int weight = 3;
                if (entry.ibbNum > 0) {
                    int diff = Math.abs(ibbProgress - entry.ibbNum);
                    if (diff > 3) {
                        diff = 3;
                    }
                    weight += 4 * (3 - diff);
                }
                picker.add((Object)entry.id, (float)weight);
            }
        }
        catch (IOException | JSONException ex) {
            log.error((Object)ex);
        }
        for (int i = 0; i < ExerelinConfig.prismNumBossShips && !picker.isEmpty(); ++i) {
            ret.add((String)picker.pickAndRemove());
        }
        return ret;
    }

    public boolean canLoadShips(String factionOrModId) {
        if (factionOrModId == null) {
            return true;
        }
        if (factionOrModId.equals("ssp")) {
            return ExerelinModPlugin.HAVE_SWP;
        }
        return Global.getSector().getFaction(factionOrModId) != null || Global.getSettings().getModManager().isModEnabled(factionOrModId);
    }

    protected static void setupBlacklists() throws JSONException, IOException {
        JSONObject row;
        int x;
        restrictedWeapons = new HashSet<String>();
        restrictedShips = new HashSet<String>();
        JSONArray csv = Global.getSettings().getMergedSpreadsheetDataForMod("id", WEAPONS_BLACKLIST, "nexerelin");
        for (x = 0; x < csv.length(); ++x) {
            row = csv.getJSONObject(x);
            restrictedWeapons.add(row.getString("id"));
        }
        csv = Global.getSettings().getMergedSpreadsheetDataForMod("id", SHIPS_BLACKLIST, "nexerelin");
        for (x = 0; x < csv.length(); ++x) {
            row = csv.getJSONObject(x);
            restrictedShips.add(row.getString("id"));
        }
    }

    public boolean isIllegalOnSubmarket(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return action == SubmarketPlugin.TransferAction.PLAYER_SELL;
    }

    public boolean isIllegalOnSubmarket(String commodityId, SubmarketPlugin.TransferAction action) {
        return action == SubmarketPlugin.TransferAction.PLAYER_SELL;
    }

    public boolean isIllegalOnSubmarket(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        return action == SubmarketPlugin.TransferAction.PLAYER_SELL;
    }

    public float getTariff() {
        RepLevel level = this.submarket.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
        float mult = 1.0f;
        switch (level) {
            case NEUTRAL: {
                mult = 1.0f;
                break;
            }
            case FAVORABLE: {
                mult = 0.9f;
                break;
            }
            case WELCOMING: {
                mult = 0.75f;
                break;
            }
            case FRIENDLY: {
                mult = 0.65f;
                break;
            }
            case COOPERATIVE: {
                mult = 0.5f;
                break;
            }
            default: {
                mult = 1.0f;
            }
        }
        return mult * ExerelinConfig.prismTariff;
    }

    public void reportPlayerMarketTransaction(PlayerMarketTransaction transaction) {
        List shipsBought = transaction.getShipsBought();
        for (PlayerMarketTransaction.ShipSaleInfo saleInfo : shipsBought) {
            String id = saleInfo.getMember().getHullSpec().getBaseHullId();
            if (this.alreadyBoughtShips.contains(id)) continue;
            this.alreadyBoughtShips.add(id);
        }
        CargoAPI otherBought = transaction.getBought();
        for (CargoAPI.CargoItemQuantity quantity : otherBought.getFighters()) {
            String id = (String)quantity.getItem();
            if (this.alreadyBoughtShips.contains(id)) continue;
            this.alreadyBoughtShips.add(id);
        }
    }

    public String getIllegalTransferText(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        return ILLEGAL_TRANSFER_MESSAGE;
    }

    public String getIllegalTransferText(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return ILLEGAL_TRANSFER_MESSAGE;
    }

    public String getTooltipAppendix(CoreUIAPI ui) {
        if (!this.isEnabled(ui)) {
            String msg = StringHelper.getString("exerelin_markets", "prismRelTooLow");
            msg = StringHelper.substituteToken(msg, "$faction", this.submarket.getFaction().getDisplayName());
            msg = StringHelper.substituteToken(msg, "$minRelationship", MIN_STANDING.getDisplayName().toLowerCase());
            return msg;
        }
        return null;
    }

    public Highlights getTooltipAppendixHighlights(CoreUIAPI ui) {
        String appendix = this.getTooltipAppendix(ui);
        if (appendix == null) {
            return null;
        }
        Highlights h = new Highlights();
        h.setText(new String[]{appendix});
        h.setColors(new Color[]{Misc.getNegativeHighlightColor()});
        return h;
    }

    public boolean isEnabled(CoreUIAPI ui) {
        RepLevel level = this.submarket.getFaction().getRelationshipLevel(Global.getSector().getFaction("player"));
        return level.isAtWorst(MIN_STANDING);
    }

    public boolean isBlackMarket() {
        return false;
    }

    static {
        try {
            PrismMarket.setupBlacklists();
        }
        catch (IOException | JSONException ex) {
            log.error((Object)ex);
        }
    }

    public static class BossShipEntry {
        public String id;
        @Deprecated
        public int ibbNum;
        public String stage;

        public BossShipEntry(String id, int ibbNum, String stage) {
            this.id = id;
            this.ibbNum = ibbNum;
            this.stage = stage;
        }
    }
}

