/*
 * Decompiled with CFR 0.152.
 */
package exerelin.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleCreationPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.terrain.PulsarBeamTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.impl.combat.BattleCreationPluginImpl;
import com.fs.starfarer.api.impl.combat.EscapeRevealPlugin;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.world.SSP_AsteroidTracker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.Vector2f;

public class SSP_BattleCreationPluginImpl
implements BattleCreationPlugin {
    private static final float ASTEROID_MAX_DIST = 750.0f;
    private static final String COMM = "comm_relay";
    private static final String NAV = "nav_buoy";
    private static final float PLANET_MAX_DIST = 3000.0f;
    private static final String SENSOR = "sensor_array";
    private static final float SINGLE_PLANET_MAX_DIST = 1500.0f;
    private static final float STAR_MAX_DIST = 7500.0f;
    private BattleCreationContext context;
    private StarCoronaTerrainPlugin corona = null;
    private float coronaIntensity = 0.0f;
    private boolean escape;
    private float height;
    private MissionDefinitionAPI loader;
    private int nebulaLevel;
    private ArrayList<BattleObjective> objectives;
    private List<String> objs = null;
    private float prevXDir = 0.0f;
    private float prevYDir = 0.0f;
    private PulsarBeamTerrainPlugin pulsar = null;
    private float sizeMod;
    private float width;
    private float xPad = 2000.0f;
    private float yPad = 2000.0f;

    public static boolean isHyperspace(CampaignFleetAPI playerFleet) {
        return playerFleet.getContainingLocation() == Global.getSector().getHyperspace();
    }

    public static boolean isNearbyAsteroids(CampaignFleetAPI playerFleet) {
        float numAsteroidsWithinRange = SSP_BattleCreationPluginImpl.countNearbyAsteroids(playerFleet);
        if (playerFleet.getContainingLocation() == Global.getSector().getHyperspace()) {
            if (numAsteroidsWithinRange > 0.0f) {
                int numAsteroids = Math.min(100, (int)((numAsteroidsWithinRange + 1.0f) * 20.0f));
                return numAsteroids >= 200;
            }
            return false;
        }
        if (numAsteroidsWithinRange > 0.0f) {
            int numAsteroids = Math.min(200, (int)((numAsteroidsWithinRange + 1.0f) * 20.0f));
            return numAsteroids >= 300;
        }
        return false;
    }

    public static boolean isNearbyAsteroidsFast(CampaignFleetAPI playerFleet) {
        Vector2f asteroidVelocity = SSP_BattleCreationPluginImpl.getNearbyAsteroidsVelocity(playerFleet);
        if (asteroidVelocity.x != 0.0f || asteroidVelocity.y != 0.0f) {
            float asteroidSpeed = Math.min(50.0f, Math.max(10.0f, asteroidVelocity.length() * 1.5f));
            return asteroidSpeed >= 30.0f;
        }
        return false;
    }

    public static boolean isNearbyPlanet(CampaignFleetAPI playerFleet) {
        float amt = Math.min(1.0f, Math.max(0.6f, (float)Math.cbrt(SSP_BattleCreationPluginImpl.getNearbyPlanetFactor(playerFleet) / 3000.0f)));
        return amt <= 0.85f;
    }

    public static boolean isNearbyStar(CampaignFleetAPI playerFleet) {
        float amt = SSP_BattleCreationPluginImpl.getStarFactor(playerFleet);
        return amt >= 0.6f;
    }

    private static float countNearbyAsteroids(CampaignFleetAPI playerFleet) {
        float numAsteroidsWithinRange = 0.0f;
        float closest = Float.MAX_VALUE;
        LocationAPI loc = playerFleet.getContainingLocation();
        if (loc instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)loc;
            List asteroids = system.getAsteroids();
            for (SectorEntityToken asteroid : asteroids) {
                float range = Vector2f.sub((Vector2f)playerFleet.getLocation(), (Vector2f)asteroid.getLocation(), (Vector2f)new Vector2f()).length();
                if (!(range <= 750.0f)) continue;
                numAsteroidsWithinRange += 1.0f;
                if (!(range < closest)) continue;
                closest = range;
            }
        }
        return numAsteroidsWithinRange * (1.0f - closest / 750.0f);
    }

    private static Vector2f getNearbyAsteroidsVelocity(CampaignFleetAPI playerFleet) {
        Vector2f sumVec = new Vector2f();
        LocationAPI loc = playerFleet.getContainingLocation();
        int count = 0;
        if (loc instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)loc;
            List asteroids = system.getAsteroids();
            for (SectorEntityToken asteroid : asteroids) {
                float range = Vector2f.sub((Vector2f)playerFleet.getLocation(), (Vector2f)asteroid.getLocation(), (Vector2f)new Vector2f()).length();
                if (!(range <= 750.0f)) continue;
                Vector2f velocity = SSP_AsteroidTracker.getVelocity(asteroid);
                Vector2f.add((Vector2f)sumVec, (Vector2f)velocity, (Vector2f)sumVec);
                ++count;
            }
        }
        if (count > 0) {
            sumVec.scale(1.0f / (float)count);
        }
        return sumVec;
    }

    private static List<NearbyJumpPointData> getNearbyJumpPoints(CampaignFleetAPI playerFleet) {
        LocationAPI loc = playerFleet.getContainingLocation();
        ArrayList<NearbyJumpPointData> result = new ArrayList<NearbyJumpPointData>(10);
        List jumpPoints = loc.getEntitiesWithTag("jump_point");
        for (SectorEntityToken token : jumpPoints) {
            JumpPointAPI jumpPoint = (JumpPointAPI)token;
            Vector2f vector = Vector2f.sub((Vector2f)jumpPoint.getLocation(), (Vector2f)playerFleet.getLocation(), (Vector2f)new Vector2f());
            float range = vector.length();
            if (!(range <= 3000.0f)) continue;
            result.add(new NearbyJumpPointData(vector, jumpPoint));
        }
        return result;
    }

    private static float getNearbyPlanetFactor(CampaignFleetAPI playerFleet) {
        LocationAPI loc = playerFleet.getContainingLocation();
        float minDist = Float.MAX_VALUE;
        if (loc instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)loc;
            List planets = system.getPlanets();
            for (PlanetAPI planet : planets) {
                float dist;
                float adjustedDist;
                if (planet.isStar() || !((adjustedDist = ((dist = Vector2f.sub((Vector2f)playerFleet.getLocation(), (Vector2f)planet.getLocation(), (Vector2f)new Vector2f()).length()) + 150.0f + planet.getRadius()) * (150.0f / Math.max(50.0f, planet.getRadius()))) < minDist) || !(dist < 1500.0f)) continue;
                minDist = adjustedDist;
            }
        }
        return minDist;
    }

    private static List<NearbyPlanetData> getNearbyPlanets(CampaignFleetAPI playerFleet) {
        LocationAPI loc = playerFleet.getContainingLocation();
        ArrayList<NearbyPlanetData> result = new ArrayList<NearbyPlanetData>(10);
        if (loc instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)loc;
            List planets = system.getPlanets();
            for (PlanetAPI planet : planets) {
                Vector2f vector;
                float range;
                if (planet.isStar() || !((range = (vector = Vector2f.sub((Vector2f)planet.getLocation(), (Vector2f)playerFleet.getLocation(), (Vector2f)new Vector2f())).length()) <= 3000.0f)) continue;
                result.add(new NearbyPlanetData(vector, planet));
            }
        }
        return result;
    }

    private static List<NearbyPlanetData> getNearbyStars(CampaignFleetAPI playerFleet) {
        LocationAPI loc = playerFleet.getContainingLocation();
        ArrayList<NearbyPlanetData> result = new ArrayList<NearbyPlanetData>(2);
        if (loc instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)loc;
            List planets = system.getPlanets();
            for (PlanetAPI planet : planets) {
                if (!planet.isStar()) continue;
                Vector2f vector = Vector2f.sub((Vector2f)playerFleet.getLocation(), (Vector2f)planet.getLocation(), (Vector2f)new Vector2f());
                result.add(new NearbyPlanetData(vector, planet));
            }
        }
        return result;
    }

    private static float getStarFactor(CampaignFleetAPI playerFleet) {
        LocationAPI loc = playerFleet.getContainingLocation();
        float factor = 0.0f;
        if (loc instanceof StarSystemAPI) {
            StarSystemAPI system = (StarSystemAPI)loc;
            List planets = system.getPlanets();
            for (PlanetAPI planet : planets) {
                Vector2f vector;
                float range;
                if (!planet.isStar() || !((range = (vector = Vector2f.sub((Vector2f)playerFleet.getLocation(), (Vector2f)planet.getLocation(), (Vector2f)new Vector2f())).length() * (500.0f / Math.max(100.0f, planet.getRadius()))) <= 7500.0f)) continue;
                factor += 1.0f - range / 7500.0f;
            }
        }
        return factor;
    }

    private static String pickAny() {
        float r = (float)Math.random();
        if (r < 0.33f) {
            return NAV;
        }
        if (r < 0.67f) {
            return SENSOR;
        }
        return COMM;
    }

    public void afterDefinitionLoad(final CombatEngineAPI engine) {
        if (this.coronaIntensity > 0.0f && (this.corona != null || this.pulsar != null)) {
            String name = "Corona";
            if (this.pulsar != null) {
                name = this.pulsar.getTerrainName();
            } else if (this.corona != null) {
                name = this.corona.getTerrainName();
            }
            final String name2 = name;
            final Object key1 = new Object();
            final Object key2 = new Object();
            final String icon = Global.getSettings().getSpriteName("ui", "icon_tactical_cr_penalty");
            engine.addPlugin((EveryFrameCombatPlugin)new BaseEveryFrameCombatPlugin(){

                public void advance(float amount, List<InputEventAPI> events) {
                    engine.maintainStatusForPlayerShip(key1, icon, name2, "\u5cf0\u503c\u65f6\u95f4\u7f29\u77ed", true);
                    engine.maintainStatusForPlayerShip(key2, icon, name2, "\u6218\u5907\u503c\u6d88\u8017\u901f\u5ea6\u52a0\u5feb", true);
                }
            });
        }
    }

    public void initBattle(BattleCreationContext context, MissionDefinitionAPI loader) {
        boolean withObjectives;
        this.context = context;
        this.loader = loader;
        this.objectives = new ArrayList(5);
        CampaignFleetAPI playerFleet = context.getPlayerFleet();
        CampaignFleetAPI otherFleet = context.getOtherFleet();
        FleetGoal playerGoal = context.getPlayerGoal();
        FleetGoal enemyGoal = context.getOtherGoal();
        this.escape = playerGoal == FleetGoal.ESCAPE || enemyGoal == FleetGoal.ESCAPE;
        int maxFP = (int)Global.getSettings().getFloat("maxNoObjectiveBattleSize");
        int fpOne = 0;
        int fpTwo = 0;
        for (FleetMemberAPI member : playerFleet.getFleetData().getMembersListCopy()) {
            if (!member.canBeDeployedForCombat() && playerGoal != FleetGoal.ESCAPE) continue;
            fpOne = (int)((float)fpOne + member.getDeploymentPointsCost());
        }
        for (FleetMemberAPI member : otherFleet.getFleetData().getMembersListCopy()) {
            if (!member.canBeDeployedForCombat() && playerGoal != FleetGoal.ESCAPE) continue;
            fpTwo = (int)((float)fpTwo + member.getDeploymentPointsCost());
        }
        int smaller = Math.min(fpOne, fpTwo);
        boolean bl = withObjectives = smaller > maxFP;
        if (!context.objectivesAllowed) {
            withObjectives = false;
        }
        int numObjectives = 0;
        if (withObjectives) {
            numObjectives = fpOne + fpTwo > maxFP + 480 ? 5 + (int)(Math.random() * 3.0) : (fpOne + fpTwo > maxFP + 320 ? 4 + (int)(Math.random() * 2.0) : (fpOne + fpTwo > maxFP + 180 ? 3 + (int)(Math.random() * 2.0) : (fpOne + fpTwo > maxFP + 80 ? 2 + (int)(Math.random() * 2.0) : 1 + (int)(Math.random() * 2.0))));
        }
        if (context.getPlayerFleet().getContainingLocation() == Global.getSector().getHyperspace()) {
            --numObjectives;
        }
        if (numObjectives > 6) {
            numObjectives = 6;
        }
        if (numObjectives > 4 && this.escape) {
            numObjectives = 4;
        }
        if (numObjectives == 1) {
            numObjectives = 2;
        }
        if (numObjectives < 2 && this.escape) {
            numObjectives = 2;
        }
        int baseCommandPoints = (int)Global.getSettings().getFloat("startingCommandPoints");
        loader.initFleet(FleetSide.PLAYER, "ISS", playerGoal, false, context.getPlayerCommandPoints() - baseCommandPoints, (int)playerFleet.getCommanderStats().getCommandPoints().getModifiedValue() - baseCommandPoints);
        loader.initFleet(FleetSide.ENEMY, "", enemyGoal, true, (int)otherFleet.getCommanderStats().getCommandPoints().getModifiedValue() - baseCommandPoints);
        List playerShips = playerFleet.getFleetData().getCombatReadyMembersListCopy();
        if (playerGoal == FleetGoal.ESCAPE) {
            playerShips = playerFleet.getFleetData().getMembersListCopy();
        }
        for (Object member : playerShips) {
            loader.addFleetMember(FleetSide.PLAYER, (FleetMemberAPI)member);
        }
        List enemyShips = otherFleet.getFleetData().getCombatReadyMembersListCopy();
        if (enemyGoal == FleetGoal.ESCAPE) {
            enemyShips = otherFleet.getFleetData().getMembersListCopy();
        }
        for (FleetMemberAPI member : enemyShips) {
            loader.addFleetMember(FleetSide.ENEMY, member);
        }
        float heightMod = context.getPlayerFleet().getContainingLocation() == Global.getSector().getHyperspace() ? 1.0f + 0.5f * (float)(Math.random() * Math.random()) : Math.min(1.2f, Math.min(1.0f, Math.max(0.6f, (float)Math.cbrt(SSP_BattleCreationPluginImpl.getNearbyPlanetFactor(context.getPlayerFleet()) / 3000.0f))) * (1.25f + 0.25f * (float)Math.random()));
        float widthMod = 1.0f / (float)Math.sqrt(heightMod);
        this.width = 18000.0f * widthMod;
        this.height = 18000.0f * heightMod;
        if (this.escape) {
            if (numObjectives <= 2) {
                this.width = 12000.0f;
                this.height = 14000.0f;
            } else if (numObjectives <= 4) {
                this.width = 14000.0f;
                this.height = 18000.0f;
            } else {
                this.width = 16000.0f;
                this.height = 22000.0f;
            }
            this.xPad = 2000.0f;
            this.yPad = 4000.0f;
        } else if (withObjectives) {
            if (numObjectives == 2) {
                this.width = 20000.0f * widthMod;
                this.height = 16000.0f * heightMod;
            } else if (numObjectives <= 4) {
                this.width = 22000.0f * widthMod;
                this.height = 18000.0f * heightMod;
            } else {
                this.width = 24000.0f * widthMod;
                this.height = 20000.0f * heightMod;
            }
            this.xPad = 2000.0f;
            this.yPad = 3000.0f;
        }
        float distanceMod = 1.0f;
        if (this.escape) {
            int escapingFP = playerGoal == FleetGoal.ESCAPE ? context.getPlayerFleet().getFleetPoints() : context.getOtherFleet().getFleetPoints();
            int pursuingFP = playerGoal == FleetGoal.ESCAPE ? context.getOtherFleet().getFleetPoints() : context.getPlayerFleet().getFleetPoints();
            distanceMod = (float)Math.sqrt((float)pursuingFP / (Math.max((float)escapingFP, 10.0f) * 1.25f));
            if (playerGoal == FleetGoal.ESCAPE) {
                distanceMod *= 1.25f;
            }
            distanceMod = Math.max(Math.min(distanceMod, 3.0f), 1.0f);
            this.height += 4000.0f * (distanceMod - 1.0f);
        }
        this.sizeMod = this.width / 18000.0f * (this.height / 18000.0f);
        this.createMap();
        context.setInitialDeploymentBurnDuration(1.5f);
        context.setNormalDeploymentBurnDuration(6.0f);
        context.setEscapeDeploymentBurnDuration(1.5f);
        if (this.escape) {
            this.addEscapeObjectives(numObjectives);
            context.setInitialEscapeRange(4000.0f * distanceMod);
            context.setFlankDeploymentDistance(8000.0f);
            loader.addPlugin((EveryFrameCombatPlugin)new EscapeRevealPlugin(context));
        } else if (withObjectives) {
            this.addObjectives(numObjectives);
            context.setStandoffRange(this.height - 4500.0f);
        } else {
            context.setStandoffRange(6000.0f);
        }
    }

    private void addEscapeObjectives(int num) {
        this.objs = new ArrayList<String>(Arrays.asList(SENSOR, SENSOR, NAV, NAV, COMM));
        if (num == 2) {
            float r = (float)Math.random();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.25f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.75f, 1.0f, 1.0f);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.75f, 0.25f, 1.0f, 1.0f);
                this.addObjectiveAt(0.25f, 0.75f, 1.0f, 1.0f);
            } else {
                this.addObjectiveAt(0.5f, 0.25f, 4.0f, 2.0f);
                this.addObjectiveAt(0.5f, 0.75f, 4.0f, 2.0f);
            }
        } else if (num == 3) {
            float r = (float)Math.random();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.75f, 1.0f, 1.0f);
                this.addObjectiveAt(0.25f, 0.25f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.5f, 1.0f, 6.0f);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.25f, 0.5f, 1.0f, 6.0f);
                this.addObjectiveAt(0.75f, 0.75f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.25f, 1.0f, 1.0f);
            } else {
                this.addObjectiveAt(0.5f, 0.25f, 4.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.5f, 4.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.75f, 4.0f, 1.0f);
            }
        } else if (num == 4) {
            float r = (float)Math.random();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.25f, 1.0f, 1.0f);
                this.addObjectiveAt(0.25f, 0.75f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.25f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.75f, 1.0f, 1.0f);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.35f, 0.25f, 2.0f, 0.0f);
                this.addObjectiveAt(0.65f, 0.35f, 2.0f, 0.0f);
                this.addObjectiveAt(0.5f, 0.6f, 4.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.8f, 4.0f, 1.0f);
            } else {
                this.addObjectiveAt(0.65f, 0.25f, 2.0f, 0.0f);
                this.addObjectiveAt(0.35f, 0.35f, 2.0f, 0.0f);
                this.addObjectiveAt(0.5f, 0.6f, 4.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.8f, 4.0f, 1.0f);
            }
        } else if (num == 5) {
            float r = (float)Math.random();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.25f, 1.0f, 1.0f);
                this.addObjectiveAt(0.25f, 0.75f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.25f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.75f, 1.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.5f, 1.0f, 1.0f);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.25f, 0.45f, 2.0f, 0.0f);
                this.addObjectiveAt(0.75f, 0.35f, 2.0f, 0.0f);
                this.addObjectiveAt(0.5f, 0.6f, 4.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.8f, 4.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.25f, 2.0f, 0.0f);
            } else {
                this.addObjectiveAt(0.75f, 0.45f, 2.0f, 0.0f);
                this.addObjectiveAt(0.25f, 0.35f, 2.0f, 0.0f);
                this.addObjectiveAt(0.5f, 0.6f, 4.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.8f, 4.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.25f, 2.0f, 0.0f);
            }
        }
    }

    private void addMultiplePlanets() {
        float distanceSquared;
        float bgWidth = this.width / 17.5f;
        float bgHeight = this.height / 17.5f;
        List<NearbyPlanetData> planets = SSP_BattleCreationPluginImpl.getNearbyPlanets(this.context.getPlayerFleet());
        List<NearbyJumpPointData> jumpPoints = SSP_BattleCreationPluginImpl.getNearbyJumpPoints(this.context.getPlayerFleet());
        float closestSquared = Float.MAX_VALUE;
        PlanetAPI closest = null;
        for (NearbyPlanetData nearbyPlanetData : planets) {
            distanceSquared = nearbyPlanetData.offset.lengthSquared();
            if (!(distanceSquared < closestSquared)) continue;
            closestSquared = distanceSquared;
            closest = nearbyPlanetData.planet;
        }
        for (NearbyJumpPointData nearbyJumpPointData : jumpPoints) {
            distanceSquared = nearbyJumpPointData.offset.lengthSquared();
            if (!(distanceSquared < closestSquared)) continue;
            closestSquared = distanceSquared;
            closest = nearbyJumpPointData.jumpPoint;
        }
        JumpPointAPI biggestJumpPoint = null;
        float f = 0.0f;
        for (NearbyJumpPointData data : jumpPoints) {
            float size = data.jumpPoint.getRadius();
            if (!(size > f)) continue;
            f = size;
            biggestJumpPoint = data.jumpPoint;
        }
        if (!(planets.isEmpty() && jumpPoints.isEmpty() || closest == null)) {
            float locY;
            float locX;
            float otherDist;
            float radius;
            float f2;
            float maxRadius;
            float distanceFactor;
            float scaleFactor;
            float baseRadius;
            float dist;
            this.loader.setPlanetBgSize(bgWidth, bgHeight);
            float maxDist = 3000.0f;
            for (NearbyPlanetData data : planets) {
                dist = Vector2f.sub((Vector2f)this.context.getPlayerFleet().getLocation(), (Vector2f)data.planet.getLocation(), (Vector2f)new Vector2f()).length();
                baseRadius = data.planet.getRadius();
                scaleFactor = 1.5f;
                distanceFactor = 1.0f;
                maxRadius = 500.0f;
                f2 = (maxDist - dist) / maxDist * 0.65f + 0.35f;
                radius = baseRadius * f2 * scaleFactor;
                if (data.planet != closest) {
                    otherDist = Vector2f.sub((Vector2f)closest.getLocation(), (Vector2f)data.planet.getLocation(), (Vector2f)new Vector2f()).length();
                    radius *= (maxDist - otherDist) / maxDist * 0.65f + 0.35f;
                }
                if (radius > maxRadius) {
                    radius = maxRadius;
                }
                locX = data.offset.x * distanceFactor;
                locY = data.offset.y * distanceFactor;
                this.loader.addPlanet(locX, locY, radius, data.planet.getTypeId(), 0.0f, true);
            }
            for (NearbyJumpPointData data : jumpPoints) {
                dist = Vector2f.sub((Vector2f)this.context.getPlayerFleet().getLocation(), (Vector2f)data.jumpPoint.getLocation(), (Vector2f)new Vector2f()).length();
                baseRadius = data.jumpPoint.getRadius();
                scaleFactor = 1.5f;
                distanceFactor = 1.0f;
                maxRadius = 500.0f;
                f2 = (maxDist - dist) / maxDist * 0.65f + 0.35f;
                radius = baseRadius * f2 * scaleFactor;
                if (data.jumpPoint != closest) {
                    otherDist = Vector2f.sub((Vector2f)closest.getLocation(), (Vector2f)data.jumpPoint.getLocation(), (Vector2f)new Vector2f()).length();
                    radius *= (maxDist - otherDist) / maxDist * 0.65f + 0.35f;
                }
                if (radius > maxRadius) {
                    radius = maxRadius;
                }
                locX = data.offset.x * distanceFactor;
                locY = data.offset.y * distanceFactor;
                this.loader.addPlanet(locX, locY, radius, "wormholeUnder", 0.0f, true);
                this.loader.addPlanet(locX, locY, radius, "wormholeA", 0.0f, true);
                this.loader.addPlanet(locX, locY, radius, "wormholeB", 0.0f, true);
                this.loader.addPlanet(locX, locY, radius, "wormholeC", 0.0f, true);
            }
        }
    }

    private void addObjectiveAt(float xMult, float yMult, float xOff, float yOff) {
        String type = SSP_BattleCreationPluginImpl.pickAny();
        if (this.objs != null && this.objs.size() > 0) {
            int index = (int)(Math.random() * (double)this.objs.size());
            type = this.objs.remove(index);
        }
        float minX = -this.width / 2.0f + this.xPad;
        float minY = -this.height / 2.0f + this.yPad;
        float x = (this.width - this.xPad * 2.0f) * xMult + minX;
        float y = (this.height - this.yPad * 2.0f) * yMult + minY;
        x = (float)((int)x / 1000) * 1000.0f;
        y = (float)((int)y / 1000) * 1000.0f;
        float offsetX = (float)Math.round((Math.random() - 0.5) * (double)xOff * 2.0) * 1000.0f;
        float offsetY = (float)Math.round((Math.random() - 0.5) * (double)yOff * 2.0) * 1000.0f;
        float xDir = Math.signum(offsetX);
        float yDir = Math.signum(offsetY);
        if (xDir == this.prevXDir && xOff > 0.0f) {
            xDir = -xDir;
            offsetX = Math.abs(offsetX) * -this.prevXDir;
        }
        if (yDir == this.prevYDir && yOff > 0.0f) {
            yDir = -yDir;
            offsetY = Math.abs(offsetY) * -this.prevYDir;
        }
        this.prevXDir = xDir;
        this.prevYDir = yDir;
        x += offsetX;
        y += offsetY;
        for (BattleObjective objective : this.objectives) {
            Vector2f vector2f = new Vector2f(x, y);
            Vector2f vector2f2 = new Vector2f(objective.x, objective.y);
            if (!(MathUtils.getDistance((Vector2f)vector2f, (Vector2f)vector2f2) <= 1000.0f)) continue;
            return;
        }
        this.loader.addObjective(x, y, type);
        this.objectives.add(new BattleObjective(x, y, type));
        if (Math.random() * Math.sqrt((float)this.nebulaLevel / 100.0f) > 0.6) {
            float nebulaSize = (float)Math.random() * 1500.0f + 500.0f;
            this.loader.addNebula(x, y, nebulaSize);
        }
    }

    private void addObjectives(int num) {
        this.objs = new ArrayList<String>(Arrays.asList(SENSOR, SENSOR, NAV, NAV, COMM, COMM));
        if (num == 2) {
            this.objs = new ArrayList<String>(Arrays.asList(SENSOR, SENSOR, NAV, NAV, COMM));
            this.addObjectiveAt(0.25f, 0.5f, 0.0f, 0.0f);
            this.addObjectiveAt(0.75f, 0.5f, 0.0f, 0.0f);
        } else if (num == 3) {
            float r = (float)Math.random();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.7f, 1.0f, 1.0f);
                this.addObjectiveAt(0.25f, 0.3f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.5f, 1.0f, 1.0f);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.25f, 0.7f, 1.0f, 1.0f);
                this.addObjectiveAt(0.25f, 0.3f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.7f, 1.0f, 1.0f);
            } else {
                this.addObjectiveAt(0.25f, 0.5f, 1.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.5f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.5f, 1.0f, 1.0f);
            }
        } else if (num == 4) {
            float r = (float)Math.random();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.25f, 2.0f, 1.0f);
                this.addObjectiveAt(0.25f, 0.75f, 2.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.25f, 2.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.75f, 2.0f, 1.0f);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.25f, 0.5f, 1.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.75f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.5f, 1.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.25f, 1.0f, 1.0f);
            } else {
                this.addObjectiveAt(0.2f, 0.5f, 1.0f, 2.0f);
                this.addObjectiveAt(0.4f, 0.5f, 0.0f, 3.0f);
                this.addObjectiveAt(0.6f, 0.5f, 0.0f, 3.0f);
                this.addObjectiveAt(0.8f, 0.5f, 1.0f, 2.0f);
            }
        } else if (num == 5) {
            float r = (float)Math.random();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.25f, 2.0f, 1.0f);
                this.addObjectiveAt(0.25f, 0.75f, 2.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.25f, 2.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.75f, 2.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.5f, 2.0f, 1.0f);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.25f, 0.5f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.5f, 1.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.25f, 2.0f, 0.0f);
                this.addObjectiveAt(0.5f, 0.75f, 2.0f, 0.0f);
                this.addObjectiveAt(0.5f, 0.5f, 1.0f, 1.0f);
            } else {
                this.addObjectiveAt(0.2f, 0.5f, 1.0f, 2.0f);
                this.addObjectiveAt(0.35f, 0.5f, 0.0f, 3.0f);
                this.addObjectiveAt(0.65f, 0.5f, 0.0f, 3.0f);
                this.addObjectiveAt(0.8f, 0.5f, 1.0f, 2.0f);
                this.addObjectiveAt(0.5f, 0.5f, 0.0f, 5.0f);
            }
        } else if (num == 6) {
            float r = (float)Math.random();
            if (r < 0.33f) {
                this.addObjectiveAt(0.25f, 0.25f, 2.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.25f, 2.0f, 1.0f);
                this.addObjectiveAt(0.25f, 0.5f, 2.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.5f, 2.0f, 1.0f);
                this.addObjectiveAt(0.25f, 0.75f, 2.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.75f, 2.0f, 1.0f);
            } else if (r < 0.67f) {
                this.addObjectiveAt(0.25f, 0.5f, 1.0f, 1.0f);
                this.addObjectiveAt(0.75f, 0.5f, 1.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.2f, 1.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.4f, 1.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.6f, 1.0f, 1.0f);
                this.addObjectiveAt(0.5f, 0.8f, 1.0f, 1.0f);
            } else {
                this.addObjectiveAt(0.25f, 0.25f, 1.0f, 2.0f);
                this.addObjectiveAt(0.25f, 0.75f, 1.0f, 2.0f);
                this.addObjectiveAt(0.4f, 0.5f, 0.0f, 3.0f);
                this.addObjectiveAt(0.6f, 0.5f, 0.0f, 3.0f);
                this.addObjectiveAt(0.75f, 0.25f, 1.0f, 2.0f);
                this.addObjectiveAt(0.75f, 0.75f, 1.0f, 2.0f);
            }
        }
    }

    private void createMap() {
        float asteroidSpeed;
        float asteroidDirection;
        this.loader.initMap(-this.width / 2.0f, this.width / 2.0f, -this.height / 2.0f, this.height / 2.0f);
        CampaignFleetAPI playerFleet = this.context.getPlayerFleet();
        String nebulaTex = null;
        String nebulaMapTex = null;
        boolean inNebula = false;
        float numRings = 0.0f;
        Color coronaColor = null;
        for (CampaignTerrainAPI terrain : playerFleet.getContainingLocation().getTerrainCopy()) {
            int alpha;
            float intensity;
            Color color;
            float angle;
            StarCoronaTerrainPlugin plugin;
            if (terrain.getPlugin() instanceof BattleCreationPluginImpl.NebulaTextureProvider) {
                BattleCreationPluginImpl.NebulaTextureProvider provider;
                if (terrain.getPlugin().containsEntity((SectorEntityToken)playerFleet)) {
                    inNebula = true;
                    if (!(terrain.getPlugin() instanceof BattleCreationPluginImpl.NebulaTextureProvider)) continue;
                    provider = (BattleCreationPluginImpl.NebulaTextureProvider)terrain.getPlugin();
                    nebulaTex = provider.getNebulaTex();
                    nebulaMapTex = provider.getNebulaMapTex();
                    continue;
                }
                if (nebulaTex != null || !(terrain.getPlugin() instanceof BattleCreationPluginImpl.NebulaTextureProvider)) continue;
                provider = (BattleCreationPluginImpl.NebulaTextureProvider)terrain.getPlugin();
                nebulaTex = provider.getNebulaTex();
                nebulaMapTex = provider.getNebulaMapTex();
                continue;
            }
            if (terrain.getPlugin() instanceof StarCoronaTerrainPlugin && this.pulsar == null) {
                plugin = (StarCoronaTerrainPlugin)terrain.getPlugin();
                if (!plugin.containsEntity((SectorEntityToken)playerFleet)) continue;
                angle = Misc.getAngleInDegrees((Vector2f)terrain.getLocation(), (Vector2f)playerFleet.getLocation());
                color = plugin.getAuroraColorForAngle(angle);
                intensity = plugin.getIntensityAtPoint(playerFleet.getLocation());
                intensity = 0.4f + 0.6f * intensity;
                alpha = (int)(80.0f * intensity);
                color = Misc.setAlpha((Color)color, (int)alpha);
                if (coronaColor != null && coronaColor.getAlpha() >= alpha) continue;
                coronaColor = color;
                this.coronaIntensity = intensity;
                this.corona = plugin;
                continue;
            }
            if (terrain.getPlugin() instanceof PulsarBeamTerrainPlugin) {
                plugin = (PulsarBeamTerrainPlugin)terrain.getPlugin();
                if (!plugin.containsEntity((SectorEntityToken)playerFleet)) continue;
                angle = Misc.getAngleInDegreesStrict((Vector2f)terrain.getLocation(), (Vector2f)playerFleet.getLocation());
                color = plugin.getPulsarColorForAngle(angle);
                intensity = plugin.getIntensityAtPoint(playerFleet.getLocation());
                intensity = 0.4f + 0.6f * intensity;
                alpha = (int)(80.0f * intensity);
                color = Misc.setAlpha((Color)color, (int)alpha);
                if (coronaColor != null && coronaColor.getAlpha() >= alpha) continue;
                coronaColor = color;
                this.coronaIntensity = intensity;
                this.pulsar = plugin;
                this.corona = null;
                continue;
            }
            if (!terrain.getType().equals("ring") || !terrain.getPlugin().containsEntity((SectorEntityToken)playerFleet)) continue;
            numRings += 1.0f;
        }
        if (nebulaTex != null) {
            this.loader.setNebulaTex(nebulaTex);
            this.loader.setNebulaMapTex(nebulaMapTex);
        }
        if (coronaColor != null) {
            this.loader.setBackgroundGlowColor(coronaColor);
        }
        this.nebulaLevel = 15;
        if (inNebula) {
            this.nebulaLevel = 100;
        }
        if (!inNebula && playerFleet.isInHyperspace()) {
            this.nebulaLevel = 0;
        }
        for (int i = 0; i < this.nebulaLevel; ++i) {
            float x = (float)Math.random() * this.width - this.width / 2.0f;
            float y = (float)Math.random() * this.height - this.height / 2.0f;
            float radius = 100.0f + (float)Math.random() * 400.0f;
            if (inNebula) {
                radius += 100.0f + 500.0f * (float)Math.random();
            }
            this.loader.addNebula(x, y, radius);
        }
        float numAsteroidsWithinRange = SSP_BattleCreationPluginImpl.countNearbyAsteroids(playerFleet);
        int numAsteroids = this.context.getPlayerFleet().getContainingLocation() == Global.getSector().getHyperspace() ? (numAsteroidsWithinRange > 0.0f ? Math.min(100, (int)((numAsteroidsWithinRange + 1.0f) * 20.0f)) : 0) : (numAsteroidsWithinRange > 0.0f ? Math.min(200, (int)((numAsteroidsWithinRange + 1.0f) * 20.0f)) : (Math.random() > 0.5 ? (int)(Math.random() * 200.0) : 0));
        numAsteroids = (int)((float)numAsteroids * this.sizeMod);
        Vector2f asteroidVelocity = SSP_BattleCreationPluginImpl.getNearbyAsteroidsVelocity(this.context.getPlayerFleet());
        if (asteroidVelocity.x != 0.0f || asteroidVelocity.y != 0.0f) {
            asteroidDirection = VectorUtils.getFacing((Vector2f)asteroidVelocity);
            asteroidSpeed = Math.min(50.0f, Math.max(10.0f, asteroidVelocity.length() * 1.5f));
        } else {
            asteroidDirection = (float)Math.random() * 360.0f;
            asteroidSpeed = (float)Math.random() * 5.0f + 5.0f;
        }
        if (numAsteroids > 0) {
            this.loader.addAsteroidField(0.0f, 0.0f, asteroidDirection, Math.max(this.width, this.height), asteroidSpeed * 1.5f, asteroidSpeed * 3.0f + 40.0f, numAsteroids);
        }
        if (numRings > 0.0f) {
            int numRingAsteroids = (int)(numRings * 300.0f + numRings * 600.0f * (float)Math.random());
            if (numRingAsteroids > 1500) {
                numRingAsteroids = 1500;
            }
            this.loader.addRingAsteroids(0.0f, 0.0f, (float)Math.random() * 360.0f, this.width, 100.0f, 200.0f, numRingAsteroids);
        }
        this.loader.setBackgroundSpriteName(playerFleet.getContainingLocation().getBackgroundTextureFilename());
        if (playerFleet.getContainingLocation() == Global.getSector().getHyperspace()) {
            this.loader.setHyperspaceMode(true);
        } else {
            this.loader.setHyperspaceMode(false);
        }
        this.addMultiplePlanets();
    }

    private static class NearbyPlanetData {
        final Vector2f offset;
        final PlanetAPI planet;

        NearbyPlanetData(Vector2f offset, PlanetAPI planet) {
            this.offset = offset;
            this.planet = planet;
        }
    }

    private static class NearbyJumpPointData {
        final JumpPointAPI jumpPoint;
        final Vector2f offset;

        NearbyJumpPointData(Vector2f offset, JumpPointAPI jumpPoint) {
            this.offset = offset;
            this.jumpPoint = jumpPoint;
        }
    }

    private static class BattleObjective {
        String type;
        float x;
        float y;

        BattleObjective(float x, float y, String type) {
            this.x = x;
            this.y = y;
            this.type = type;
        }
    }
}

