/*
 * Decompiled with CFR 0.152.
 */
package exerelin.console.commands;

import com.fs.starfarer.api.campaign.FactionAPI;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.alliances.Alliance;
import exerelin.utilities.ExerelinUtils;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.CommandUtils;
import org.lazywizard.console.Console;

public class CreateAlliance
implements BaseCommand {
    public BaseCommand.CommandResult runCommand(String args, BaseCommand.CommandContext context) {
        if (context != BaseCommand.CommandContext.CAMPAIGN_MAP) {
            Console.showMessage((String)"Error: This command is campaign-only.");
            return BaseCommand.CommandResult.WRONG_CONTEXT;
        }
        if (args.isEmpty()) {
            return BaseCommand.CommandResult.BAD_SYNTAX;
        }
        String[] tmp = args.split(" ");
        if (tmp.length < 2) {
            return BaseCommand.CommandResult.BAD_SYNTAX;
        }
        String faction1 = tmp[0];
        String faction2 = tmp[1];
        Alliance.Alignment alignment = (Alliance.Alignment)((Object)ExerelinUtils.getRandomArrayElement((Object[])Alliance.Alignment.values()));
        if (tmp.length == 3) {
            try {
                alignment = Alliance.Alignment.valueOf(tmp[2].toUpperCase());
            }
            catch (Exception ex) {
                Console.showMessage((String)"Error: invalid alignment for alliance!");
                return BaseCommand.CommandResult.BAD_SYNTAX;
            }
        }
        if (faction1.equals("player") || faction2.equals("player")) {
            Console.showMessage((String)"Error: player faction not supported for alliances!");
            Console.showMessage((String)"(player_npc works as long as the faction is alive)");
            return BaseCommand.CommandResult.ERROR;
        }
        FactionAPI fac1 = CommandUtils.findBestFactionMatch((String)faction1);
        FactionAPI fac2 = CommandUtils.findBestFactionMatch((String)faction2);
        if (fac1 == null) {
            Console.showMessage((String)("Error: no such faction '" + faction1 + "'!"));
            return BaseCommand.CommandResult.ERROR;
        }
        if (fac2 == null) {
            Console.showMessage((String)("Error: no such faction '" + faction2 + "'!"));
            return BaseCommand.CommandResult.ERROR;
        }
        AllianceManager.createAlliance(fac1.getId(), fac2.getId(), alignment);
        Console.showMessage((String)("Created " + alignment.toString().toLowerCase() + " alliance between " + CommandUtils.getFactionName((FactionAPI)fac1) + " and " + CommandUtils.getFactionName((FactionAPI)fac2)));
        return BaseCommand.CommandResult.SUCCESS;
    }
}

