/*
 * Decompiled with CFR 0.152.
 */
package exerelin.console.commands;

import com.fs.starfarer.api.campaign.FactionAPI;
import exerelin.campaign.DiplomacyManager;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.CommandUtils;
import org.lazywizard.console.Console;

public class CreateDiplomacyEvent
implements BaseCommand {
    public BaseCommand.CommandResult runCommand(String args, BaseCommand.CommandContext context) {
        if (context != BaseCommand.CommandContext.CAMPAIGN_MAP) {
            Console.showMessage((String)"Error: This command is campaign-only.");
            return BaseCommand.CommandResult.WRONG_CONTEXT;
        }
        if (args.isEmpty()) {
            return BaseCommand.CommandResult.BAD_SYNTAX;
        }
        String[] tmp = args.split(" ");
        if (tmp.length < 2) {
            return BaseCommand.CommandResult.BAD_SYNTAX;
        }
        String faction1 = tmp[0];
        String faction2 = tmp[1];
        FactionAPI fac1 = CommandUtils.findBestFactionMatch((String)faction1);
        FactionAPI fac2 = CommandUtils.findBestFactionMatch((String)faction2);
        if (fac1 == null) {
            Console.showMessage((String)("Error: no such faction '" + faction1 + "'!"));
            return BaseCommand.CommandResult.ERROR;
        }
        if (fac2 == null) {
            Console.showMessage((String)("Error: no such faction '" + faction2 + "'!"));
            return BaseCommand.CommandResult.ERROR;
        }
        String eventId = null;
        if (tmp.length >= 3) {
            eventId = tmp[2];
        }
        DiplomacyManager.createDiplomacyEvent(fac1, fac2, eventId);
        Console.showMessage((String)("Creating diplomacy event between " + CommandUtils.getFactionName((FactionAPI)fac1) + " and " + CommandUtils.getFactionName((FactionAPI)fac2)));
        return BaseCommand.CommandResult.SUCCESS;
    }
}

