/*
 * Decompiled with CFR 0.152.
 */
package exerelin.console.commands;

import com.fs.starfarer.api.campaign.FactionAPI;
import exerelin.campaign.AllianceManager;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.CommandUtils;
import org.lazywizard.console.Console;

public class LeaveAlliance
implements BaseCommand {
    public BaseCommand.CommandResult runCommand(String args, BaseCommand.CommandContext context) {
        if (context != BaseCommand.CommandContext.CAMPAIGN_MAP) {
            Console.showMessage((String)"Error: This command is campaign-only.");
            return BaseCommand.CommandResult.WRONG_CONTEXT;
        }
        if (args.isEmpty()) {
            return BaseCommand.CommandResult.BAD_SYNTAX;
        }
        String[] tmp = args.split(" ");
        if (tmp.length < 1) {
            return BaseCommand.CommandResult.BAD_SYNTAX;
        }
        String faction = tmp[0];
        FactionAPI fac = CommandUtils.findBestFactionMatch((String)faction);
        if (fac == null) {
            Console.showMessage((String)("Error: no such faction '" + faction + "'!"));
            return BaseCommand.CommandResult.ERROR;
        }
        AllianceManager.leaveAlliance(faction, false);
        Console.showMessage((String)(CommandUtils.getFactionName((FactionAPI)fac) + " has left their alliance (if any)."));
        return BaseCommand.CommandResult.SUCCESS;
    }
}

