/*
 * Decompiled with CFR 0.152.
 */
package exerelin.console.commands;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.Console;
import org.lwjgl.util.vector.Vector2f;

public class PingDistance
implements BaseCommand {
    public BaseCommand.CommandResult runCommand(String args, BaseCommand.CommandContext context) {
        if (context != BaseCommand.CommandContext.CAMPAIGN_MAP) {
            Console.showMessage((String)"Error: This command is campaign-only.");
            return BaseCommand.CommandResult.WRONG_CONTEXT;
        }
        SectorAPI sector = Global.getSector();
        CampaignFleetAPI playerFleet = sector.getPlayerFleet();
        List markets = Misc.getMarketsInLocation((LocationAPI)playerFleet.getContainingLocation());
        Vector2f playerPos = playerFleet.getLocation();
        MarketAPI closestTargetMarket = null;
        float closestTargetDist = 9999999.0f;
        for (MarketAPI market : markets) {
            float distance = Misc.getDistance((Vector2f)playerPos, (Vector2f)market.getPrimaryEntity().getLocation());
            if (!(distance < closestTargetDist)) continue;
            closestTargetDist = distance;
            closestTargetMarket = market;
        }
        if (closestTargetMarket == null) {
            Console.showMessage((String)"Unable to find target");
            return BaseCommand.CommandResult.ERROR;
        }
        Console.showMessage((String)("Distance to " + closestTargetMarket.getName() + ": " + closestTargetDist));
        return BaseCommand.CommandResult.SUCCESS;
    }
}

