/*
 * Decompiled with CFR 0.152.
 */
package exerelin.console.commands;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import exerelin.utilities.ExerelinUtilsMarket;
import java.util.Collection;
import java.util.List;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.CommandUtils;
import org.lazywizard.console.Console;

public class PrintProductionInfo
implements BaseCommand {
    public BaseCommand.CommandResult runCommand(String args, BaseCommand.CommandContext context) {
        String commodityID;
        if (context != BaseCommand.CommandContext.CAMPAIGN_MAP) {
            Console.showMessage((String)"Error: This command is campaign-only.");
            return BaseCommand.CommandResult.WRONG_CONTEXT;
        }
        if (args.isEmpty()) {
            return BaseCommand.CommandResult.BAD_SYNTAX;
        }
        String[] tmp = args.split(" ");
        if (tmp.length < 2) {
            return BaseCommand.CommandResult.BAD_SYNTAX;
        }
        SectorAPI sector = Global.getSector();
        String targetName = tmp[0];
        List entitiesToSearch = sector.getEntitiesWithTag("planet");
        entitiesToSearch.addAll(sector.getEntitiesWithTag("station"));
        SectorEntityToken target = CommandUtils.findBestTokenMatch((String)targetName, (Collection)entitiesToSearch);
        if (target == null) {
            Console.showMessage((String)("Error: could not find entity with name '" + targetName + "'!"));
            return BaseCommand.CommandResult.ERROR;
        }
        MarketAPI market = target.getMarket();
        if (market == null) {
            Console.showMessage((String)("Error: entity '" + target.getName() + "' does not have a market"));
            return BaseCommand.CommandResult.ERROR;
        }
        switch (commodityID = tmp[1]) {
            case "fuel": {
                float organicsMet = ExerelinUtilsMarket.getCommodityDemandFractionMet(market, "organics", true);
                float volatilesMet = ExerelinUtilsMarket.getCommodityDemandFractionMet(market, "volatiles", true);
                float rareMetalsMet = ExerelinUtilsMarket.getCommodityDemandFractionMet(market, "rare_metals", true);
                float machineryMet = ExerelinUtilsMarket.getCommodityDemandFractionMet(market, "heavy_machinery", true);
                float crewMet = ExerelinUtilsMarket.getCommodityDemandFractionMet(market, "crew", true);
                float fuelSupply = ExerelinUtilsMarket.getCommoditySupply(market, "fuel");
                float utilization = fuelSupply / 2500.0f;
                String msg1 = "Demand met: " + organicsMet + " / " + volatilesMet + " / " + rareMetalsMet + " / " + machineryMet + " / " + crewMet;
                Console.showMessage((String)msg1);
                String msg2 = "Production: " + (int)fuelSupply + " (capacity utilization " + (int)(utilization * 100.0f) + "%)";
                Console.showMessage((String)msg2);
                break;
            }
            case "heavy_machinery": {
                break;
            }
            default: {
                Console.showMessage((String)"Sorry, not supported yet");
                return BaseCommand.CommandResult.ERROR;
            }
        }
        return BaseCommand.CommandResult.SUCCESS;
    }
}

