/*
 * Decompiled with CFR 0.152.
 */
package exerelin.console.commands;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.Console;
import org.lwjgl.util.vector.Vector2f;

public class ResetClosestMarket
implements BaseCommand {
    public BaseCommand.CommandResult runCommand(String args, BaseCommand.CommandContext context) {
        if (context != BaseCommand.CommandContext.CAMPAIGN_MAP) {
            Console.showMessage((String)"Error: This command is campaign-only.");
            return BaseCommand.CommandResult.WRONG_CONTEXT;
        }
        SectorAPI sector = Global.getSector();
        CampaignFleetAPI playerFleet = sector.getPlayerFleet();
        List markets = Misc.getMarketsInLocation((LocationAPI)playerFleet.getContainingLocation());
        Vector2f playerPos = playerFleet.getLocation();
        MarketAPI market = null;
        float closestDist = 9999999.0f;
        for (MarketAPI tryMarket : markets) {
            float distance = Misc.getDistance((Vector2f)playerPos, (Vector2f)tryMarket.getPrimaryEntity().getLocation());
            if (!(distance < closestDist)) continue;
            closestDist = distance;
            market = tryMarket;
        }
        if (market == null) {
            Console.showMessage((String)"Unable to find target");
            return BaseCommand.CommandResult.ERROR;
        }
        String ownerId = market.getFactionId();
        ArrayList<String> conds = new ArrayList<String>();
        for (MarketConditionAPI marketConditionAPI : market.getConditions()) {
            conds.add(marketConditionAPI.getId());
        }
        for (String string : conds) {
            market.removeCondition(string);
        }
        market.reapplyConditions();
        for (SubmarketAPI submarketAPI : market.getSubmarketsCopy()) {
            submarketAPI.getCargo().clear();
            submarketAPI.getPlugin().updateCargoPrePlayerInteraction();
        }
        Console.showMessage((String)("Resetting market " + market.getName()));
        return BaseCommand.CommandResult.SUCCESS;
    }
}

