/*
 * Decompiled with CFR 0.152.
 */
package exerelin.console.commands;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.SectorManager;
import java.util.ArrayList;
import java.util.HashSet;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.CommandUtils;
import org.lazywizard.console.Console;

public class SetMarketOwner
implements BaseCommand {
    public BaseCommand.CommandResult runCommand(String args, BaseCommand.CommandContext context) {
        MarketAPI market2;
        if (context != BaseCommand.CommandContext.CAMPAIGN_MAP) {
            Console.showMessage((String)"Error: This command is campaign-only.");
            return BaseCommand.CommandResult.WRONG_CONTEXT;
        }
        if (args.isEmpty()) {
            return BaseCommand.CommandResult.BAD_SYNTAX;
        }
        SectorAPI sector = Global.getSector();
        String[] tmp = args.split(" ");
        String targetName = tmp[0];
        HashSet<SectorEntityToken> entitiesToSearch = new HashSet<SectorEntityToken>();
        for (MarketAPI market2 : Global.getSector().getEconomy().getMarketsCopy()) {
            entitiesToSearch.add(market2.getPrimaryEntity());
        }
        SectorEntityToken target = CommandUtils.findBestTokenMatch((String)targetName, entitiesToSearch);
        if (target == null) {
            Console.showMessage((String)("Error: could not find entity with name '" + targetName + "'!"));
            return BaseCommand.CommandResult.ERROR;
        }
        market2 = target.getMarket();
        if (market2 == null) {
            Console.showMessage((String)("Error: entity '" + target.getName() + "' does not have a market"));
            return BaseCommand.CommandResult.ERROR;
        }
        FactionAPI defenderFaction = market2.getFaction();
        String defenderFactionId = defenderFaction.getId();
        String attackerFactionId = "player_npc";
        if (tmp.length < 2) {
            ArrayList<String> factions = SectorManager.getLiveFactionIdsCopy();
            WeightedRandomPicker picker = new WeightedRandomPicker();
            for (String factionId : factions) {
                if (factionId.equals(defenderFactionId)) continue;
                picker.add((Object)factionId);
            }
            attackerFactionId = (String)picker.pick();
        } else {
            String factionStr = tmp[1];
            FactionAPI fac = CommandUtils.findBestFactionMatch((String)factionStr);
            if (fac == null) {
                Console.showMessage((String)("Error: no such faction '" + factionStr + "'!"));
                return BaseCommand.CommandResult.ERROR;
            }
            attackerFactionId = fac.getId();
        }
        FactionAPI attackerFaction = Global.getSector().getFaction(attackerFactionId);
        SectorManager.captureMarket(market2, attackerFaction, defenderFaction, false, null, 0.0f);
        Console.showMessage((String)("Transferred market " + market2.getName() + " from " + defenderFaction.getDisplayName() + " to " + attackerFaction.getDisplayName()));
        return BaseCommand.CommandResult.SUCCESS;
    }
}

