/*
 * Decompiled with CFR 0.152.
 */
package exerelin.console.commands;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.fleets.InvasionFleetManager;
import exerelin.utilities.ExerelinUtilsFaction;
import java.util.List;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.Console;
import org.lwjgl.util.vector.Vector2f;

public class SpawnInvasionFleetHostile
implements BaseCommand {
    public BaseCommand.CommandResult runCommand(String args, BaseCommand.CommandContext context) {
        float distance;
        if (context != BaseCommand.CommandContext.CAMPAIGN_MAP) {
            Console.showMessage((String)"Error: This command is campaign-only.");
            return BaseCommand.CommandResult.WRONG_CONTEXT;
        }
        SectorAPI sector = Global.getSector();
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        FactionAPI playerAlignedFaction = sector.getFaction(playerAlignedFactionId);
        CampaignFleetAPI playerFleet = sector.getPlayerFleet();
        List<MarketAPI> targets = ExerelinUtilsFaction.getFactionMarkets(playerAlignedFactionId);
        List sources = Global.getSector().getEconomy().getMarketsCopy();
        Vector2f playerPos = playerFleet.getLocationInHyperspace();
        MarketAPI closestTargetMarket = null;
        float closestTargetDist = 9999999.0f;
        MarketAPI closestOriginMarket = null;
        float closestOriginDist = 9999999.0f;
        for (MarketAPI market : targets) {
            distance = Misc.getDistance((Vector2f)playerPos, (Vector2f)market.getPrimaryEntity().getLocationInHyperspace());
            if (!(distance < closestTargetDist)) continue;
            closestTargetDist = distance;
            closestTargetMarket = market;
        }
        for (MarketAPI market : sources) {
            if (market.getFaction() == playerAlignedFaction || !((distance = Misc.getDistance((Vector2f)playerPos, (Vector2f)market.getPrimaryEntity().getLocationInHyperspace())) < closestOriginDist)) continue;
            closestOriginDist = distance;
            closestOriginMarket = market;
        }
        if (closestTargetMarket == null || closestOriginMarket == null) {
            Console.showMessage((String)"Unable to find origin and/or target");
            return BaseCommand.CommandResult.ERROR;
        }
        InvasionFleetManager.InvasionFleetData data = InvasionFleetManager.spawnInvasionFleet(closestOriginMarket.getFaction(), closestOriginMarket, closestTargetMarket, 1.1f, true);
        if (data == null) {
            Console.showMessage((String)"Unable to spawn fleet");
            return BaseCommand.CommandResult.ERROR;
        }
        if (closestOriginMarket.getContainingLocation() != playerFleet.getContainingLocation()) {
            closestOriginMarket.getContainingLocation().removeEntity((SectorEntityToken)data.fleet);
            playerFleet.getContainingLocation().addEntity((SectorEntityToken)data.fleet);
        }
        Console.showMessage((String)("Spawning " + data.fleet.getName() + " from " + closestOriginMarket.getName()));
        Console.showMessage((String)("Oscar Mike to " + closestTargetMarket.getName()));
        data.fleet.setLocation(playerFleet.getLocation().x, playerFleet.getLocation().y);
        return BaseCommand.CommandResult.SUCCESS;
    }
}

