/*
 * Decompiled with CFR 0.152.
 */
package exerelin.console.commands;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.fleets.InvasionFleetManager;
import java.util.List;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.Console;
import org.lwjgl.util.vector.Vector2f;

public class SpawnRespawnFleet
implements BaseCommand {
    public BaseCommand.CommandResult runCommand(String args, BaseCommand.CommandContext context) {
        if (context != BaseCommand.CommandContext.CAMPAIGN_MAP) {
            Console.showMessage((String)"Error: This command is campaign-only.");
            return BaseCommand.CommandResult.WRONG_CONTEXT;
        }
        SectorAPI sector = Global.getSector();
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        FactionAPI playerAlignedFaction = sector.getFaction(playerAlignedFactionId);
        CampaignFleetAPI playerFleet = sector.getPlayerFleet();
        List markets = Global.getSector().getEconomy().getMarketsCopy();
        Vector2f playerPos = playerFleet.getLocationInHyperspace();
        MarketAPI closestTargetMarket = null;
        float closestTargetDist = 9999999.0f;
        for (MarketAPI market : markets) {
            float distance;
            if (market.getFaction() == playerAlignedFaction || market.getContainingLocation() != playerFleet.getContainingLocation() || !((distance = Misc.getDistance((Vector2f)playerPos, (Vector2f)market.getPrimaryEntity().getLocation())) < closestTargetDist)) continue;
            closestTargetDist = distance;
            closestTargetMarket = market;
        }
        if (closestTargetMarket == null) {
            Console.showMessage((String)"Unable to find target");
            return BaseCommand.CommandResult.ERROR;
        }
        InvasionFleetManager.InvasionFleetData data = InvasionFleetManager.spawnRespawnFleet(playerAlignedFaction, closestTargetMarket, closestTargetMarket, false);
        if (data == null) {
            Console.showMessage((String)"Unable to spawn fleet");
            return BaseCommand.CommandResult.ERROR;
        }
        Console.showMessage((String)("Spawning " + data.fleet.getName() + ", sending to " + closestTargetMarket.getName()));
        data.fleet.getContainingLocation().removeEntity((SectorEntityToken)data.fleet);
        playerFleet.getContainingLocation().addEntity((SectorEntityToken)data.fleet);
        data.fleet.setLocation(playerFleet.getLocation().x, playerFleet.getLocation().y);
        return BaseCommand.CommandResult.SUCCESS;
    }
}

