/*
 * Decompiled with CFR 0.152.
 */
package exerelin.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.PluginPick;
import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.BattleCreationPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.CoreCampaignPluginImpl;
import com.fs.starfarer.api.impl.campaign.RuleBasedInteractionDialogPluginImpl;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.CovertOpsManager;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.MiningHelperLegacy;
import exerelin.campaign.NexFleetInteractionDialogPluginImpl;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.alliances.Alliance;
import exerelin.campaign.fleets.ResponseFleetManager;
import exerelin.combat.SSP_BattleCreationPluginImpl;
import exerelin.plugins.ExerelinModPlugin;

public class ExerelinCoreCampaignPlugin
extends CoreCampaignPluginImpl {
    public String getId() {
        return "ExerelinCoreCampaignPlugin";
    }

    public boolean isTransient() {
        return true;
    }

    public void updateEntityFacts(SectorEntityToken entity, MemoryAPI memory) {
        super.updateEntityFacts(entity, memory);
        if (!ExerelinModPlugin.HAVE_STELLAR_INDUSTRIALIST) {
            boolean canMine = MiningHelperLegacy.canMine(entity);
            memory.set("$nex_canMine", (Object)canMine, 0.0f);
        }
        if (entity instanceof AsteroidAPI) {
            memory.set("$isAsteroid", (Object)true, 0.0f);
        }
    }

    public void updatePlayerFacts(MemoryAPI memory) {
        String associatedFactionId = PlayerFactionStore.getPlayerFactionId();
        FactionAPI associatedFaction = Global.getSector().getFaction(associatedFactionId);
        memory.set("$faction", (Object)associatedFaction, 0.0f);
        memory.set("$factionId", (Object)associatedFactionId, 0.0f);
        memory.set("$theFaction", (Object)associatedFaction.getDisplayNameWithArticle(), 0.0f);
        Alliance associatedAlliance = AllianceManager.getFactionAlliance(associatedFactionId);
        if (associatedAlliance != null) {
            AllianceManager.setMemoryKeys(memory, associatedAlliance);
        } else {
            memory.set("$isInAlliance", (Object)false, 0.0f);
        }
    }

    public void updateMarketFacts(MarketAPI market, MemoryAPI memory) {
        memory.set("$reserveSize", (Object)Float.valueOf(ResponseFleetManager.getReserveSize(market)), 0.0f);
        memory.set("$alertLevel", (Object)Float.valueOf(CovertOpsManager.getAlertLevel(market)), 0.0f);
    }

    public void updateFactionFacts(FactionAPI faction, MemoryAPI memory) {
        memory.set("$theFaction", (Object)faction.getDisplayNameWithArticle(), 0.0f);
        memory.set("$warWeariness", (Object)Float.valueOf(DiplomacyManager.getWarWeariness(faction.getId())), 0.0f);
        memory.set("$numWars", (Object)DiplomacyManager.getFactionsAtWarWithFaction(faction, false, false, false).size(), 0.0f);
        Alliance associatedAlliance = AllianceManager.getFactionAlliance(faction.getId());
        if (associatedAlliance != null) {
            AllianceManager.setMemoryKeys(memory, associatedAlliance);
        } else {
            memory.set("$isInAlliance", (Object)false, 0.0f);
        }
    }

    public PluginPick<BattleCreationPlugin> pickBattleCreationPlugin(SectorEntityToken opponent) {
        if (opponent instanceof CampaignFleetAPI) {
            return new PluginPick((Object)new SSP_BattleCreationPluginImpl(), CampaignPlugin.PickPriority.MOD_GENERAL);
        }
        return null;
    }

    public PluginPick<InteractionDialogPlugin> pickInteractionDialogPlugin(SectorEntityToken interactionTarget) {
        if (interactionTarget instanceof CampaignFleetAPI) {
            return new PluginPick((Object)new NexFleetInteractionDialogPluginImpl(), CampaignPlugin.PickPriority.MOD_GENERAL);
        }
        if (!ExerelinModPlugin.HAVE_STELLAR_INDUSTRIALIST && interactionTarget instanceof AsteroidAPI) {
            return new PluginPick((Object)new RuleBasedInteractionDialogPluginImpl(), CampaignPlugin.PickPriority.MOD_GENERAL);
        }
        return null;
    }
}

